unit Values;
{Kinds of values}
interface
Uses ObjList,SysUtils,Classes;
const prec=0.003;
Type TValue=class
     protected
       function rdAsSTring:string;virtual;abstract;
       procedure wrAsString(a:string);virtual;abstract;
       function rdAsFloat:Extended;virtual;abstract;
       procedure wrAsFloat(a:Extended);virtual;abstract;
       function rdAsBoolean:boolean;virtual;abstract;
       procedure wrAsBoolean(a:boolean);virtual;abstract;
     {$IFDEF WIN32}
       function rdAsVariant:variant;virtual;abstract;
       procedure wrAsVariant(a:Variant);virtual;abstract;
     {$ENDIF WIN32}
     public
       property AsString:string read rdAsString write wrAsString;
       property AsFloat:extended read rdAsFloat write wrAsFloat;
       property AsBoolean:boolean read rdAsBoolean write wrAsBoolean;
     {$IFDEF WIN32} 
       property AsVariant:Variant read rdAsVariant write wrAsVariant;
     {$ENDIF}
       function CreateEqu:TValue; virtual;abstract;
       destructor Destroy;override;
     end;
type TNumValue=class(TValue)
     protected
       value:extended;
       function rdAsSTring:string;override;
       procedure wrAsString(a:string);override;
       function rdAsFloat:Extended;override;
       procedure wrAsFloat(a:Extended);override;
       function rdAsBoolean:boolean;override;
       procedure wrAsBoolean(a:boolean);override;
     {$IFDEF WIN32}
       function rdAsVariant:variant;override;
       procedure wrAsVariant(a:Variant);override;
     {$ENDIF}
     public
       constructor Create(const aValue:Extended);
       function CreateEqu:TValue;override;
     end;
type TStrValue=class(TValue)
     protected
       Value:string;
       function rdAsSTring:string;override;
       procedure wrAsString(a:string);override;
       function rdAsFloat:extended;override;
       procedure wrAsFloat(a:extended);override;
       function rdAsBoolean:boolean;override;
       procedure wrAsBoolean(a:boolean);override;
     {$IFDEF WIN32}
       function rdAsVariant:variant;override;
       procedure wrAsVariant(a:Variant);override;
     {$ENDIF}
     public
       constructor Create(const aValue:String);
       function CreateEqu:TValue;override;
     end;
{$IFDEF WIN32}
type TVarValue=class(TValue)
     protected
       Value:variant;
       function rdAsSTring:string;override;
       procedure wrAsString(a:string);override;
       function rdAsFloat:extended;override;
       procedure wrAsFloat(a:extended);override;
       function rdAsBoolean:boolean;override;
       procedure wrAsBoolean(a:boolean);override;
     {$IFDEF WIN32}
       function rdAsVariant:variant;override;
       procedure wrAsVariant(a:Variant);override;
     {$ENDIF}
     public
       constructor Create(const aValue:Variant);
       function CreateEqu:TValue;override;
     end;
{$ENDIF}
type TValStack=class(TObjList)
     protected
        function  rdValue(No:integer):TValue;
     public
        property Value[No:integer]:TValue read rdValue;
        function Pop:TValue;
        procedure  Push(v:TValue);
        property Top:TValue index 0 read rdValue;
     end;
function Cmp(v1,v2:TValue):boolean;

implementation
uses Forms;
Destructor TValue.Destroy;
           begin
             Inherited Destroy;
           end;

function Cmp;
         begin
           {$IFDEF WIN32}
             Result:=v1.AsVariant=v2.AsVariant;
           {$ELSE}
             if (v1 is TNumValue) or (v2 is TNumValue) then
             begin
               Result:=abs(v1.AsFloat-v2.AsFloat)<prec;
             end
             else
               Result:=v1.AsSTring=v2.AsSTring;
           {$ENDIF} 
         end;
function TNumValue.rdAsSTring;
         begin
           Result:=Format('%g',[Value])
         end;
procedure TNumValue.wrAsString;
         begin
           Value:=StrToFloat(a);
         end;
function TNumValue.rdAsFloat;
         begin
           Result:=Value;
         end;
procedure TNumValue.wrAsFloat;
         begin
            Value:=a;
         end;
function TNumValue.rdAsBoolean;
         begin
           if abs(Value)>prec then Result:=True
           else Result:=False;
         end;
procedure TNumValue.wrAsBoolean;
         begin
           if a then value:=-1 else value:=0;
         end;
function TNumValue.CreateEqu;
         begin
           Result:=TNumValue.Create(Value);
         end;
constructor TNumValue.Create;
            begin
              Inherited Create;
              Value:=aValue;
            end;
{$IFDEF WIN32}
function TNumValue.rdAsVariant;
         begin
           Result:=Value;
         end;
procedure TNumValue.wrAsVariant;
          begin
            Value:=a;
          end;
{$ENDIF}

function TStrValue.rdAsSTring;
         begin
           Result:=Value;
         end;
procedure TStrValue.wrAsString;
         begin
           Value:=a;
         end;
function TStrValue.rdAsFloat;
         Var c:Integer;
         begin
           Val(Value,Result,c);
         end;
procedure TStrValue.wrAsFloat;
         begin
           Value:=format('%g',[a]);
         end;
function TStrValue.rdAsBoolean;
         begin
           if Value='' then Result:=True
             else Result:=False;
         end;
procedure TStrValue.wrAsBoolean;
         begin
           if a then Value:=''
                else Value:='';
         end;
{$IFDEF WIN32}
function TStrValue.rdAsVariant;
         begin
           Result:=Value;
         end;
procedure TStrValue.wrAsVariant;
          begin
            Value:=a;
          end;
{$ENDIF}
function TStrValue.CreateEqu;
         begin
           Result:=TStrValue.Create(Value);
         end;
constructor TStrValue.Create;
            begin
              Inherited Create;
              Value:=aValue;
            end;
{$IFDEF WIN32}
function TVarValue.rdAsSTring;
         begin
           Result:=Value;
         end;
procedure TVarValue.wrAsString;
         begin
           Value:=a;
         end;
function TVarValue.rdAsFloat;
         Var c:Integer;
         begin
           Result:=Value;
         end;
procedure TVarValue.wrAsFloat;
         begin
           Value:=a;
         end;
function TVarValue.rdAsBoolean;
         begin
           if Value then Result:=True
             else Result:=False;
         end;
procedure TVarValue.wrAsBoolean;
         begin
           if a then Value:=true
                else Value:=false;
         end;
function TVarValue.rdAsVariant;
         begin
           Result:=Value;
         end;
procedure TVarValue.wrAsVariant;
          begin
            Value:=a;
          end;
function TVarValue.CreateEqu;
         begin
           Result:=TVarValue.Create(Value);
         end;
constructor TVarValue.Create;
            begin
              Inherited Create;
              Value:=aValue;
            end;
{$ENDIF}
function  TValStack.rdValue;
          begin
            Result:=Obj[No] as TValue;
          end;
function  TValStack.Pop;
          begin
            Result:=Top.CreateEqu;
            Delete(0);
          end;
procedure TValStack.Push;
          begin
            Insert(0,v);
          end;
end.
