{ Parse Tree }
unit PrseTree;
interface
Uses SysUtils;
type PNode=^TNode;
     TNode=record
        RuleNo:Word;      {Number of rule}
        Contents:Pointer; {Points to string if it's leaf}
     end;
type TBush=class
        protected
          function rdNode(a:Integer):PNode;
        public
        Count:Word;
        Contents:PNode;
        constructor Create(No:Integer);
        destructor Destroy;override;
        property Nodes[a:Integer]:PNode read rdNode;default;
     end;
type TPrseTree=class
       protected
        function rdNode(a:Integer):PNode;
       public
        Root:TNode;
        constructor Create;
        destructor Destroy;override;
        property Nodes[a:Integer]:PNode read rdNode;default;
        procedure AddBush(No,RuleNo:Integer;Count:word);
        procedure AddString(No:Integer;const S:STring);
     end;
function NodeToStr(n:PNode):string;
function StrConstOf(n:PNode):string;
implementation
function NodeToStr;
         begin
           Result:=PString(n^.Contents)^;
         end;
procedure DestroyNode(N:TNode);
          begin
            if N.RuleNo=0 then
            begin
              if N.Contents<>Nil then
                DisposeStr(N.Contents);
            end
            else
              TBush(N.COntents).Free;
          end;
function ReadNodeNo(b:TBush;Var No:Word):PNode;
          Var i:Integer;
          begin
            Result:=Nil;
            for i:=0 to b.Count-1 do
            begin
              if No=0 then
              begin
                Result:=b[i];exit;
              end;
              dec(No);
              if b[i]^.RuleNo=0 then
              else
              begin
                Result:=ReadNodeNo(TBush(b[i]^.Contents),No);
                if Result<>nil then exit;
              end;

            end;
          end;
constructor TBush.Create;
            begin
              Inherited Create;
              Count:=No;
              GetMem(Contents,No*SIzeOf(TNode));
              FillChar(Contents^,No*SIzeOf(TNode),0);
            end;
destructor  TBush.Destroy;
            Var i:Integer;
            begin
              for i:=0 to Count-1 do
              begin
                DestroyNode(Nodes[i]^);
              end;
              FreeMem(Contents,Count*SIzeOf(TNode));
              Inherited Destroy;
            end;
function    TBush.rdNode;
            begin
              Result:=Contents;
              inc(Result,a);
            end;
{TPrseTree}
function  TPrseTree.rdNode;
          Var No:Word;
          begin
            if a=0 then result:=@Root
            else
            begin
              No:=a-1;
              Result:=ReadNodeNo(TBush(Root.Contents),No);
            end;
          end;
constructor TPrseTree.Create;
            begin
              Inherited Create;
              Root.RuleNo:=0;
              Root.COntents:=Nil;
            end;
destructor TPrseTree.Destroy;
           begin
             DestroyNode(Root);
             Inherited Destroy;
           end;
procedure TPrseTree.AddBush;
          Var N:PNode;
          begin
            N:=Nodes[No];
            N^.RuleNo:=RuleNo;
            N^.Contents:=TBush.Create(Count);
          end;
procedure TPrseTree.AddString;
          Var N:PNode;
          begin
            N:=Nodes[No];
            N^.RuleNo:=0;
            N^.Contents:=newStr(s);
          end;
function StrConstOf(n:PNode):string;
         Var s:string;
         begin
           s:=NodeToStr(n);
           Result:=Copy(s,2,Length(s)-2);
         end;
end.
