unit Ops;
{Virtual machine OpCodes}
interface
uses 
     IExecut,Values;
procedure Register(e:TRegExecutor);
          { Registers operations on Virtual machine }
implementation
{$F+}
procedure oNop(e:IExecutor);
          begin
            inc(e.IP);
          end;
procedure oNegate(e:IExecutor);
          Var v:TValue;
          begin
            v:=e.DSTack.Pop;
            v.AsFloat:=-v.AsFloat;
            e.DStack.Push(v);
            oNop(e);
          end;
procedure Plus(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            if (v1 is TStrValue) or (v2 is TSTrValue) then
            begin
              Res:=TStrValue.Create(v1.AsString+v2.AsSTring);
            end
            else
            begin
              Res:=TNumValue.Create(v1.AsFloat+v2.AsFloat);
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure Minus(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            begin
              Res:=TNumValue.Create(v1.AsFloat-v2.AsFloat);
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure oDiv(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            begin
              Res:=TNumValue.Create(v1.AsFloat/v2.AsFloat);
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure Mul(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            begin
              Res:=TNumValue.Create(v1.AsFloat*v2.AsFloat);
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure oAnd(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            begin
              Res:=TNumValue.Create(0);
              Res.AsBoolean:=v1.AsBoolean And v2.AsBoolean;
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure oOr(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            begin
              Res:=TNumValue.Create(0);
              Res.AsBoolean:=v1.AsBoolean Or v2.AsBoolean;
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure oNot(e:IExecutor);
          Var v,Res:TValue;
          begin
            v:=e.DSTack.Pop;
            Res:=TNumValue.Create(0);
            Res.AsBoolean:=Not(v.AsBoolean);
            v.Free;
            e.Dstack.Push(Res);
            oNop(e);
          end;
procedure oEqu(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            begin
              Res:=TNumValue.Create(0);
              Res.AsBoolean:=Cmp(v1,v2);
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure oNotEqu(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            begin
              Res:=TNumValue.Create(0);
              Res.AsBoolean:=Not Cmp(v1,v2);
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure oGE(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            begin
              Res:=TNumValue.Create(0);
              Res.AsBoolean:=v1.AsFloat >= v2.AsFloat;
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure oLE(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            begin
              Res:=TNumValue.Create(0);
              Res.AsBoolean:=v1.AsFloat <= v2.AsFloat;
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure oG(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            begin
              Res:=TNumValue.Create(0);
              Res.AsBoolean:=v1.AsFloat > v2.AsFloat;
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure oL(e:IExecutor);
          Var v1,v2,Res:TValue;
          begin
            v2:=e.DStack.Pop;
            v1:=e.DStack.Pop;
            begin
              Res:=TNumValue.Create(0);
              Res.AsBoolean:=v1.AsFloat < v2.AsFloat;
            end;
            e.DSTack.Push(Res);
            v1.Free;
            v2.Free;
            oNop(e);
          end;
procedure oJmp(e:IExecutor);
          begin
            e.IP:=e.Code.Int[e.IP+1];
          end;
procedure oJZ(e:IExecutor);
          Var v:TValue;
          begin
            v:=e.DStack.Pop;
            if v.AsBoolean then
            begin
              oNop(e);
              e.IP:=e.IP+SizeOf(Integer);
            end
            else
            begin
              oJMP(e);
            end;
            v.Free;
          end;
procedure oJNZ(e:IExecutor);
          Var v:TValue;
          begin
            v:=e.DStack.Pop;
            if not v.AsBoolean then
            begin
              oNop(e);
              e.IP:=e.IP+SizeOf(Integer);
            end
            else
            begin
              oJMP(e);
            end;
            v.Free;
          end;
procedure oEnd(e:IExecutor);
          begin
            e.Stop:=True;
          end;
procedure otoR(e:IExecutor);
          begin
            e.RStack.Push(e.DSTack.Pop);
            oNop(e);
          end;
procedure oFromR(e:IExecutor);
          begin
            e.DStack.Push(e.RStack.Pop);
            oNop(e);
          end;
procedure oRGet(e:IExecutor);
          begin
            e.DStack.Push(e.RSTack.Top.CreateEqu);
            oNop(e);
          end;
procedure oDup(e:IExecutor);
          begin
            e.DStack.Push(e.DSTack.Top.CreateEqu);
            oNop(e);
          end;
procedure oNum(e:IExecutor);
          begin
            e.DSTack.Push(TNumValue.Create(e.Code.Num[e.IP+1]));
            e.IP:=e.IP+1+sizeof(Extended);
          end;
procedure oStr(e:IExecutor);
          begin
            e.DSTack.Push(TStrValue.Create(e.Code.Str[e.IP+1]));
            e.IP:=e.IP+2+Length(e.Code.Str[e.IP+1]);
          end;
procedure oSet(e:IExecutor);
          Var v,va:TValue;
          begin
            v:=e.DStack.Pop;
            va:=e.DStack.Pop;
            e.Variables[v.AsString].Value:=va;
            v.Free;
            va.Free;
            onop(e);
          end;
procedure oGet(e:IExecutor);
          Var v:TValue;
          begin
            v:=e.DStack.Pop;
            e.DStack.Push(e.Variables[v.AsString].Value.CreateEqu);
            v.Free;
            onop(e);
          end;
procedure oCall(e:IExecutor);
          Var v:TValue;
          begin
            v:=e.DStack.Pop;
            e.Procedures[v.AsSTring].Call;
            v.Free;
            onop(e);
          end;
procedure oFun(e:IExecutor);
          Var v:TValue;
          begin
            v:=e.DStack.Pop;
            e.Procedures[v.AsSTring].Fun;
            v.Free;
            onop(e);
          end;
procedure o2Dup(e:IExecutor);
          begin
            e.Dstack.Push(e.DStack.Value[1].CreateEqu);
            e.Dstack.Push(e.DStack.Value[1].CreateEqu);
            onop(e);
          end;
procedure oDrop(e:IExecutor);
          Var v:TValue;
          begin
            v:=e.DSTack.Pop;
            v.Free;
            inc(e.IP);
          end;

procedure Register(e:TRegExecutor);
          Var op:TOp;
          begin
            With e do
            begin
              RegOp('.',onop);
              RegOp('+',Plus);
              RegOp('-',Minus);
              RegOp('/',oDiv);
              RegOp('*',Mul);
              RegOp('&',oAnd);
              RegOp('|',oOr);
              RegOp('~',oNot);
              RegOp('=',oEqu);
              RegOp('N',oNotEqu);
              RegOp('G',oGE);
              RegOp('L',oLE);
              RegOp('>',oG);
              RegOp('<',oL);
              RegOp('J',oJmp);
              RegOp('Z',oJZ);
              RegOp('z',oJNZ);
              RegOp(';',oEnd);
              RegOp('T',otoR);
              RegOp('F',oFromR);
              RegOp('R',oRGet);
              RegOp('D',oDup);
              RegOp('#',oNum);
              RegOp('S',oStr);
              RegOp('!',oSet);
              RegOp('@',oGet);
              RegOp('C',oCall);
              RegOp('f',oFun);
              RegOp('I',oNegate);
              RegOp('2',o2Dup);
              RegOp('d',oDrop);
            end;
          end;
end.
