unit Makect;
{ Make control table }
interface
Uses CtTable,RulesLst,LexList,ObjList,Classes,LexInfLs,
     SysUtils;
type TLexSet=class(TLexList)
          OnChange:TNotifyEvent;
       procedure AddSet(aSet:TLexSet);
       function Add(L:TLexem):integer;
       function Has(L:TLexem):boolean;
       function IndexOf(L:TLexem):integer;
       function rdAsString:string;
       property AsSTring:string read rdAsString;
     end;
type TLexSetLst=Class(TObjList)
       protected
         function rdLexSet(a:Integer):TLexSet;
         procedure wrChange(a:TNotifyEvent);
       public
        property LexSet[a:Integer]:TLexSet read rdLexSet;
        procedure CreateEmpty(Num:Integer);
        property OnChange:TNotifyEvent write wrChange;
     end;
type TRulLexSetLst=class(TLexSetLst)
        Constructor Create(rl:TRulesLst);
     end;
type TNTLexSetLst=class(TLexSetLst)
        NTs:TLexSet;
        Constructor Create(rl:TRulesLst);
        destructor Destroy;override;
        function NTSet(NT:TLexem):TLexSet;
        function rdAsString(const a:STring):string;
        property AsSTring[const a:string]:string read rdAsSTring;
     end;
type TCTMaker=class
       protected
        fRFirst:TRulLexSetLst;
        fNTFirst,fNTFollow:TNTLexSetLst;
        fRl:TRulesLst;
        fChanged:Boolean;
        fTerms:TLexSet;
        fResult:TCTTable;
        procedure OnSetChange(Sender:TObject);
        procedure FillTerms;
       public
        constructor Create(Rl:TRulesLst);
        destructor Destroy;override;
        procedure ProcFirst(RulNo:Integer);
        procedure ProcFollow(RulNo:Integer);
        procedure FillFirst;
        procedure FillFollow;
        function CreateCT:TCtTable;
        procedure AddSet(RuleNo:Integer;aSet:TLexSet);
     end;
function MakeCTable(rl:TRulesLst):TCtTable;
implementation

function MakeCTable;
         Var m:TCTMaker;
         begin
           m:=TCTMaker.Create(rl);
           Result:=m.CreateCT;
           m.Free;
         end;
procedure  MarkEps(l:TRulesLst);
           procedure MarkEpsNT(NT:TLexem);
             Var i,j:Integer;
                 r:TLexList;
             begin
               for i:=0 to l.COunt-1 do
               begin
                 if CompareLexems(l.Rules[i].Left,NT) then
                 begin
                   l.Rules[i].Left.IsEps:=True;
                 end;
                 r:=l.Rules[i].Right;
                 for j:=0 to r.Count-1 do
                 begin
                   if CompareLexems(R.Lexems[j],NT) then
                     R.Lexems[j].isEps:=True;
                 end;
               end;
             end;
           Var i,j:Integer;
               r:TLexList;
               Mark:Boolean;
           begin
             for i:=0 to l.Count-1 do
             begin
               if l.Rules[i].Right.Count=0 then
                 Mark:=True
               else
               begin
                 r:=l.Rules[i].Right;
                 Mark:=True;
                 for j:=0 to r.Count-1 do
                 begin
                   if not r.Lexems[j].isEps then Mark:=False;
                 end;
               end;
               if Mark then MarkEpsNT(l.Rules[i].Left)
             end;
           end;
function  TLexSet.rdAsSTring;
          Var i:Integer;
          begin
            for i:=0 to COunt-1 do
            Result:=Result+' '+Lexems[i].AsSTring;
          end;
function  TLexSet.Add;
          begin
            result:=indexof(l);
            if Result=-1 then
            begin
              inherited Add(l.CreateEqu);
              if Assigned(OnChange) then
              begin
                OnChange(Self);
              end;
              Result:=Count-1;
            end;
          end;
procedure  TLexSet.AddSet;
          Var i:Integer;
          begin
            for i:=0 to aSet.Count-1 do
            begin
              Add(aSet.Lexems[i]);
            end;
          end;
function  tLexSet.Has;
          begin
            Has:=IndexOf(l)<>-1;
          end;
function  tLexSet.IndexOf;
          Var i:Integer;
          begin
            Result:=-1;
            for i:=0 to COunt-1 do
             if CompareLexems(Lexems[i],l) then
             begin
               Result:=i;
               exit;
             end;
          end;

function TLexSetLst.rdLexSet;
         begin
           result:=Obj[a] as TLexSet;
         end;
procedure TLexSetLst.wrChange;
          Var i:Integer;
          begin
            for i:=0 to COunt-1 do
              LexSet[i].OnChange:=a;
          end;
procedure TLexSetLst.CreateEmpty;
          Var i:Integer;
          begin
            for i:=0 to Num-1 do
              Add(TLexSet.Create);
          end;

constructor TRulLexSetLst.Create;
            begin
              Inherited Create;
              CreateEmpty(rl.Count);
            end;

constructor TNTLexSetLst.Create(rl:TRulesLst);
            Var i:Integer;
            begin
              Inherited Create;
              NTs:=TLexSet.Create;
              for i:=0 to rl.Count-1 do
                NTs.Add(rl.Rules[i].Left);
              CreateEmpty(NTs.Count);
            end;
destructor  TNTLexSetLst.Destroy;
            begin
              NTs.Free;
              Inherited Destroy;
            end;
function  TNTLexSetLst.NTSet;
          Var i:Integer;
          begin
            Result:=Nil;
            i:=NTs.IndexOf(NT);
            if i=-1 then
            begin
              raise Exception.CreateFmt(' %s  ',[NT.AsSTring]);
            end;
            Result:=LexSet[i];
          end;
function TNTLexSetLst.rdAsString;
         Var I:Integer;
         begin
           for i:=0 to COunt-1 do
           begin
             if NTs.Lexems[i].AsString=a then
             begin
               Result:=LexSet[i].AsSTring;
             end;
           end;
           Result:='  ';
         end;

procedure   TCTMaker.OnSetChange;
            begin
              fChanged:=True;
            end;
procedure   TCTMaker.FillTerms;
            Var i,j:Integer;
                rig:TLexList;
            begin
              for i:=0 to fRL.COunt-1 do
              begin
                rig:=fRL.Rules[i].Right;
                for j:=0 to rig.COunt-1 do
                begin
                  if rig.Lexems[j].Kind.Kind<>lkNeTerm then
                  begin
                    fTerms.Add(rig.Lexems[j]);
                  end;
                end;
              end;
            end;
constructor TCTMaker.Create;
            begin
              Inherited Create;
              fRl:=Rl;
              fRFirst:=TRulLexSetLst.Create(Rl);
              fNTFirst:=TNTLexSetLst.Create(rl);
              fNTFollow:=TNTLexSetLst.Create(rl);
              fRFirst.OnChange:=OnSetChange;
              fNTFirst.OnChange:=OnSetChange;
              fNTFollow.OnChange:=OnSetChange;
              fTerms:=TLexSet.Create;
              FillTerms;
              fTerms.Add(TLexem.Create('|',Unknown));
            end;
destructor  TCTMaker.Destroy;
            begin
              fTerms.Free;
              fRFirst.Free;
              fNTFirst.Free;
              fNTFollow.Free;
              Inherited Destroy;
            end;
procedure TCTMaker.ProcFirst;
          Var i:Integer;
              Rul:TRule;
              Lex:TLexem;
              aSet:TLexSet;
          begin
            Rul:=fRL.Rules[RulNo];
            for i:=0 to Rul.Right.Count-1 do
            begin
              Lex:=Rul.Right.Lexems[i];
              if Lex.Kind.Kind=lkNeTerm then
              begin
                aSet:=fNTFirst.NTSet(Lex);
                fNTFirst.NTSet(Rul.Left).AddSet(aSet);
                fRFirst.LexSet[RulNo].AddSet(aSet)
              end
              else
              begin
                fNTFirst.NTSet(Rul.Left).Add(Lex);
                fRFirst.LexSet[RulNo].Add(Lex)
              end;
              if not Lex.isEps then break;
            end;
          end;
procedure TCTMaker.ProcFollow(RulNo:Integer);
          Var i,j:Integer;
              rul:TRule;
              rig:TLexList;
              Lex,Lex1:TLexem;
              aSet:TLexSet;
          begin
            rul:=fRL.Rules[RulNo];
            rig:=rul.Right;
            for i:=0 to rig.Count-1 do
            begin
              Lex1:=rig.Lexems[i];
              if Lex1.Kind.Kind=lkNeTerm then
              begin
                for j:=i+1 to rig.COunt do
                begin
                  if j=rig.COunt then
                  begin
                    aSet:=fNTFollow.NTSet(rul.Left);
                    fNTFollow.NTSet(Lex1).AddSet(aSet);
                    break;
                  end;
                  Lex:=rig.Lexems[j];

                  if Lex.Kind.Kind=lkNeTerm then
                  begin
                    aSet:=fNTFirst.NTSet(Lex);
                    fNTFollow.NTSet(Lex1).AddSet(aSet);
                  end
                  else
                  begin
                    fNTFollow.NTSet(Lex1).Add(Lex);
                  end;
                  if not rig.lexems[j].isEps then Break;
                end;
              end;
            end;
          end;

procedure TCtMaker.FillFirst;
          Var i:Integer;
          begin
            repeat
              fChanged:=False;
              for i:=0 to fRl.COunt-1 do
              begin
                ProcFirst(i);
              end;
            until not fChanged=True;
          end;
procedure TCtMaker.FillFollow;
          Var i:Integer;
              fir:TLexem;
          begin
            fir:=fRL.Rules[0].Left;
            fNTFollow.NTSet(fir).Add(TLexem.Create('|',Unknown));
            repeat
              fChanged:=False;
              for i:=0 to fRl.COunt-1 do
              begin
                ProcFollow(i);
              end;
            until not fChanged;
          end;
function TCTMaker.CreateCT;
         Var i,j:Integer;
             Rul:TRule;
         begin
           MarkEps(fRl);
           FillFirst;
           FillFollow;
           Result:=TCtTable.CreateFrom(fTerms,fNTFirst.NTs);
           fResult:=Result;
           fResult.Clear;
           for i:=0 to fRL.Count-1 do
           begin
             rul:=fRL.Rules[i];
             if Rul.Right.Count=0 then
             begin
               AddSet(i,fNTFollow.NTSet(rul.Left));
             end
             else
             begin
               AddSet(i,fRFirst.LexSet[i]);
             end;
           end;
         end;
procedure TCTMaker.AddSet;
          Var t,nt:TLexem;
              i:Integer;
          begin
            nt:=fRL.Rules[RuleNo].Left;
            for i:=0 to aSet.Count-1 do
            begin
              t:=aSet.Lexems[i];
              if fResult[nt,t]>0 then
              begin
                raise Exception.Create('   ( '
                      +Nt.AsString+','+t.AsString+' ) - ('+IntToSTr(fResult[nt,t])+','+IntToSTr(RuleNo+1)+')');
              end;
              fResult[nt,t]:=RuleNo+1;
            end;
          end;
end.
