unit Lexinfls;
{Lexem types and list of lexem types}
interface
Uses SysUtils,
     ObjList,Classes,CheckLit;
type TLexemKind=(lkKeyword,lkIdentifier,lkLiteral,lkUnknown,lkString,lkNeterm,lkVariable);
type TDescription=record
                    d:string;
                  end;
type TLexInfo=class
        IsDelimiter:boolean;
        Kind:TLexemKind;
        constructor CreateDesc(D:TDescription);virtual;
        function Check(const S:STring;Start:Integer;Var STop:Integer)
                 :boolean;virtual;abstract;
        function ValueOf(const s:string):Extended;virtual;abstract;
        function Description:string;virtual;
        function Desc:string;virtual;abstract;
        function CreateEqu:TLexInfo;virtual;
     end;
type TLexInfoClass=class of TLexInfo;
type TLexInfLs=class(TObjList)
     protected
        function rdLexInfo(No:Word):TLexInfo;
     public
        procedure readLexInfos(r:TReader);
        procedure writeLexInfos(w:TWriter);
        procedure DefineProperties(f:TFiler);
        property LexInfo[No:Word]:TLexInfo read rdLexInfo;
        function IsDelimiter(const S:string):boolean;
        function GetInfo(const S:string):TLexInfo;
        function GetDelimiter(const S:STring):TLexInfo;
        function CreateEqu:TLexInfls;
        procedure AddToStrings(s:TSTrings);
        procedure ReadFromStrings(s:TSTrings);
     end;
type TLIKeyword=class(TLexInfo)
        Name:PChar;
        constructor Create(S:string);
        constructor CreateDesc(D:TDescription);override;
        function    Check(const S:string;Start:Integer;Var STop:Integer):boolean;override;
        function    Desc:string;override;
     end;
type TLIUnknown=class(TLexInfo)
        constructor Create;
        function Desc:string;override;
     end;
type TLIIdentifier=class(TLexInfo)
        constructor Create;
        constructor CreateDesc(D:TDescription);override;
        function Check(const S:string;Start:Integer;Var STop:Integer):Boolean;override;
        function ValueOf(const s:string):extended;override;
        function Desc:string;override;
     end;
type TLILiteral=class(TLexInfo)
        constructor Create;
        constructor CreateDesc(D:TDescription);override;
        function Check(const S:string;Start:Integer;Var STop:Integer):Boolean;override;
        function ValueOf(const s:string):extended;override;
        function Desc:string;override;
     end;
type TLIString=class(TLexInfo)
        constructor Create;
        constructor CreateDesc(d:TDescription);override;
        function Check(const S:string;Start:Integer;Var STop:Integer):Boolean;override;
        function Desc:string;override;
     end;
type TLINeTerm=class(TLexInfo)
        constructor Create;
        constructor CreateDesc(D:TDescription);override;
        function Check(const S:string;Start:Integer;Var STop:Integer):Boolean;override;
        function Desc:string;override;
     end;
type TLIVariable=class(TLexInfo)
        constructor Create;
        constructor CreateDesc(D:TDescription);override;
        function Check(const S:string;Start:Integer;Var STop:Integer):Boolean;override;
        function Desc:string;override;
     end;
const NumLIs=6;
type  TLIDesc=record
               Key:Char;
               Kind:TLexInfoClass;
             end;
const LexInfos:array[1..NumLIS] of TLIDesc=
      ((Key:'K';Kind:TLIKeyword),
       (Key:'I';Kind:TLIIdentifier),
       (Key:'L';Kind:TLILiteral),
       (KEY:'S';Kind:TLIString),
       (KEY:'N';Kind:TLINeterm),
       (KEY:'V';Kind:TLIVariable));

procedure ReadLexInfs(l:TLexInfLs;FileName:string);
function  CreateFromDesc(s:string):TLexInfo;
function  CharOf(a:TlexInfo):Char;
Var Unknown:TLIUnknown;
    NeTerm:TLINeTerm;
implementation
const UpperCaseLetter:set of char =['A'..'Z'];
      SpecialLetter:set of char=['$','_'];
      Letter:set of char =['A'..'Z','$','_','a'..'z',''..'',''..''];
      Digit:set of char = ['0'..'9'];
constructor TLexInfo.CreateDesc;
            begin
            end;

function  CharOf(a:TLexInfo):Char;
          Var i:Word;
          begin
            Result:='U';
            for i:=1 to NumLIs do
              if a is LexInfos[i].Kind then Result:=LexInfos[i].Key;
          end;
function CreateFromDesc;
         Var i:Integer;
             d:TDescription;
         begin
              for i:=1 to NumLIs do
                if LexInfos[i].Key=S[1] then
                begin
                  d.d:=Copy(S,3,Length(S)-2);
                  Result:=LexInfos[i].Kind.CreateDesc(d);
                end;
         end;
procedure ReadLexInfs(l:TLexInfLs;FileName:string);
          Var f:Text;
              s:string;
              i:Word;
          begin
            AssignFIle(f,FileName);
            Reset(f);
            While not Eof(f) do
            begin
              ReadLn(f,s);
              for i:=1 to NumLIs do
                if LexInfos[i].Key=S[1] then
                  l.Add(CreateFromDesc(S));
            end;
            Close(f);
          end;
function TLexInfo.Description;
         Var i:Integer;
         begin
           for i:=1 to NumLIs do
             if Self is LexInfos[i].Kind then Result:=LexInfos[i].Key;
           if isDelimiter then Result:=Result+' D ' else Result:=Result+' N ';
           Result:=Result+Desc;
         end;
function TLexInfo.CreateEqu;
         begin
           Result:=CreateFromDesc(Description);
         end;
function TLexInfLs.CreateEqu;
         Var i:Integer;
         begin
           Result:=TLexInfLs.Create;
           for i:=0 to COunt-1 do
           begin
             Result.Add(LexInfo[i].CreateEqu);
           end;
         end;
procedure TLexInfLs.AddToStrings(s:TSTrings);
          Var i:Integer;
          begin
            for i:=0 to Count-1 do
              s.Add(LexInfo[i].Description);
          end;
procedure TLexInfLs.ReadFromStrings(s:TSTrings);
          Var i:Integer;
          begin
            Clear;
            for i:=0 to s.COunt-1 do
             Add(CreateFromDesc(s[i]));
          end;
function TLexInfLs.rdLexInfo;
         begin
           Result:=Obj[No] as TLexInfo;
         end;
function TLexInfLs.IsDelimiter;
         begin
            {Result:=False;
            for i:=0 to COunt-1 do
              if LexInfo[i].IsDelimiter then
              if LexInfo[i].Check(S) then Result:=True;}
         end;
function TLexInfLs.GetDelimiter;
         Var
             i:Integer;
         begin
            {Result:=Unknown;
            for i:=0 to COunt-1 do
              if LexInfo[i].IsDelimiter then
              if LexInfo[i].Check(S) then Result:=LexInfo[i];}
         end;
procedure TLexInfLs.DefineProperties(f:TFiler);
          begin
            f.DefineProperty('LexInfos',readLexInfos,writeLexInfos,True);
          end;
procedure TLexInfLs.readLexInfos(r:TReader);
          Var s:string;
              i:Word;
          begin
            r.ReadListBegin;
            While not r.EndOfList do
            begin
              s:=r.ReadString;
              Add(CreateFromDesc(s));
            end;
            r.ReadListEnd;
          end;
procedure TLexInfLs.writeLexInfos(w:TWriter);
          Var i:Integer;
          begin
            w.WriteListBegin;
            for i:=0 to COunt-1 do
              w.WriteSTring(LexInfo[i].Description);
            w.WRiteListEnd;
          end;

function TLexInfLs.GetInfo;
         Var i:Integer;
         begin
          {Result:=Unknown;
           for i:=0 to Count-1 do
           begin
             If LexInfo[i].Check(S) then
             begin
               Result:=LexInfo[i];
               break;
             end;
           end;}
         end;

constructor TLIUnknown.Create;
            begin
              Inherited Create;
              Kind:=lkUnknown;
            end;
function    TLIUnknown.Desc;
            begin
              Result:='Unknown';
            end;
constructor TLIKeyword.Create;
            begin
              Inherited Create;
              Kind:=lkKeyword;
              Name:=StrAlloc(Length(S));
              STrPCopy(Name,S);
            end;
function    TLIKeyword.Desc;
            begin
              Result:=StrPas(Name);
            end;
constructor TLIKeyword.CreateDesc;
            Var S:string;
            begin
              s:=d.d;
              Inherited Create;
              Kind:=lkKeyword;
              isDelimiter:=False;
              if S[1]='D' then IsDelimiter:=True;
              Name:=StrAlloc(Length(S)-1);
              STrPCopy(Name,Copy(S,3,Length(S)-2));
            end;
function    TLIKeyword.Check;
            Var i:Integer;
            begin
              Result:=False;
              if (Length(S)-Start+1)<Length(StrPas(Name)) then exit;
              Result:=True;
              for i:=1 to Length(StrPas(Name)) do
              begin
                if s[Start+i-1]<>StrPas(Name)[i] then
                begin
                  Result:=False;
                  exit;
                end;
              end;
              Stop:=Start+Length(StrPas(Name))-1;
            end;

constructor TLIIdentifier.Create;
            begin
              Inherited Create;
              Kind:=lkIdentifier;
            end;
constructor TLIIdentifier.CreateDesc;
            begin
              Inherited Create;
              Kind:=lkIdentifier;
            end;
function    TLIIdentifier.Desc;
            begin
              Result:='ID';
            end;

function    TLIIdentifier.Check;
            Var i:Integer;
            begin
              Result:=S[Start] in Letter;
              if Result then
              begin
                Stop:=Start;
                for i:=Start+1 to Length(S) do
                if (s[i] in Letter) or (s[i] in Digit) then
                begin
                  Stop:=i;
                end
                else Break;
              end;
            end;

constructor TLILiteral.Create;
            begin
              Inherited Create;
              Kind:=lkLiteral;
            end;
constructor TLILiteral.CreateDesc;
            begin
              Inherited Create;
              Kind:=lkLiteral;
            end;
function    TLILiteral.Desc;
            begin
              Result:='Literal';
            end;

function    TLILiteral.Check;
            begin
              Result:=isLiteral(S,Start,Stop);
            end;

constructor TLIString.Create;
            begin
              Inherited Create;
              Kind:=lkString;
            end;
function    TLIString.Desc;
            begin
              Result:='String';
            end;
constructor TLINeterm.Create;
            begin
              Inherited Create;
              Kind:=lkNeterm;
            end;
function    TLINeterm.Desc;
            begin
              Result:='Neterm';
            end;
constructor TLIVariable.Create;
            begin
              Inherited Create;
              Kind:=lkVariable;
            end;
function    TLIVariable.Desc;
            begin
              Result:='Variable';
            end;

constructor TLIString.CreateDesc;
            begin
              Inherited Create;
              Kind:=lkString;
            end;
constructor TLINeterm.CreateDesc;
            begin
              Inherited Create;
              Kind:=lkNeterm;
            end;
constructor TLIVariable.CreateDesc;
            begin
              Inherited Create;
              Kind:=lkVariable;
            end;

function    TLIString.Check;
            Var i:Integer;
            begin
              Result:=False;
              if S[Start]<>'''' then exit;
              for i:=Start+1 to Length(S) do
                if S[i]='''' then
                begin
                  Result:=True;
                  Stop:=i;
                  exit;
                end;
            end;
function    TLINeTerm.Check;
            Var i:Integer;
            begin
              Result:=False;
              if S[Start]<>'`' then exit;
              for i:=Start+1 to Length(S) do
                if S[i]='`' then
                begin
                  Result:=True;
                  Stop:=i;
                  exit;
                end;
            end;
function    TLIVariable.Check;
            Var i:Integer;
            begin
              Result:=False;
              if S[Start]<>'"' then exit;
              for i:=Start+1 to Length(S) do
                if S[i]='"' then
                begin
                  Result:=True;
                  Stop:=i;
                  exit;
                end;
            end;
function TLIIdentifier.ValueOf;
         begin
           Result:=Length(s);
         end;
function TLILiteral.ValueOf;
         Var e:Extended;
             c:Integer;
         begin
           Val(s,e,c);
           Result:=e;
         end;
begin
  Unknown:=TLIUnknown.Create;
  NeTerm:=TLINeterm.Create;
end.
