unit Inputf;
{ Form for input operations }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,Executor, StdCtrls, Buttons, ExtCtrls,Values;

type
  TInputForm = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
  private
    { Private declarations }
    X,Y:WOrd;
    insEdit:boolean;
    function rdInps(No:Word):string;
  public
    Vars:TStringList;
    fExec:TExecutor;
    { Public declarations }
    procedure Add(S:String);
    function InputCount:Word;
    property Inputs[No:WOrd]:String read rdInps;
    constructor Create(O:TComponent);override;
    destructor Destroy;override;
  end;
procedure Input(e:TExecutor;mustReturn:boolean);
var
  InputForm: TInputForm;

implementation
procedure Input(e:TExecutor;mustReturn:boolean);
          Var f:TInputForm;
              i:Integer;
              v:TValue;
          begin
            f:=TInputForm.Create(Application);
            f.fExec:=e;
            for i:=0 to e.ParamCount-1 do
            begin
              f.Add(e.Params[i].AsString);
            end;
            e.FreeFrame;
            if f.ShowModal=mrOk then
            begin
              if MustReturn then e.DSTack.Push(TNumValue.Create(-1));
              for i:=0 to f.Vars.Count-1 do
              begin
                e.Variables[f.Vars[i]].Value.AsSTring:=f.Inputs[i];
              end;
            end
            else
            begin
              if mustReturn then
              begin
                e.DSTack.Push(TNumValue.Create(0));
              end;
            end;
            f.Free;
          end;
constructor TInputForm.Create(O:TComponent);
            begin
              Inherited Create(o);
              Y:=10;
              X:=10;
              insEdit:=False;
              Vars:=TStringList.Create;
            end;
destructor TInputForm.Destroy;
           begin
             Vars.Free;
             Inherited destroy;
           end;
{$R *.DFM}
function TInputForm.rdInps;
         Var i,j:Integer;
         begin
           j:=0;
           for i:=0 to ControlCount-1 do
           begin
             if Controls[i] is TEdit then
             begin
               if J=No then
               begin
                 Result:=(Controls[i] as TEdit).Text;
                 break;
               end
               else inc(j);
             end;
           end;
         end;
procedure TInputForm.Add(S:String);
         Var c:TControl;
             e:TEdit;
             l:TLabel;
         begin
           if insEdit then
           begin
             Vars.Add(S);
             e:=TEdit.Create(Self);
             e.Top:=y;e.Left:=x;
             e.Text:=fExec.Variables[s].Value.AsSTring;
             y:=y+4+e.Height;
             c:=e;
           end
           else
           begin
             l:=TLabel.Create(Self);
             l.Caption:=s;
             l.Top:=y;
             y:=y+4+l.Height;
             c:=l;
           end;
           InsertControl(c);
           insEdit:=Not InsEdit;
           ClientHeight:=Y+8+Panel1.Height;
         end;
function TInputForm.InputCount;
         Var i:Integer;
         begin
           result:=0;
           for i:=0 to ControlCount-1 do
             if Controls[i] is TEdit then Inc(Result);

         end;

end.
