{ Executor interface }
unit Iexecut;
{ Executor interface }
interface
Uses
  Classes,Values,Code,Variable,Procedur;
{ IExecutor is an abstract interface for virtual machine (see Executor)}
type IExecutor=class(TComponent)
  protected
    fCode:TCode;
    function rdVariables(const s:string):TVariable; virtual;abstract;
    procedure wrVariables(const s:string;v:TVariable);virtual;abstract;
    function rdProcedures(const s:string):TProcedure;virtual;abstract;
    procedure wrProcedures(const s:string;p:TProcedure);virtual;abstract;
    procedure DefineProperties(f:TFiler);override;
  public
      {Retran stack and data stack}
    RStack,DStack:TValStack;
      {Instruction pointer}
    IP:Word;
      {Setting it to true causes execution stopping}
    Stop:boolean;
    property Variables[const s:string]:TVariable read rdVariables write wrVariables;
    property Procedures[const s:string]:TProcedure read rdProcedures write wrProcedures;
    procedure Execute;virtual;abstract;
    procedure Step;virtual;abstract;
  published
    { Published declarations }
    constructor Create(o:TComponent);override;
    destructor  Destroy;override;
    property Code:TCode read fCode write fCode;
  end;
TOp=procedure(e:IExecutor);
TRegisterEvent=procedure (IExecutor:IExecutor) of Object;
type TRegExecutor=class(IExecutor)
     public
       procedure RegOp(c:char;Op:TOp);virtual;abstract;
     end;

implementation
constructor IExecutor.Create;
            begin
              Inherited Create(o);
            end;
destructor  IExecutor.Destroy;
            begin
              Inherited Destroy;
            end;
procedure IExecutor.DefineProperties;
          begin
          end;

end.
