unit Executor;
{ Virtual machine }
interface

uses IExecut,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,Values,Variable,Procedur,Code,ObjList,Ops;

type TProcNotFound=procedure(const Name:string) of Object;
     ERunError=class(Exception)
     end;
     EBadProc=class(ERunError)
        pName:string;
        constructor Create(const s:string);
     end;

type tOpReg=class
       Code:char;
       Op:TOp;
     end;
type  TExecutor = class(TRegExecutor)
  protected
    Operations:TObjList;
    fOnBadProc :TProcNotFound;
    function rdVariables(const s:string):TVariable; override;
    procedure wrVariables(const s:string;v:TVariable);override;
    function rdProcedures(const s:string):TProcedure;override;
    procedure wrProcedures(const s:string;p:TProcedure);override;
    function rdParams(No:Integer):TValue;
    procedure DefineProperties(f:TFiler);override;
  public
    Procs:TProcList;
    Vars:TVarList;
    property Params[No:Integer]:TValue read rdParams;
    procedure RegOp(c:char;Op:TOp);override;
    function  FindOp(c:char):TOpreg;
    procedure BeginExec;
    procedure EndExec;
    procedure Execute;override;
    procedure Step;override;
    procedure FreeFrame;
    function ParamCount:word;
  published
    constructor Create(o:TComponent);override;
    destructor Destroy;override;
    property OnBadProc:TProcNotFound read fOnBadProc write fOnBadProc;
  end;


implementation
constructor EBadProc.Create;
            begin
              Inherited Create('   '+pName);
              pName:=s;
            end;
constructor TExecutor.Create;
            begin
              Inherited Create(o);
              Procs:=TProcList.Create;
              Vars:=TVarList.Create;
              Stop:=True;
            end;
destructor TExecutor.Destroy;
            begin
              Procs.Free;
              Vars.Free;
              Inherited Destroy;
            end;
procedure TExecutor.RegOp;
            Var a:TOpReg;
            begin
              a:=TOpReg.Create;
              a.Code:=c;
              a.Op:=Op;
              Operations.Add(a);
            end;
function  TExecutor.FindOp;
            Var i:Integer;
                a:TOpReg;
            begin
              for i:=0 to Operations.Count-1 do
              begin
                a:=Operations.Obj[i] as TOpReg;
                if a.Code=c then Result:=a;
              end;
            end;
procedure TExecutor.Step;
          Var opr:TOpReg;
          begin
            try
              opr:=FindOp(Chr(Code[IP]));
              if Opr=Nil then raise EXception.Create(' . IP='
                   +IntToSTr(IP));
              opr.op(Self)
            except
              on e:EBadProc do
              begin
                Stop:=True;
                if Assigned(fOnBadProc) then OnBadProc(e.pName)
                else Raise;
              end
            end;
          end;
procedure TExecutor.BeginExec;
          begin
              DStack:=TValStack.Create;
              RStack:=TValStack.Create;
              Operations:=TObjList.Create;
              Ops.Register(Self);
              Stop:=False;
              IP:=0;
          end;
procedure TExecutor.EndExec;
          begin
            DStack.Free;
            RStack.Free;
            Operations.Free;
          end;
procedure TExecutor.Execute;
            begin
              BeginExec;
              While Not stop do
              begin
                Application.ProcessMessages;
                Step;
              end;
              EndExec;
            end;
function TExecutor.rdVariables;
         Var v:TVariable;
         begin
           v:=Vars.Vars(s);
           if v=Nil then
           begin
             v:=TVariable.Create(s);
             Vars.Add(v);
           end;
           Result:=v;
         end;
procedure TExecutor.wrVariables;
         begin
          { v:=fVars.Vars(s);
           if v:=Nil then
           v:=TVariable.Create(s);
           Add(v);
           Result:=v;}
         end;

function TExecutor.rdProcedures;
         Var p:TProcedure;
         begin
           Result:=Procs.Proc(s);
           if Result=Nil then raise EBadProc.Create(s);
         end;
procedure TExecutor.wrProcedures;
         begin
         end;
procedure TExecutor.DefineProperties;
         begin
           Inherited DefineProperties(f);
           f.DefineProperty('Procedures',Procs.Read,Procs.Write,True);
         end;
 procedure TExecutor.FreeFrame;
          Var v,v1:TValue;
              i:Integer;
          begin
            v:=DStack.Pop;
            for i:=1 to Round(v.AsFloat) do
            begin
              v1:=DStack.Pop;
              v1.Free;
            end;
            v.Free;
          end;
function TExecutor.rdParams;
         begin
           Result:=DSTack.Value[ParamCount-No];
         end;
function TExecutor.ParamCount;
         begin
           Result:=Round(DStack.Top.AsFloat);
         end;
end.
