{Form for error list editing}
unit Erredf;
{ Form for Errors editing }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, RXCtrls, Grids, ExtCtrls;
type TAssignEvent=Procedure (Sender:TObject;No:Word) of Object;
type
  TErrEdForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    StringGrid1: TStringGrid;
    RxSpeedButton1: TRxSpeedButton;
    RxSpeedButton2: TRxSpeedButton;
    RxLabel1: TRxLabel;
    RxSpeedButton3: TRxSpeedButton;
    RxSpeedButton4: TRxSpeedButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    RxSpeedButton5: TRxSpeedButton;
    BitBtn1: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure RxSpeedButton3Click(Sender: TObject);
    procedure RxSpeedButton4Click(Sender: TObject);
    procedure RxSpeedButton1Click(Sender: TObject);
    procedure RxSpeedButton2Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure RxSpeedButton5Click(Sender: TObject);
  private
    { Private declarations }
    fErr:TStrings;
    fOnAssign:TAssignEvent;
    procedure RenumberGrid;
  public
    { Public declarations }
    constructor Create(o:TComponent;err:TStrings);
    procedure ShowError(No:Integer);
    procedure EditError(No:Integer);
    procedure NewError;
    property OnAssign:TAssignEvent read fOnAssign write fOnAssign;
  end;

var
  ErrEdForm: TErrEdForm;

implementation

{$R *.DFM}
constructor TErrEdForm.Create;
            begin
              Inherited Create(o);
              fErr:=Err;
              if Err.Count>0 then
                StringGrid1.RowCount:=Err.Count;
              StringGrid1.Cols[1].Assign(Err);
              RenumberGrid;
            end;
procedure TErrEdForm.RenumberGrid;
          Var i:Integer;
          begin
            for i:=0 to STringGrid1.ROwCOunt-1 do
              STringGrid1.Cells[0,i]:=IntToSTr(I+1);
          end;
procedure TErrEdForm.BitBtn1Click(Sender: TObject);
begin
  fErr.Assign(StringGrid1.Cols[1]);
end;

procedure TErrEdForm.RxSpeedButton3Click(Sender: TObject);
begin
  StringGrid1.RowCount:=StringGrid1.RowCount+1;
  RenumberGrid;
end;

procedure TErrEdForm.RxSpeedButton4Click(Sender: TObject);
Var i,r:Integer;
begin
  r:=StringGrid1.Row;
  for i:=r to StringGrid1.RowCOunt-2 do
    StringGrid1.Cells[1,i]:=StringGrid1.Cells[i+1,1];
  StringGrid1.RowCOunt:=StringGrid1.RowCount-1;
  RenumberGrid;
end;

procedure TErrEdForm.RxSpeedButton1Click(Sender: TObject);
Var f:TextFile;
    ln:Integer;
    s:string;
begin
  if OpenDialog1.Execute then
  begin
    StringGrid1.RowCount:=1;
    AssignFile(f,OpenDialog1.FileName);
    Reset(f);
    ln:=0;
    While Not eof(f) do
    begin
      if StringGrid1.RowCount=ln then StringGrid1.RowCount:=StringGrid1.RowCount+1;
      ReadLn(f,s);
      StringGrid1.Cells[1,ln]:=s;
      StringGrid1.Cells[0,ln]:=IntToStr(ln+1);
      inc(ln);
    end;
    CLoseFIle(f);
    RenumberGrid;
  end;
end;

procedure TErrEdForm.RxSpeedButton2Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
  begin
    StringGrid1.Cols[1].SaveToFile(SaveDialog1.FileName);
  end;
end;
procedure TErrEdForm.ShowError;
          begin
            if No>0 then
            begin
              STringGrid1.Row:=No-1;
              StringGrid1.TopRow:=No-1;
            end;
          end;
procedure TErrEdForm.NewError;
          begin
            StringGrid1.RowCount:=STringGrid1.RowCOunt+1;
            RenumberGrid;
            STringGrid1.RowCount:=STringGrid1.RowCount-1;
            StringGrid1.TopRow:=STringGrid1.ROwCount-1;
            StringGrid1.EditorMode:=True;
          end;
procedure TErrEdForm.EditError;
          begin
            ShowError(No);
            StringGrid1.EditorMode:=True;
          end;
procedure TErrEdForm.BitBtn2Click(Sender: TObject);
begin
 CLose;
end;

procedure TErrEdForm.RxSpeedButton5Click(Sender: TObject);
begin
  fErr.Assign(StringGrid1.Cols[1]);
  if Assigned(fOnAssign) then
    OnAssign(Self,StringGrid1.Row+1);
end;

end.
