{ Syntax and lexical parse and compile }
unit Compiler;
{ Syntax and lexical parse and compile }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs,LexInfLs,RulesLst,CtTable,LexStack,
  LexList, PrseTree,LexParse,DebugF,ObjList;
const   {Gived token is not expected}
      errExpected=-1000;
        {Can't accept given token}
      errCantAccept=-1001;
        
{Error while compiling source code}        
type ECompilerError=class(Exception)
         {Line number}
       LineNo,       
         {Token Number} 
       TokenNo,
         {Error code}
       Code:integer;
         {Token string value}
       Token:string;
         {Creates ECompilerError object.}
         {ln - error line number}
         {tkn - tokrn line number }
         {c - error code } 
         {tk - Token string value}
         {msg - error message}
       constructor Create(ln,tkn,c:Integer;const tk,msg:string);
     end;
type TCompiler=class;
     TRuleEvent=procedure(sender:TCompiler;b:TBush) of object;
     THandler=class
          RuleNo:WOrd;
          OnRule:TRuleEvent;
     end;
     THandLst=class(TObjList)
        function rdHandler(R:Integer):TRuleEvent;
        procedure wrHandler(r:Integer;a:TRuleEvent);
        property Handlers[R:Integer]:TRuleEvent read rdHandler write wrHandler;
        procedure Read(r:TReader);
        procedure Write(w:TWriter);
     end;
     TCompilerError=procedure (Sender:TObject;LineNo,TokenNo,ErrorType:Integer; const Token,Msg:string)
                        of Object;
  TStackAvt=class;

  {TCompiler provides lexical and grammar parse }
  TCompiler = class(TComponent)
  private
    { Private declarations }
    fLexems:TLexInfLs;
    fRules:TRulesLst;
    fErrors:TStringList;
    fTable:TCtTable;
    fStackAvt:TStackAvt;
    fTree:TPrseTree;
    fOnError:TCompilerError;
    fOnTreeReady:TNotifyEvent;
    fwasErrors:boolean;
    fHandLst:THandLst;
  protected
    { Protected declarations }
    procedure wrLexems(l:TLexInfLs);
    procedure DefineProperties(f:TFiler);override;
    procedure writeLexems(w:TWriter);
    procedure readLexems(r:TReader);
    procedure writeRules(w:TWriter);
    procedure readRules(r:TReader);
    procedure wrRules(rl:TRulesLst);
    function  rdErrors:TStrings;
    procedure wrErrors(a:TStrings);
    procedure readTable(r:TReader);
    procedure writeTable(w:TWRiter);
    procedure readOnComp(r:TReader);
    procedure writeOnComp(w:TWriter);
    function rdOnCompile(Rule:integer):TRuleEvent;
    procedure wrOnCompile(Rule:Integer;a:TRuleEvent);
  public
    {}
    procedure write(w:TWRiter);
    procedure read(r:TReader);
    {List of grammas rules}
    property Rules:TRulesLst read fRules write wrRules stored false;
    {List of available lexems }
    property Lexems:TLexInfLs read fLexems write wrLexems stored False;
    {Control table}
    property Table:TCtTable read fTable stored false;
    {Parse tree}
    property Tree:TPrseTree read fTree write fTree;
    procedure BeginCompile;
    function  AcceptString(LineNo:word;const s:string):boolean;
    function AcceptStrings(LineNo:word;s:TStrings):boolean;
    function EndCompile:boolean;
    property wasErrors:boolean read fwasErrors;
    procedure Assign(p:TPersistent);override;
    property OnCOmpile[RuleNo:Integer]:TRuleEvent read rdOnCOmpile write
         wrOnCompile;
    procedure CompileBush(b:TBush);
    procedure CompileNode(N:PNode);
  published
    { Published declarations }
    constructor Create(o:TComponent);override;
    destructor Destroy;override;
    property Errors:TStrings read rdErrors write wrErrors;
    property OnError:TCompilerError read fOnError write fOnError;
    property OnTreeReady:TNotifyEvent read fOnTreeReady write fOnTreeReady;
  end;

{procedure Register;}
   TStackAvt=class
     protected
        fStack:TLexStack;
        fCompiler:TCompiler;
        I:Integer;
        function Razv(t:Integer;L:TLexem):Integer;
     public
        constructor Create(c:TCompiler);
        destructor Destroy;override;
        function   Accept(t:integer;L:TLexem):Integer;
        function   CanAccept:boolean;
     end;

implementation
function FindMeth(r:TReader;const s:string):pointer;
var
  Error: Boolean;
  f:TFindMethodEvent;
begin
  if s='' then
  begin
    Result:=Nil;
    exit;
  end;
  Result := r.Root.MethodAddress(s);
  Error := Result = nil;
  f:=r.OnFindMethod;
  if Assigned(f) then r.OnFindMethod(r, s, Result, Error);
  if Error then Result:=Nil;
end;
constructor ECompilerError.Create;
            begin
              Inherited Create(msg);
              LineNo:=ln;
              TokenNo:=tkn;
              Code:=c;
              Token:=tk;
            end;
function THandLst.rdHandler;
         Var i:Integer;
         begin
           Result:=nil;
           for i:=0 to COunt-1 do
           begin
             if r=(Obj[i] as THandler).RuleNo then
             begin
               Result:=(Obj[i] as THandler).OnRule;
               break;
             end;
           end;
         end;
procedure THandLst.wrHandler;
         Var i:Integer;
             h:THandler;
             m:TMethod;
             p:Array[0..20] of char;
             s:string;
         begin
           for i:=0 to COunt-1 do
           begin
             h:=Obj[i] as THandler;
             if r=h.RuleNo then
             begin
               h.OnRule:=a;
               exit;
             end;
           end;
           h:=THandler.Create;
           h.RuleNo:=r;
           h.OnRule:=a;
           Add(h);
           m:=TMethod(a);
         end;
procedure THandLst.Read;
         Var h:THandler;
             m:TMethod;
             s:string;
             p:array[0..100] of char;
         begin
           r.ReadListBegin;
           While not r.EndOfList do
           begin
             h:=THandler.Create;
             h.RuleNo:=r.ReadInteger;
             s:=r.ReadIdent;
{             Application.MessageBox(StrPCopy(p,r.Root.ClassName),'!',mb_Ok);}
             m.Code:=FindMeth(r,s);
             m.Data:=r.Root;
             h.OnRule:=TRuleEvent(m);
             if m.COde=nil then
{               Application.MessageBox(StrPCopy(p,s),'!!',mb_Ok)}
             else
               Add(h);
           end;
           r.ReadListEnd;
         end;
procedure THandLst.Write;
         Var i:Integer;
             r:TRuleEvent;
             m:TMethod;
             p:Array[0..20] of char;
         begin
           w.WRiteListBegin;
           for i:=0 to COunt-1 do
           begin
             r:=(Obj[i] as THandler).OnRule;
             m:=TMethod(r);
             w.WriteInteger((Obj[i] as THandler).RuleNo);
             w.WriteIdent(w.Root.MethodName(m.Code));
   {          Application.MessageBox(StrPCopy(p,w.Root.ClassNaME{MethodName(m.Code)),'!',mb_Ok);}
           end;
           w.WriteListEnd;
         end;
{TStackAvt}
function TStackAvt.Razv;
          Var No:Integer;
              aRule:TRule;
          begin
            No:=fCompiler.Table[fStack.top,l];
            if No>0 then
            begin
              Result:=1;
              aRule:=fCompiler.Rules.Rules[No-1];
              fStack.Drop;
              fStack.Add(aRule.Right);
              fCompiler.Tree.AddBush(i,No,aRule.Right.Count);
              inc(i);
            end
            else
            begin
              Result:=No;
              if No<>0 then
              begin
                if No=clNotFound then
                begin
                  raise ECompilerError.Create(0,t,No,
                   l.AsSTring,'Can''t be here');
                end
                else
                begin
                  raise ECompilerError.Create(0,t,No,
                      l.AsSTring,fCompiler.Errors[(-No)-1]);
                end;
              end
              else
              raise ECompilerError.Create(0,t,No,
                l.AsSTring,'Unknown error');
            end;
          end;
constructor TStackAvt.Create;
          begin
            Inherited Create;
            fStack:=TLexStack.Create;
            fCompiler:=c;
            fStack.AddLexem(EndMark);
            fStack.AddLexem(Root);
            if fCompiler.Tree<>nil then fCompiler.Tree.Free;
            fCompiler.Tree:=TPrseTree.Create;
            i:=0;
          end;
destructor TStackAvt.Destroy;
          begin
            Inherited Destroy;
            fStack.Destroy;
            if fCompiler.Tree<>nil then
            fCompiler.Tree.Free;
            fCompiler.Tree:=Nil;
          end;
function   TStackAvt.Accept;
          begin
            if Not CanAccept then
                raise ECompilerError.Create(0,t,errCantAccept,
                l.AsSTring,'End of text expected');

            While (fSTack.Top.Kind.Kind = lkNeterm) do
            begin
              Result:=Razv(t,l);
              if Result<=0 then exit;
            end;
            if CompareLexems(l,fSTack.Top) then
            begin
              fSTack.Drop;
              if l<>EndMark then
              begin
                fCompiler.Tree.AddString(i,l.AsSTring);
                inc(i);
              end;
            end
            else
            begin
              if fStack.Top.AsSTring='|' then
              begin
              raise ECompilerError.Create(0,t,errExpected,
                l.AsSTring,'End of text expected');
              end
              else
              raise ECompilerError.Create(0,t,errExpected,
                l.AsSTring,'Expected : '+fSTack.Top.AsSTring);

            end;
     {       ShowLexList(fSTack);}
          end;
function  TStackAvt.CanAccept;
          begin
            Result:=fStack.Count>0;
          end;

{TCompiler}
function TCompiler.rdErrors;
         begin
           Result:=fErrors;
         end;
procedure TCompiler.wrErrors;
          begin
            fErrors.Assign(a);
          end;
constructor TCompiler.Create;
            begin
              Inherited Create(o);
              fLexems:=TLexInfLs.Create;
              fRules:=TRulesLst.Create;
              fErrors:=TSTringList.Create;
              fTable:=TCtTable.Create;
              fHandLst:=THandLst.Create;
            end;
destructor TCompiler.Destroy;
            begin
              fHandLst.Free;
              fTable.Free;
              fRules.Free;
              fLexems.Free;
              fErrors.Free;
              if fTree<>Nil then fTree.Free;
              Inherited Destroy;
            end;
procedure TCompiler.wrRules;
          begin
            fRules.Assign(rl);
          end;
procedure TCompiler.writeLexems(w:TWriter);
          begin
             fLexems.writeLexInfos(w);
          end;
procedure TCompiler.readLexems(r:TReader);
          begin
            fLexems.readLexInfos(r);
          end;
procedure TCompiler.writeRules(w:TWriter);
          begin
             fRules.write(w);
          end;
procedure TCompiler.readRules(r:TReader);
          begin
            fRules.read(r,fLexems);
          end;
procedure TCompiler.writeTable(w:TWriter);
          begin
             fTable.write(w);
          end;
procedure TCompiler.readTable(r:TReader);
          begin
            fTable.read(r,fLexems);
          end;

procedure TCompiler.DefineProperties;
          begin
            Inherited DefineProperties(f);
            f.DefineProperty('LexemInfoList',readLexems,writeLexems,True);
            f.DefineProperty('RulesList',readRules,writeRules,True);
            f.DefineProperty('ControlTable',readTable,writeTable,True);
            f.DefineProperty('OnCompile',readOnComp,writeOnCOmp,True);
          end;

procedure TCompiler.wrLexems;
          begin
            if fLexems<>Nil then fLexems.Free;
            if l<>nil then
              fLexems:=l.CreateEqu;
          end;
procedure TCompiler.BeginCompile;
          begin
            fStackAvt:=TStackAvt.Create(Self);
            fwasErrors:=False;
          end;
function TCompiler.AcceptString;
          Var l:TLexList;
              i,Res:Integer;

          begin
            Result:=True;
            l:=TLexList.Create;
            ParseString(l,Lexems,s);
            try
              for i:=0 to l.COunt-1 do
              begin
                Res:=fSTackAvt.Accept(i,l.Lexems[i]);
              end;
            except
              on e:ECompilerError do
              begin
                Result:=false;
                fwasErrors:=True;
                if Assigned(fOnError) then
                  OnError(Self,LineNo,e.TokenNo,e.COde,e.Token,e.Message)
                else
                  Raise;
              end;
            end;
            l.Free;
          end;
function TCompiler.AcceptStrings;
          Var i:integer;
          begin
            for i:=0 to s.COunt-1 do
            begin
              if not AcceptString(LineNo+i,s[i]) then
              begin
                Result:=False;
                break;
              end;
            end;
          end;
function TCompiler.EndCompile;
          begin
            Result:=fWasErrors;
            try
              if not fWasErrors then
                fSTackAvt.Accept(0,EndMark);
            except
              on e:ECOmpilerError do
              begin
                Result:=False;
                fwasErrors:=True;
                fStackAvt.Free;
                if Assigned(fOnError) then
                  OnError(Self,30000,e.TokenNo,e.COde,e.Token,e.Message)
                else
                  Raise;
              end;
            end;
            if not fWasErrors then
            begin
              if Assigned(fOnTreeReady) and (not wasErrors) then OnTreeReady(Self);
              CompileNode(@(Tree.Root));
            end;
            fStackAvt.Free;
          end;
procedure TCompiler.Write;
          Var i:Integer;
          begin
            writeLexems(w);
            writeRules(w);
            writeTable(w);
            w.WRiteListBegin;
            for i:=0 to Errors.Count-1 do w.WRiteSTring(Errors[i]);
            w.WRiteListEnd;
          end;
procedure TCompiler.Read;
          begin
            readLexems(r);
            readRules(r);
            readTable(r);
            Errors.Clear;
            r.ReadListBegin;
            While not r.EndOfList do
            begin
              Errors.Add(r.ReadString);
            end;
            r.ReadListEnd;
          end;
procedure TCompiler.Assign;
          begin
            Inherited Assign(p);
            Application.MessageBox('ASSIGN','ASSIGN',mb_Ok);
          end;
function  TCompiler.RdOnCOmpile;
          begin
            Result:=fHandLst.Handlers[Rule]
          end;
procedure  TCompiler.wrOnCOmpile;
          begin
            fHandLst.Handlers[Rule]:=a;
          end;
procedure TCompiler.readOnComp(r:TReader);
          begin
            fHandLst.read(r);
          end;
procedure TCompiler.writeOnComp(w:TWriter);
          begin
            fHandLst.write(w);
          end;
procedure TCompiler.compileBush;
          Var i:Integer;
          begin
            for i:=0 to b.COunt-1 do
            begin
              CompileNode(b[i]);
            end;
          end;
procedure TCompiler.compileNode;
          Var o:TRuleEvent;
          begin
            if n^.RuleNo<>0 then
            begin
              o:=OnCompile[n^.RuleNo];
              if Assigned(o) then
              begin
                o(Self,TBush(n^.COntents));
              end
              else
              begin
                CompileBush(TBush(n^.Contents));
              end;
            end;
          end;
end.
