{ TCode class Stores virtual machine code and provides access to it}
unit Code;
{ TCode class Stores virtual machine code and provide access }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  {TCode stores virtual machine code and provide}
  {access to it. }
  TCode = class(TComponent)
  private
  protected
    fSize:word;
    procedure wrSize(a:word);
    procedure wrElems(No:word;a:Byte);
    function rdElems(No:word):Byte;
    procedure wrInt(No:Word;a:Integer);
    function  rdInt(No:Word):Integer;
    function  rdNum(No:word):extended;
    function  rdStr(No:word):string;
    procedure wrNum(No:word;a:extended);
    procedure wrStr(No:word;a:string);
  public
    {Pointer to datablock containing code}
    Body:PByte;
    {Provides access to code elements as bytes array }
    property Elements[a:WOrd]:Byte read rdElems write wrElems;default;
    {Provides access to code as array of integers}
    property Int[a:word]:Integer read rdInt write wrInt;
    {Provides access to code as array of extended}
    property Num[a:word]:Extended read rdNum write wrNum;
    {Provides access to code as array of string}
    property Str[a:word]:string read rdStr write wrStr;
    {Load code form file named aFileName}
    procedure LoadFromFile(const aFileName:String);
    {Save code to file named aFileName}
    procedure SaveToFile(const aFileName:String);
  published
    { Maximal size of  code in bytes}
    property Size:word read fSize write wrSize default 0;
    constructor Create(o:TComponent);override;
    destructor  Destroy;override;
  end;


implementation

procedure TCode.wrSize;
          begin
            if fSize<>0 then FreeMem(Body,Size*SizeOf(Byte));
            fSize:=a;
            if fSize<>0 then GetMem(Body,Size*SizeOf(Byte));
          end;
procedure TCode.wrElems(No:word;a:Byte);
          Var c:PByte;
          begin
            c:=Body;
            inc(c,No);
            c^:=a;
          end;
function TCode.rdElems(No:word):Byte;
          Var c:PByte;
          begin
            c:=Body;
            inc(c,No);
            Result:=c^;
          end;
procedure TCode.wrInt;
          Var c:PByte;
          begin
            c:=Body;
            inc(c,No);
            PInteger(c)^:=a;
          end;
function TCode.rdInt;
          Var c:PByte;
          begin
            c:=Body;
            inc(c,No);
            Result:=PInteger(c)^;
          end;
function  TCode.rdNum(No:word):extended;
          Var e:Extended;
              p:PByte;
              i:Integer;
          begin
            p:=PByte(@e);
            for i:=0 to SizeOf(e)-1 do
            begin
              p^:=Self[No+i];
              inc(p);
            end;
            Result:=e;
          end;
function  TCode.rdStr(No:word):string;
          Var i:Integer;
          begin
            {$IFDEF WIN32}
              SetLength(Result,Self[No]);
            {$ELSE}
              Result[0]:=Chr(Self[No]);
            {$ENDIF}
            for i:=1 to Length(Result) do
              Result[i]:=Chr(Self[No+i]);
          end;
constructor TCode.Create;
            begin
              inherited Create(o);
              fSize:=0;
              Size:=0;
            end;
destructor  TCode.Destroy;
            begin
              Inherited Destroy;
            end;
procedure   TCode.wrNum;
          Var p:PByte;
              i:Integer;
          begin
            p:=PByte(@a);
            for i:=0 to SizeOf(a)-1 do
            begin
              Self[No+i]:=p^;
              inc(p);
            end;
          end;
procedure   TCode.wrStr;
            Var i:Integer;
            begin
              Self[No]:=Length(a);
              for i:=1 to Length(a) do
                Self[No+i]:=Ord(a[i]);
            end;
    {Load code form file named aFileName}
procedure TCode.LoadFromFile(const aFileName:String);
          Var f:TFileStream;
              r:TReader;
          begin
            f:=TFileStream.Create(aFileName,fmOpenRead);
            r:=TReader.Create(f,1024);
            Size:=r.ReadInteger;
            r.Read(Body^,Size);
            r.Free;
            f.Free;
          end;
{Save code to file named aFileName}
procedure TCode.SaveToFile(const aFileName:String);
          Var f:TFileStream;
              w:TWriter;
          begin
            f:=TFileStream.Create(aFileName,fmCreate);
            w:=TWriter.Create(f,1024);
            w.writeInteger(Size);
            w.write(Body^,Size);
            w.Free;
            f.Free;
          end;

end.
