{Control table - this table determines how source text is parsed}
unit Cttable;
{Control table - this table determines how source text is parsed}
interface
Uses LexList,LexInfLs,WinTypes,ObjList,LexParse,
     Classes;
const clNotFound=-30000;
type TIntegerTable=class
       private
         fRowCount,fColCount:Word;
         fBody:PInteger;
         procedure wrItems(r,c:word;a:Integer);
         function  rdItems(r,c:WOrd):Integer;
       public
         constructor Create(Rows,Cols:Integer);
         destructor Destroy;override;
         property Items[r,c:word]:Integer read rdItems write wrItems;default;
         property RowCount:WOrd read fRowCount;
         property ColCount:WOrd read fColCount;
         function CreateEqu:TIntegerTable;
         procedure write(w:TWRiter);
         constructor CreateRead(r:TReader);

     end;
{Control table stores logic of syntax parse }
type TCtTable=class
             private
               function rdItem(Row,Col:Word):Integer;
               function rdCell(NonTerm,Term:TLexem):Integer;
               procedure wrCell(NonTerm,Term:TLexem;a:Integer);
               procedure wrItem(Row,COl:WOrd;a:Integer);
             public
               Terms:TLexList;
               NonTerms:TLexList;
               Table:TIntegerTable;
               constructor Create;
               constructor CreateFrom(aTerms,aNTerms:TLexList);
               property Items[R,C:Word]:Integer read rdItem write wrItem;
               destructor  Destroy;override;
               property Cells[NonTerm,Term:TLexem]:Integer read rdCell write wrCell ;default;
               function RowCount:Word;
               function ColCount:Word;
               procedure Clear;
               procedure Read(r:TReader;lil:TLexInfLs);
               procedure Write(w:TWriter);
               function isEmpty:boolean;
               procedure Assign(t:TCtTable);
               procedure Compose(t:TCtTable);
              end;
 function CompareLexems(a,b:TLexem):boolean;
implementation
 function CompareLexems(a,b:TLexem):boolean;
          begin
            Result:=False;
            if a.Kind.Kind=b.Kind.Kind then
            begin
              Result:=True;
              if a.Kind.Kind in [lkKeyword,lkUnknown,lkNeTerm] then
              begin
                Result:=a.AsString=b.AsString;
              end;
            end;
            if Result then
            begin
              Result:=True;
            end;
          end;
procedure TIntegerTable.wrItems;
          Var p:PInteger;
          begin
            p:=fBody;
            inc(p,r*ColCount+c);
            p^:=a;
          end;
function  TIntegerTable.rdItems;
          Var p:PInteger;
          begin
            p:=fBody;
            inc(p,r*ColCount+c);
            Result:=p^;
          end;
constructor TIntegerTable.Create;
          begin
            Inherited Create;
            fRowCount:=Rows;
            fColCount:=Cols;
            GetMem(fBody,Rows*Cols*SizeOf(Integer));
          end;
procedure TIntegerTable.write(w:TWRiter);
          Var i,j:Integer;
    {            f:TextFile;}
          begin
{              AssignFile(f,'Write.Log');
              Rewrite(f);}
            w.WRiteInteger(RowCOunt);
            w.WRiteInteger(ColCOunt);
            for i:=0 to RowCount-1 do
            begin
              for j:=0 to ColCount-1 do
              begin
                w.WriteInteger(Items[i,j]);
{                WriteLn(f,i,' ',j,' ',items[i,j]);}
              end;
            end;
{            CloseFile(f);}
          end;
constructor TIntegerTable.CreateRead(r:TReader);
            Var i,j:Integer;
{                f:TextFile;}
            begin
{              AssignFile(f,'Read.Log');
              Rewrite(f);               }
              Inherited Create;
              fRowCount:=r.ReadInteger;
              fColCount:=r.ReadInteger;
              GetMem(fBody,fRowCount*fColCOunt*SIzeOf(Integer));
            for i:=0 to RowCount-1 do
            begin
              for j:=0 to ColCount-1 do
              begin
                Items[i,j]:=r.ReadInteger;
{                WriteLn(f,i,' ',j,' ',items[i,j]);
}              end;
            end;
{            CloseFile(f);
}            end;
destructor TIntegerTable.Destroy;
          begin
            FreeMem(fBody,RowCount*ColCOunt*SizeOf(Integer));
            inherited destroy;
          end;
function  TIntegerTable.CreateEqu;
          begin
            Result:=TIntegerTable.Create(RowCount,ColCount);
            Move(fBody^,Result.fBody^,RowCount*COlCOunt*SizeOf(Integer));
          end;

function  TCtTable.rdItem;
          begin
            if Table=Nil then Exit;
            Result:=Table[Row,Col];
          end;
function  TCtTable.rdCell;
          Var i:Integer;
              Row,Col:Integer;
          begin
            if Terms=Nil then Exit;
            Row:=-1;
            for i:=0 to RowCOunt-1 do
            begin
              if CompareLexems(NonTerms.Lexems[i],NonTerm) then
              begin
                Row:=i;break;
              end;
            end;
            Col:=-1;
            for i:=0 to COlCOunt-1 do
            begin
              if CompareLexems(Terms.Lexems[i],Term) then
              begin
                Col:=i;break;
              end;
            end;
            if (Col=-1) or (row=-1)then Result:=clNotFound
            else Result:=Items[Row,Col];
          end;
procedure  TCtTable.wrCell;
          Var i:Integer;
              Row,Col:Integer;
          begin
            if Terms=Nil then exit;
            Row:=-1;
            for i:=0 to RowCOunt-1 do
            begin
              if CompareLexems(NonTerms.Lexems[i],NonTerm) then
              begin
                Row:=i;break;
              end;
            end;
            Col:=-1;
            for i:=0 to COlCOunt-1 do
            begin
              if CompareLexems(Terms.Lexems[i],Term) then
              begin
                Col:=i;break;
              end;
            end;
            if (Row=-1) or (COl=-1) then exit;
            Items[Row,Col]:=a;
          end;
constructor TCtTable.CreateFrom;
          begin
            Inherited Create;
            Terms:=aTerms.CreateEqu;
            NonTerms:=aNTerms.CreateEqu;
            Table:=TIntegerTable.Create(aNTerms.Count,aTerms.Count);
          end;
constructor TCtTable.Create;
          begin
            Inherited Create;
            Terms:=TLexList.Create;
            NonTerms:=TLexList.Create;
            Table:=TIntegerTable.Create(1,1);
          end;
destructor  TCtTable.Destroy;
           begin
             if Table<>Nil then
             begin
               Terms.Free;
               NonTerms.Free;
               Table.Free;
             end;
             Inherited Destroy;
           end;
function   TCtTable.RowCount;
           begin
            if Table=Nil then Exit;
             Result:=NonTerms.COunt;
           end;
function   TCtTable.ColCount;
           begin
            if Table=Nil then Exit;
             Result:=Terms.Count;
           end;
function   TCtTable.isEmpty;
           begin
             Result:=(ColCount=0) or (RowCount=0);
           end;
procedure  TCtTable.WrItem;
           begin
            if Table=Nil then Exit;
             Table[Row,Col]:=a;
           end;
procedure  TCtTable.Clear;
           Var i,j:Integer;
           begin
            if Table=Nil then Exit;
             for i:=0 to RowCount-1 do
               for j:=0 to ColCount-1 do
                 Items[i,j]:=0;
           end;
procedure  TCTTable.Read;
           begin
             Terms.Read(r,Lil);
             NonTerms.Read(r,Lil);
             Table.Free;
             Table:=TIntegerTable.CreateRead(r);
           end;
procedure  TCTTable.write;
           begin
             Terms.Write(w);
             NonTerms.WRite(w);
             Table.Write(w);
           end;
procedure  TCtTable.Assign;
           begin
             Terms.Free;
             NonTerms.Free;
             Table.Free;
             Terms:=t.Terms.CreateEqu;
             NonTerms:=t.NonTerms.CreateEqu;
             Table:=t.Table.CreateEqu;
           end;
procedure  TCtTable.Compose;
           Var r,c,v,tmp:Integer;
               te,nt:TLexem;

           begin
             if t.isEmpty or isEmpty then
             begin
               exit;
             end;
             for r:=0 to t.RowCount-1 do
               for c:=0 to t.ColCount-1 do
               begin
                 te:=t.Terms.Lexems[c];
                 nt:=t.NonTerms.Lexems[r];
                 v:=t[nt,te];
                 if v<>clNotFound then
                 begin
                   tmp:=Cells[nt,te];
                   if (Tmp<=0) and (v<=0) then
                   Cells[nt,te]:=v;
                 end;
               end;

           end;
end.
