{ Component writer's tools }
{ examples see in compiler VCL library }
{ http://www.geocities.com/SiliconValley/Pines/1605 }
unit Comptool;
interface
{$IFDEF VER93}
   {$DEFINE CBUILDER}
{$ENDIF}
Uses Classes,SysUtils,TypInfo;
type
   TParamFlags = set of (pfVar, pfConst, pfArray, pfAddress, pfReference);
   {Extended for C++ Builder}
type  PParamData = ^TParamData;
  TParamData = record
    Flags: TParamFlags;
    ParamNameAndType: array[0..100] of Char;
  end;
procedure FillParam(P:PChar;A:array of string);
function FindMeth(r:TReader;const s:string):pointer;
procedure ReadMeth(r:TReader;var m:TMethod);
procedure WriteMeth(w:TWriter;m:TMethod);
type PByte=^Byte;
type TParamsAdder=class
     public
        Body:Pointer;
        Cur:PByte;
        constructor Create(p:Pointer);
        procedure AddParam(Flags:TParamFlags;const Name,TypeName:string);
        procedure AddObjectParam(const Name,TypeName:string);
     protected
        procedure AddFlags(Flags:TParamFlags);
        procedure AddString(const s:string);
     end;
implementation
procedure FillStr(P:PChar;const S:string);
          Var i:Integer;
          begin
            p[0]:=Char(Length(S));
            for i:=1 to Length(s) do
            begin
              p[i]:=s[i];
            end;
          end;
procedure FillParam(P:PChar;A:array of string);
          Var i:Integer;
              c:Integer;
              par:TParamFlags;
              fl:Boolean;
              aP:PChar;
          begin
            c:=0;
            par:=[];
            fl:=False;
            for i:=Low(a) to High(a) do
            begin
              aP:=p;inc(aP,c);
              FillStr(aP,a[i]);
              c:=c+Length(a[i])+1;
              if fl then
              begin
                Move(par,p[c],SizeOf(TParamFlags));
                c:=c+SizeOf(TParamFlags);
              end;
              fl:=not fl;
            end;
          end;
function FindMeth(r:TReader;const s:string):pointer;
var
  Error: Boolean;
  f:TFindMethodEvent;
begin
  if s='' then
  begin
    Result:=Nil;
    exit;
  end;
  Result := r.Root.MethodAddress(s);
  Error := Result = nil;
  f:=r.OnFindMethod;
  if Assigned(f) then r.OnFindMethod(r, s, Result, Error);
  if Error then Result:=Nil;
end;
procedure ReadMeth(r:TReader;var m:TMethod);
         begin
           m.Data:=r.Root;
           m.COde:=FindMeth(r,r.ReadIdent);
         end;
procedure WriteMeth(w:TWriter;m:TMethod);
         begin
           w.WriteIdent(w.Root.MethodName(m.Code));
         end;
constructor TParamsAdder.Create(p:Pointer);
            begin
              Body:=p;
              Cur:=p;
            end;
procedure   TParamsAdder.AddParam(Flags:TParamFlags;const Name,TypeName:string);
            begin
              AddFlags(Flags);
              AddString(Name);
              AddString(TypeName);
            end;
type PParamFlags=^TParamFlags;
procedure   TParamsAdder.AddFlags(Flags:TParamFlags);
            Var pf:PParamFlags;
            begin
              pf:=PParamFlags(Cur);
              pf^:=Flags;
              inc(Cur,Sizeof(TParamFlags));
            end;
procedure   TParamsAdder.AddString(const s:string);
            Var i:Integer;
            begin
              Cur^:=Length(S);
              inc(Cur);
              for i:=1 to Length(s) do
              begin
                Cur^:=Ord(S[i]);
                inc(Cur);
              end;
            end;
procedure   TParamsAdder.AddObjectParam(const Name,TypeName:string);
            begin
              {$IFDEF CBUILDER}
                 AddParam([pfAddress],Name,TypeName);
              {$ELSE}
                 AddParam([],Name,TypeName);
              {$ENDIF}
            end;

end.
