{Editor of TCompiler component}
unit Comped;
{ Compiler editor }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, StdCtrls, ExtCtrls, RXSplit, Menus,
  RulesLst,CtTable,MakeCT,LexInfLs, SpeedBar,Compiler,LexEd,DsgnIntf,{DsgnWnds,}
  ErrEdF,TypInfo,{LibIntf,}Buttons, Placemnt, RxConst, CompTool;


const NoName='<No name>';
type
  TCompEdForm = class(TForm)
    ResultGrid: TStringGrid;
    RxSplitter1: TRxSplitter;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    RulesGrid: TStringGrid;
    N7: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    SpeedBar1: TSpeedBar;
    SpeedItem1: TSpeedItem;
    SpeedItem2: TSpeedItem;
    SpeedItem3: TSpeedItem;
    SpeedItem4: TSpeedItem;
    SpeedItem5: TSpeedItem;
    SpeedItem6: TSpeedItem;
    SpeedItem7: TSpeedItem;
    N10: TMenuItem;
    SpeedItem8: TSpeedItem;
    SpeedItem9: TSpeedItem;
    N11: TMenuItem;
    N12: TMenuItem;
    DoCompose: TMenuItem;
    N4: TMenuItem;
    N13: TMenuItem;
    N14: TMenuItem;
    SaveDialog2: TSaveDialog;
    OpenDialog2: TOpenDialog;
    procedure N2Click(Sender: TObject);
    procedure N5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure N6Click(Sender: TObject);
    procedure RulesGridRowMoved(Sender: TObject; FromIndex,
      ToIndex: Longint);
    procedure N8Click(Sender: TObject);
    procedure N9Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure N10Click(Sender: TObject);
    procedure N11Click(Sender: TObject);
    procedure ResultGridClick(Sender: TObject);
    procedure DoComposeClick(Sender: TObject);
    procedure N4Click(Sender: TObject);
    procedure N13Click(Sender: TObject);
    procedure RulesGridDblClick(Sender: TObject);
  private
    { Private declarations }
    fComp:TCompiler;
    fErrEd:TErrEdForm;
    fDesigner:TFormDesigner;
    procedure wrFileName(const s:STring);
    function rdFileName:string;
    procedure RenumberGrid;
    procedure Modif;
    procedure wrDesigner(d:TFormDesigner);
  public
    { Public declarations }
    constructor Create(o:TComponent;COmp:TCompiler);
    property FileName:string read rdFileName write wrFileName;
    procedure OnErrorAssign(Sender:TObject;No:word);
    procedure ShowRule(No:word);
    procedure RefreshResult;
    procedure RefreshContents;
    property Designer:TFormDesigner read fDesigner write wrDesigner;
    property Compiler:TCompiler read fComp write fComp;
    function MethodName:string;
  end;
type TCompilerEditor=class(TComponentEditor)
        procedure Edit;override;
     end;
var
  CompEdForm: TCompEdForm;

  {Edit Shows editor form in modal mode. In run-time you should }
  {set d=nil }
procedure EditCompiler(c:TCompiler;d:TFormDesigner);
implementation
const sSender:string='Sender';
      sCompiler:string='TCompiler';
      sB:string='b';
      sBush:string='TBush';
procedure EditCompiler;
          Var f:TCompEdForm;
          begin
            f:=TCompEdForm.Create(Application,c);
            f.Designer:=d;
            f.ShowModal;
            f.Free;
          end;
{$R *.DFM}
function FindEditor(Comp: TCompiler): TCompEdForm;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to Screen.FormCount - 1 do begin
    if Screen.Forms[I] is TCompEdForm then begin
      if TCompEdForm(Screen.Forms[I]).Compiler = Comp then
      begin
        Result := TCompEdForm(Screen.Forms[I]);
        Break;
      end;
    end;
  end;
end;

procedure ShowCompDesigner(Designer: TDesigner; Comp: TCompiler);
var
  CompEd: TCompEdForm;
begin
  if Comp = nil then Exit;
  CompEd := FindEditor(Comp);
  if CompEd <> nil then 
  begin
    CompEd.Show;
    if CompEd.WindowState = wsMinimized then CompEd.WindowState := wsNormal;
  end
  else 
  begin
    CompEd := TCompEdForm.Create(Application,Comp);
    try
      CompEd.Designer := TFormDesigner(Designer);
      CompEd.Show;
    except
      CompEd.Free;
      raise;
    end;
  end;
end;

procedure TCompilerEditor.Edit;
          begin
            ShowCompDesigner(Designer,Component as TCompiler);
            Designer.Modified;
          end;
procedure TCompEdForm.ShowRule;
          begin
            RulesGrid.Row:=No-1;
            RulesGrid.TopRow:=No-1;
          end;
procedure   TCompEdForm.wrDesigner;
            begin
              fDesigner:=d;
              RefreshContents;
            end;
procedure   TCompEdForm.Modif;
            begin
              if Designer<>Nil then Designer.Modified;
            end;
procedure   TCompEdForm.RefreshResult;
            Var c,r:Integer;
            begin
              if not fComp.Table.isEmpty then
              begin
                ResultGrid.RowCOunt:=fComp.Table.RowCount+1;
                ResultGrid.ColCount:=fComp.Table.ColCount+1;
                for r:=0 to fComp.Table.RowCount-1 do
                  for c:=0 to fComp.Table.ColCount-1 do
                    ResultGrid.Cells[c+1,r+1]:=IntToSTr(fComp.Table.Items[r,c]);
                for r:=0 to fComp.Table.RowCount-1 do
                begin
                  ResultGrid.Cells[0,r+1]:=fComp.Table.NonTerms.Lexems[r].AsSTring;
                end;
                for r:=0 to fComp.Table.ColCount-1 do
                begin
                  ResultGrid.Cells[r+1,0]:=fComp.Table.Terms.Lexems[r].AsSTring;
                end;
              end
              else
              begin
                ResultGrid.RowCOunt:=2;
                ResultGrid.ColCount:=2;
                for r:=0 to 1 do
                  for c:=0 to 1 do
                    ResultGrid.Cells[c,r]:='Empty'
              end;
            end;
procedure   TCompEdForm.RefreshContents;
            Var i:Integer;
                OnComp:TRuleEvent;
            begin
              RulesGrid.RowCount:=fComp.Rules.Count;
              for i:=0 to fCOmp.Rules.COunt-1 do
              begin
                RulesGrid.Cells[1,i]:=fComp.Rules.Rules[i].AsString;
                if Designer<>nil then
                begin
                  OnCOmp:=fComp.OnCompile[i+1];
                  RulesGrid.Cells[2,i]:=
                    Designer.GetMethodName(TMethod(OnComp));
                end;
              end;
              RenumberGrid;
              RefreshResult;
              fErrEd.Free;
              fErrEd:=TErrEdForm.Create(Self,fComp.Errors);
              fErrEd.OnAssign:=OnErrorAssign;
              fErrEd.Caption:=fComp.Name+'.Errors';
            end;
constructor TCompEdForm.Create;
            Var i:Integer;
            begin
              Inherited Create(o);
              fComp:=Comp;
              Caption:=Comp.Name;
              RulesGrid.RowCount:=Comp.Rules.Count;
              for i:=0 to COmp.Rules.COunt-1 do
                RulesGrid.Cells[1,i]:=Comp.Rules.Rules[i].AsString;
{              RenumberGrid;
              RefreshResult;}
              fErrEd:=TErrEdForm.Create(Self,fComp.Errors);
              fErrEd.OnAssign:=OnErrorAssign;
              fErrEd.Caption:=Comp.Name+'.Errors';
              RefreshContents;
            end;
procedure TCompEdForm.OnErrorAssign;
          Var Val,rw,cl:Integer;
          begin
            with ResultGrid do
            begin
              for cl:=Selection.Left to Selection.Right do
                for rw:=Selection.Top to Selection.Bottom do
                begin
                  try
                    Val:=StrToInt(Cells[cl,Rw]);
                    if Val<=0 then
                    begin
                      Cells[cl,Rw]:=IntToSTr(-No);
                      fComp.Table.Items[rw-1,cl-1]:=-No;
                    end;
                  finally end;
                end;
            end;
          end;
procedure TCompEdForm.wrFileName(const s:STring);
          begin
           { Caption:=s+ ' - CTGen';
            fFileName:=s;}
          end;
function TCompEdForm.rdFileName:string;
         begin
           {Result:=fFileName;}
         end;
procedure TCompEdForm.RenumberGrid;
          Var i:Integer;
              o:TRuleEvent;
          Begin
            for i:=0 to RulesGrid.RowCOunt-1 do
            begin
              RulesGrid.Cells[0,i]:=IntToSTr(i+1);
              o:=fComp.OnCompile[i+1];
              if Designer=nil then
              begin
                if Assigned(o) then
                begin
                  RulesGrid.Cells[0,i]:=RulesGrid.Cells[0,i]+'#';
                end
              end
              else
              begin
                if Designer.GetMethodName(TMethod(o))<>'' then
                  RulesGrid.Cells[0,i]:=RulesGrid.Cells[0,i]+'#';

              end;
            end;
          end;
procedure TCompEdForm.N2Click(Sender: TObject);
Var f:TextFile;
    ln:Integer;
    s:string;
begin
  if OpenDialog1.Execute then
  begin
    RulesGrid.RowCount:=2;
    AssignFile(f,OpenDialog1.FileName);
    Reset(f);
    ln:=0;
    While Not eof(f) do
    begin
      if RulesGrid.RowCount=ln then RulesGrid.RowCount:=RulesGrid.RowCount+1;
      ReadLn(f,s);
      RulesGrid.Cells[1,ln]:=s;
      RulesGrid.Cells[0,ln]:=IntToStr(ln+1);
      inc(ln);
    end;
    CLoseFIle(f);
    FileName:=ExtractFileName(OpenDialog1.FileName);
    ReadRLFromS(fComp.Rules,RulesGrid.Cols[1],fComp.Lexems);
  end;
end;

procedure TCompEdForm.N5Click(Sender: TObject);
begin
  Modif;
  Close;
end;

procedure TCompEdForm.FormCreate(Sender: TObject);
begin
{  FileName:=NoName;
  RenumberGrid; }
end;

procedure TCompEdForm.N3Click(Sender: TObject);
begin
{  if FileName=NoName then
  begin}
    if SaveDialog1.Execute then
    begin
      RulesGrid.Cols[1].SaveToFile(SaveDialog1.FileName);
      FileName:=SaveDialog1.FileName;
    end;
 { end
  else
  begin
    RulesGrid.Cols[1].SaveToFile(FileName);
  end;}
end;

procedure TCompEdForm.N6Click(Sender: TObject);
Var LIL:TLexInfLs;
    rl:TRulesLst;
    CT:TCtTable;
    i,j:Integer;
begin
  LIL:=fComp.Lexems;
  rl:=TRulesLst.Create;
  ReadRLFromS(rl,RulesGrid.Cols[1],LIL);
  fComp.Rules:=rl;
  CT:=MakeCTable(rl);
  if DoCOmpose.Checked then
    CT.Compose(fComp.Table);
  fComp.Table.Assign(CT);
  RefreshResult;
  Ct.Free;
  rl.Free;
  Modif;
end;

procedure TCompEdForm.RulesGridRowMoved(Sender: TObject; FromIndex,
  ToIndex: Longint);
begin
  RenumberGrid;
  Modif;
end;

procedure TCompEdForm.N8Click(Sender: TObject);
begin
  RulesGrid.RowCount:=RulesGrid.RowCount+1;
  RenumberGrid;
  Modif;
end;

procedure TCompEdForm.N9Click(Sender: TObject);
Var i:Integer;
begin
  if RulesGrid.RowCOunt>1 then
  begin
    for i:=RulesGrid.Row to RulesGrid.RowCount-2 do
      RulesGrid.Cells[1,i]:=RulesGrid.Cells[1,i+1];
    RulesGrid.RowCount:=RulesGrid.RowCount-1;
    RenumberGrid;
  Modif;
 end;
end;

procedure TCompEdForm.FormDestroy(Sender: TObject);
begin
{  Modif;
  ReadRLFromS(fComp.Rules,RulesGrid.Cols[1],fComp.Lexems);
  fErrEd.Destroy;                                         }
end;

procedure TCompEdForm.N10Click(Sender: TObject);
begin
  EditLexInfos(fComp.Lexems);
  Modif;
end;

procedure TCompEdForm.N11Click(Sender: TObject);
begin
  fErrEd.Show;
  fErrEd.Left:=Screen.Width-fErrEd.Width;
end;

procedure TCompEdForm.ResultGridClick(Sender: TObject);
Var Val:Integer;
begin
  With ResultGrid do
  begin
    try
      Val:=StrToInt(Cells[col,Row]);
      if Val>0 then
        ShowRule(Val)
      else
      begin
        fErrEd.Show;
        fErrEd.ShowError(-Val);
      end;
    finally
    end;

  end;
end;

procedure TCompEdForm.DoComposeClick(Sender: TObject);
begin
  DoCompose.Checked:=not DoCompose.Checked;
end;

procedure TCompEdForm.N4Click(Sender: TObject);
Var f:TFileStream;
    r:TReader;
begin
  if OpenDialog2.Execute then
  begin
    f:=TFileSTream.Create(OpenDialog2.FileName,fmOpenRead);
    try
      r:=TReader.Create(f,2000);
      fComp.read(r);
      RefreshCOntents;
      r.Free;
      f.Free;
      Modif;
    except
     f.Free;
     raise;
    end;
  end;
end;

procedure TCompEdForm.N13Click(Sender: TObject);
Var f:TFileStream;
    w:TWRiter;
begin
  if SaveDialog2.Execute then
  begin
    f:=TFileSTream.Create(SaveDialog2.FileName,fmCreate);
    w:=TWRiter.Create(f,2000);
    fComp.write(w);
    w.Free;
    f.Free;
  end;
end;
procedure TCompEdForm.RulesGridDblClick(Sender: TObject);
Var r:integer;
    OnCOmp:TRuleEvent;
    m,method:TMethod;
    i:Integer;
    mName:string;
    aTypeData:PTypeData;
    ParamData:PParamData;
    test:array [0..100] of char;
    Adder:TParamsAdder;
begin
  if Designer=nil then exit;
  r:=RulesGrid.row+1;
  OnCOmp:=fComp.OnCompile[r];
  mName:=TFormDesigner(Designer).GetMethodName(TMethod(OnComp));
  { MessageDlg(mName,mtInformation,[mbOk],0);{}
  if mName='' then
  begin
    mName:=fComp.Name+'OnR'+IntToStr(r);
    i:=1;
    While TFormDesigner(Designer).MethodExists(mName) do
    begin
      mName:=fCOmp.Name+'OnR'+IntToStr(r)+'_'+IntToSTr(i);
      inc(i);
    end;
    aTypeData:=AllocMem(SizeOf(TTypeData)+100);
    try
      aTypeData^.MethodKind := mkProcedure;
      aTypeData^.ParamCount := 2;
      Adder:=TParamsAdder.Create(@aTypeData^.ParamList);
        Adder.AddObjectParam(sSender,sCompiler);
        Adder.AddParam([],sB,sBush);
      Adder.Free;
      Method := Designer.CreateMethod(MName,aTypeData);
      Method.Data := Designer.Form;
    finally
      FreeMem(aTypeData, SizeOf(TTypeData));
    end;
    fComp.OnCompile[r] := TRuleEvent(Method);
    RefreshContents;
    Designer.Modified;{}
    Designer.ShowMethod(mName);
  end;
  Modif;
  Designer.ShowMethod(mName);
end;
function TCompEdForm.MethodName;
         {Var aLibForm:TIForm}
         begin
           {aLibForm :=TWindowDesigner(Designer).LibForm;;
           for I := 0 to FLibForm.GetCompCount - 1 do
           begin
             if FLibForm.GetCompName(I) = Btn.Name then
             begin
               CompInfo := FLibForm.GetCompInfo(I);
               for EventNum := 0 to CompInfo.GetEventCount - 1 do
               begin
                 if CompareText(CompInfo.GetEventInfo(EventNum)^.Name, 'OnClick') = 0 then
                 begin
                   MethodName := CompInfo.GetEventValue(EventNum);
                   if MethodName = '' then
                   begin
                   end;
                 end;}

         end;
{function TSpeedbarEditor.UniqueName(Component: TComponent): string;
var
  I: Integer;
  Temp: string;
  Comp: TComponent;
  OwnerForm:TForm;
begin
  OwnerForm:=Designer.Form;
  Result := '';
  if (Component <> nil) then Temp := Component.ClassName
  else Temp := TSpeedItem.ClassName;
  if UpCase(Temp[1]) = 'T' then System.Delete(Temp, 1, 1);
  I := 1;
  repeat
    Result := Temp + IntToStr(I);
    Comp := OwnerForm.FindComponent(Result);
    Inc(I);
  until (Comp = nil) or (Comp = Component);
end;}


end.
