unit Codegen;
{ provide interface to generate VM code }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,IntStack,Code;
const StackDepth=200;
type
  {TCodeGen provide programmer interface to generate VM code }
  TCodeGen = class(TComponent)
  private
    { Private declarations }
    fCode:TCode;
  protected
    { Protected declarations}
    fSTack:TIntStack;
  public
    {Here is offset of currently generated code}
    Here:word;
    constructor Create(o:TComponent);override;
    destructor Destroy;override;
      {Compiles a character c. (Sets Code[Here] to c and increments Here)}
    procedure Compile(c:char);
      {Compiles i}
    procedure CompileInt(i:Integer);
    procedure Num(e:Extended);
    procedure Str(const s:string);
    procedure SetVar;
      {Compiles code for getting variable} 
    procedure GetVar;
    procedure Call;
    procedure Fun;
    procedure ToR;
    procedure FromR;
    procedure RGet;
    procedure cDup;
    procedure c2Dup;
    procedure Swap;
    function  Pop:Integer;
    procedure Push(a:Integer);
    procedure JMP(a:Integer);
    procedure JZ(a:Integer);
    procedure JNZ(a:Integer);
    procedure BeginCode;
    procedure EndCode;
    procedure cIf;
    procedure cElse;
    procedure cEndIf;
    procedure cFor;
    procedure cEndFor;
    procedure cWhile;
    procedure cEndWhile;
    procedure cBeginWhile;
    procedure cDrop;
  published
    { Published declarations }
    property Code:TCode read fCode write fCode;
  end;


implementation
constructor TCodeGen.Create;
            begin
              Inherited Create(o);
              fStack:=TIntStack.Create(StackDepth);
            end;
destructor TCodeGen.Destroy;
            begin
              fStack.Free;
              Inherited Destroy;
            end;
procedure TCodeGen.Compile;
            begin
              Code[Here]:=Ord(c);
              inc(Here)
            end;
procedure TCodeGen.COmpileInt;
          begin
            Code.Int[Here]:=i;
            inc(Here,SizeOf(Integer));
          end;
procedure TCodeGen.Num;
            Var p:PChar;
                i:Integer;
            begin
              Compile('#');
              p:=PChar(@e);
              for i:=0 to SizeOf(e)-1 do
              begin
                Compile(P^);
                inc(p);
              end;
            end;
procedure TCodeGen.Str;
            Var i:Integer;
            begin
              Compile('S');
              Compile(Chr(Length(S)));
              for i:=1 to Length(S) do
                Compile(S[i]);
            end;
procedure TCodeGen.SetVar;
            begin
              Compile('!');
            end;
procedure TCodeGen.GetVar;
            begin
              Compile('@');
            end;
procedure TCodeGen.Call;
            begin
              Compile('C');
            end;
procedure TCodeGen.Swap;
            begin
              fStack.Swap;
            end;
function  TCodeGen.Pop;
            begin
              Result:=fStack.Pop;
            end;
procedure TCodeGen.Push;
            begin
              fSTack.Push(a);
            end;
procedure TCodeGen.BeginCode;
            begin
              Here:=0;
            end;
procedure TCodeGen.EndCode;
            begin
              Compile(';');
            end;
procedure TCodeGen.JMP(a:Integer);
          begin
            Compile('J');
            CompileInt(a);
          end;
procedure TCodeGen.cDup;
          begin
            Compile('D');
          end;
procedure TCodeGen.JZ(a:Integer);
          begin
            Compile('Z');
            CompileInt(a);
          end;
procedure TCodeGen.JNZ(a:Integer);
          begin
            Compile('z');
            CompileInt(a);
          end;
procedure TCodeGen.ToR;
          begin
            Compile('T');
          end;
procedure TCodeGen.FromR;
          begin
            Compile('F');
          end;
procedure TCodeGen.RGet;
          begin
            Compile('R');
          end;
procedure TCodeGen.cIf;
          begin
            Push(Here+1);
            jz(0);
          end;
procedure TCodeGen.cElse;
          begin
            Push(Here+1);
            jmp(0);
            swap;
            Code.Int[Pop]:=Here;
          end;
procedure TCodeGen.cEndIf;
          begin
            Code.Int[Pop]:=Here;
          end;
procedure TCodeGen.cFor;
          begin
            Num(0);
            push(Here);
            c2Dup;
            Compile('=');
            push(Here+1);
            jnz(0);
            toR;
            toR;
          end;
procedure TCodeGen.cEndFor;
          begin
            fromR;
            fromR;
            Num(1);
            Compile('+');
            Swap;
            Jmp(Pop);
            Code.Int[Pop]:=Here;
            cDrop;
            cDrop;
          end;
procedure TCodeGen.cWhile;
          begin
            push(Here+1);
            jz(0);
          end;
procedure TCodeGen.cEndWhile;
          Var a:Integer;
          begin
            Swap;
            jmp(pop);
            code.int[pop]:=Here;
          end;
procedure TCodeGen.c2Dup;
          begin
            Compile('2');
          end;
procedure TCodeGen.cBeginWhile;
          begin
            Push(Here);
          end;
procedure TCodeGen.Fun;
          begin
            Compile('f');
          end;
procedure TCodeGen.cDrop;
          begin
            Compile('d');
          end;
end.
