unit Execed;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,Executor, SpeedBar, ExtCtrls, Grids, TabNotBk,DsgnIntf,Procedur,
  TypInfo;

type
  TExecEdForm = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    SpeedBar1: TSpeedBar;
    SpeedItem1: TSpeedItem;
    SpeedItem2: TSpeedItem;
    SpeedItem3: TSpeedItem;
    StringGrid1: TStringGrid;
    procedure StringGrid1SetEditText(Sender: TObject; ACol, ARow: Longint;
      const Value: String);
    procedure SpeedItem3Click(Sender: TObject);
    procedure SpeedItem2Click(Sender: TObject);
    procedure StringGrid1DblClick(Sender: TObject);
    procedure SpeedItem1Click(Sender: TObject);
  private
    { Private declarations }
    d:TFormDesigner;
  public
    Exec:TExecutor;
    { Public declarations }
    constructor Create(O:TComponent;Executor:TExecutor;ad:TFormDesigner);
    procedure Refresh;
  end;
type TExecEd=class(TComponentEditor)
       procedure Edit;override;
     end;
var
  ExecEdForm: TExecEdForm;

implementation
type  PParamData = ^TParamData;
  TParamData = record
    Flags: TParamFlags;
    ParamNameAndType: array[0..100] of Char;
  end;
function FindEditor(Comp: TExecutor): TExecEdForm;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to Screen.FormCount - 1 do begin
    if Screen.Forms[I] is TExecEdForm then begin
      if TExecEdForm(Screen.Forms[I]).Exec = Comp then
      begin
        Result := TExecEdFOrm(Screen.Forms[I]);
        Break;
      end;
    end;
  end;
end;
procedure ShowCompDesigner(Designer: TDesigner; Ex: TExecutor);
var
  CompEd: TExecEdForm;
begin
  if Ex = nil then Exit;
  CompEd := FindEditor(Ex);
  if CompEd <> nil then begin
    CompEd.Show;
    if CompEd.WindowState = wsMinimized then CompEd.WindowState := wsNormal;
  end
  else begin
    CompEd := TExecEdForm.Create(Application,Ex,TFormDesigner(Designer));
    try
      CompEd.Show;
    except
      CompEd.Free;
      raise;
    end;
  end;
end;

{$R *.DFM}
procedure TExecEd.Edit;
          begin
            ShowCompDesigner(Designer,Component as TExecutor);
          end;
constructor TExecEdForm.Create;
            begin
              Inherited Create(o);
              Exec:=Executor;
              d:=aD;
              Refresh;
            end;
procedure   TExecEdForm.Refresh;
            Var i:Integer;
                a:TCallEvent;
            begin
              With STringGrid1 do
              begin
                Caption:=Exec.Name;
                if Exec.Procs.Count=0 then
                  RowCount:=2
                else
                  RowCount:=Exec.Procs.Count+1;
                Cells[0,0]:='';Cells[1,0]:='';
                for i:=0 to Exec.Procs.Count-1 do
                begin
                  Cells[0,i+1]:=Exec.Procs.ProcNo[i].Name;
                  a:=Exec.Procs.ProcNo[i].OnCall;
                  Cells[1,i+1]:=d.GetMethodName(TMethod(a));
                end;
              end;
            end;
procedure TExecEdForm.StringGrid1SetEditText(Sender: TObject; ACol,
  ARow: Longint; const Value: String);
begin
  if (aCol=0) and (aRow>0) then
  begin
{    StringGrid1.Cells[arow,aCol]:=Value;}
    if Exec.Procs.Count<=(aRow-1) then
    begin
      Exec.Procs.Add(TProcedure.Create(Value));
    end
    else
    begin
      Exec.Procs.ProcNo[aRow-1].Name:=Value;
    end;
    d.Modified;
  end;
end;

procedure TExecEdForm.SpeedItem3Click(Sender: TObject);
begin
  CLose;
end;

procedure TExecEdForm.SpeedItem2Click(Sender: TObject);
Var i:Integer;
begin
  WIth STringGrid1 Do
  begin
    if (Row<=Exec.Procs.COunt) and (Row>0) then
    begin
      Exec.Procs.Delete(Row-1);
      for i:=Row to RowCOunt-2 do
      begin
        Cells[0,i]:=Cells[0,i+1];
        Cells[1,i]:=Cells[1,i+1];
      end;
      RowCOunt:=RowCOunt-1;
      d.Modified;
    end;
  end;
end;
procedure FillParam(P:pchar;A:array of string);
          Var i:Integer;
              c:Integer;
              par:TParamFlags;
              fl:Boolean;
          begin
            c:=0;
            par:=[];
            fl:=False;
            for i:=Low(a) to High(a) do
            begin
              Move(a[i],p[c],length(a[i])+1);
              c:=c+Length(a[i])+1;
              Move(par,p[c],SizeOf(TParamFlags));
              if fl then
              begin
                Move(par,p[c],SizeOf(TParamFlags));
                c:=c+SizeOf(TParamFlags);
              end;
              fl:=not fl;
            end;
          end;

procedure TExecEdForm.StringGrid1DblClick(Sender: TObject);
Var pNo,i:Integer;
    OnProc:TCallEvent;
    Method:TMethod;
    mName:STring;
    aTypeData:PTypeData;
    ParamData:PParamData;
begin
  pNo:=StringGrid1.row-1;
  i:=1;
  if (pNo<0) or (pNo>=Exec.Procs.Count) then
  begin
    Exit;
  end;
  OnProc:=Exec.Procs.ProcNo[pNo].OnCall;
  mName:=D.GetMethodName(TMethod(OnProc));
  if mName='' then
  begin
    mName:=Exec.Name+'OnCall'+IntToStr(pNo);
    While D.MethodExists(mName) do
    begin
      mName:=Exec.Name+'OnCall'+IntToStr(pNo)+'_'+IntToSTr(i);
      inc(i);
    end;
    aTypeData:=AllocMem(SizeOf(TTypeData)+100);
    try
      aTypeData^.MethodKind := mkProcedure;
      aTypeData^.ParamCount := 1;
      ParamData := PParamData(@aTypeData^.ParamList);
      with ParamData^ do begin
        Flags := [];
        FillParam(ParamNameAndType,['MustReturn','Boolean']);
      end;
      Method := D.CreateMethod(MName,aTypeData);
      Method.Data := D.Form;
    finally
      FreeMem(aTypeData, SizeOf(TTypeData));
    end;
    Exec.Procs.ProcNo[pNo].OnCall:= TCallEvent(Method);

    StringGrid1.Cells[1,pNo+1]:=mName;
  end;
  D.Modified;{}
  D.ShowMethod(mName);
end;

procedure TExecEdForm.SpeedItem1Click(Sender: TObject);
begin
  With StringGrid1 do
  begin
    RowCount:=RowCount+1;
    Exec.Procs.Add(TProcedure.Create(''));
  end;
end;

end.
