unit Demof;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Compiler, StdCtrls, Buttons, ExtCtrls, Code, Codegen,
  PrseTree,DumpF,Executor, Iexecut,Values,StackF,InputF;

type
  TForm1 = class(TForm)
    Compiler1: TCompiler;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Memo1: TMemo;
    Label1: TLabel;
    CodeGen1: TCodeGen;
    Code1: TCode;
    Button1: TButton;
    Executor1: TExecutor;
    BitBtn3: TBitBtn;
    Button2: TButton;
    Button3: TButton;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    procedure Compiler1Error(Sender: TObject; LineNo, TokenNo,
      ErrorType: Integer; const Token, Msg: String);
    procedure BitBtn2Click(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure Compiler1OnR1(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR7(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR41(Sender: TCompiler; Bush: TBush);
    procedure Button1Click(Sender: TObject);
    procedure Compiler1OnR57(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR51(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR52(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR53(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR56(Sender: TCompiler; Bush: TBush);
    procedure Executor1OnCall0_2(MustReturn: Boolean);
    procedure BitBtn3Click(Sender: TObject);
    procedure Executor1BadProc(const Name: String);
    procedure Compiler1OnR40(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR8(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR9(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR10(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR43(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR33(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR35(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR36(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR39(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR12(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR13(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR15(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR16(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR17(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR18(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR19(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR20(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR26(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR28(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR29(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR30(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR24(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR45(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR47(Sender: TCompiler; Bush: TBush);
    procedure Compiler1OnR58(Sender: TCompiler; Bush: TBush);
    procedure Executor1OnCall1(MustReturn: Boolean);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Executor1OnCall2(MustReturn: Boolean);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure Executor1OnCall3(MustReturn: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Compiler1Error(Sender: TObject; LineNo, TokenNo,
  ErrorType: Integer; const Token, Msg: String);
begin
  MessageDlg(' '+IntToSTr(LineNo)+'   '+IntToSTr(TokenNo+1)+
  ' : '+Token+' : '+Msg,mtError,[mbOk],0)
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  With COmpiler1 do
  begin
    BeginCompile;
    AcceptSTrings(1,Memo1.Lines);
    EndCOmpile;
    if WasErrors then
      Label1.Caption:=''
    else
      Label1.Caption:=' ';
  end;
end;

procedure TForm1.Memo1Change(Sender: TObject);
begin
  Label1.Caption:=' ';
end;

procedure TForm1.Compiler1OnR1(Sender: TCompiler; Bush: TBush);
begin
  CodeGen1.BeginCode;
  Compiler1.CompileBush(bush);
  CodeGen1.EndCOde;
end;

procedure TForm1.Compiler1OnR7(Sender: TCompiler; Bush: TBush);
begin
  with CodeGen1 do
  begin
    Compiler1.COmpileNode(Bush[2]);
    Str(NodeToStr(Bush[0]));
    SetVar;
  end;
end;

procedure TForm1.Compiler1OnR41(Sender: TCompiler; Bush: TBush);
begin
  with CodeGen1 do
  begin
    Str(NodeToStr(Bush[0]));
    GetVar;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ShowDump(Code1);
end;

procedure TForm1.Compiler1OnR57(Sender: TCompiler; Bush: TBush);
Var s:string;
begin
  s:=NodeToStr(bush[0]);
  CodeGen1.Str(Copy(s,2,length(s)-2));
end;

procedure TForm1.Compiler1OnR51(Sender: TCompiler; Bush: TBush);
begin
  Compiler1.CompileNode(Bush[1]);
  with CodeGen1 do
  begin
    Str(NodeToStr(Bush[0]));
    Call;
  end;
end;

procedure TForm1.Compiler1OnR52(Sender: TCompiler; Bush: TBush);
begin
  CodeGen1.Num(0);
end;

procedure TForm1.Compiler1OnR53(Sender: TCompiler; Bush: TBush);
Var i:Integer;
begin
  CodeGen1.Push(1);
  Compiler1.CompileNode(bush[1]);
  i:=CodeGen1.Pop;
  COdegen1.Num(i);
end;

procedure TForm1.Compiler1OnR56(Sender: TCompiler; Bush: TBush);
begin
  CodeGen1.Push(CodeGen1.Pop+1);
  Compiler1.CompileNode(Bush[1]);
end;

procedure TForm1.Executor1OnCall0_2(MustReturn: Boolean);
Var s:STring;
    I:Integer;
begin
  s:='';
  With Executor1 do
  begin
    for i:=0 to ParamCOunt-1 do
    begin
      s:=s+Params[i].AsString;
    end;
    FreeFrame;
    if MustReturn then
      DSTack.Push(TNumValue.Create(-1));
  end;
  Application.ProcessMessages;
  MessageDlg(S,mtInformation,[mbOk],0);
  Application.ProcessMessages;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  Executor1.Execute;
end;

procedure TForm1.Executor1BadProc(const Name: String);
begin
  MessageDLg(Name +' -   ',mtError,[mbOk],0)
end;

procedure TForm1.Compiler1OnR40(Sender: TCompiler; Bush: TBush);
Var e:Extended;
    c:Integer;
begin
  With Codegen1 do
  begin
    Val(NodeToStr(Bush[0]),e,c);
    Num(e);
  end;
end;

procedure TForm1.Compiler1OnR8(Sender: TCompiler; Bush: TBush);
begin
  COmpiler1.CompileNode(Bush[1]);
  CodeGen1.cIf;
  Compiler1.CompileNode(Bush[3]);
  Compiler1.CompileNode(Bush[4]);
end;

procedure TForm1.Compiler1OnR9(Sender: TCompiler; Bush: TBush);
begin
  Codegen1.cEndIf;
end;

procedure TForm1.Compiler1OnR10(Sender: TCompiler; Bush: TBush);
begin
  CodeGen1.cElse;
  Compiler1.CompileNode(Bush[1]);
  CodeGen1.cEndIf;
end;

procedure TForm1.Compiler1OnR43(Sender: TCompiler; Bush: TBush);
begin
  Compiler1.CompileNode(bush[1]);
  CodeGen1.Compile('~');
end;

procedure TForm1.Compiler1OnR33(Sender: TCompiler; Bush: TBush);
begin
  COmpiler1.CompileNode(Bush[1]);
  COmpiler1.CompileNode(Bush[0]);
end;

procedure TForm1.Compiler1OnR35(Sender: TCompiler; Bush: TBush);
begin
  Codegen1.COmpile('*');
end;

procedure TForm1.Compiler1OnR36(Sender: TCompiler; Bush: TBush);
begin
  CodeGen1.COmpile('/');
end;

procedure TForm1.Compiler1OnR39(Sender: TCompiler; Bush: TBush);
begin
  Codegen1.Compile('&');
end;

procedure TForm1.Compiler1OnR12(Sender: TCompiler; Bush: TBush);
begin
  Compiler1.COmpileNode(Bush[1]);
  Compiler1.COmpileNode(Bush[0]);
end;

procedure TForm1.Compiler1OnR13(Sender: TCompiler; Bush: TBush);
begin
    Compiler1.COmpileNode(Bush[2]);
    Compiler1.COmpileNode(Bush[1]);
    CodeGen1.Compile('~');
end;

procedure TForm1.Compiler1OnR15(Sender: TCompiler; Bush: TBush);
begin
  Codegen1.Compile('=');
end;

procedure TForm1.Compiler1OnR16(Sender: TCompiler; Bush: TBush);
begin
  COdeGen1.Compile('N');
end;

procedure TForm1.Compiler1OnR17(Sender: TCompiler; Bush: TBush);
begin
    COdeGen1.Compile('<');
end;

procedure TForm1.Compiler1OnR18(Sender: TCompiler; Bush: TBush);
begin
    COdeGen1.Compile('>');
end;

procedure TForm1.Compiler1OnR19(Sender: TCompiler; Bush: TBush);
begin
    COdeGen1.Compile('L');
end;

procedure TForm1.Compiler1OnR20(Sender: TCompiler; Bush: TBush);
begin
  COdeGen1.Compile('G');
end;

procedure TForm1.Compiler1OnR26(Sender: TCompiler; Bush: TBush);
begin
  Compiler1.COmpileNode(Bush[1]);
  Compiler1.COmpileNode(Bush[0]);
end;

procedure TForm1.Compiler1OnR28(Sender: TCompiler; Bush: TBush);
begin
  CodeGen1.COmpile('+');
end;

procedure TForm1.Compiler1OnR29(Sender: TCompiler; Bush: TBush);
begin
  CodeGen1.Compile('-');
end;

procedure TForm1.Compiler1OnR30(Sender: TCompiler; Bush: TBush);
begin
  CodeGen1.Compile('|');
end;

procedure TForm1.Compiler1OnR24(Sender: TCompiler; Bush: TBush);
begin
  Compiler1.CompileNode(Bush[1]);
  CodeGen1.COmpile('I');
end;

procedure TForm1.Compiler1OnR45(Sender: TCompiler; Bush: TBush);
begin
  CodeGen1.cBeginWhile;
  Compiler1.CompileNode(Bush[1]);
  CodeGen1.cWhile;
  Compiler1.CompileNode(Bush[3]);
  CodeGen1.cEndWhile;
end;

procedure TForm1.Compiler1OnR47(Sender: TCompiler; Bush: TBush);
begin
  Compiler1.CompileNode(Bush[1]);
  CodeGen1.cFor;
  Compiler1.CompileNode(Bush[3]);
  CodeGen1.cEndFor;
end;

procedure TForm1.Compiler1OnR58(Sender: TCompiler; Bush: TBush);
begin
  Compiler1.CompileNode(Bush[1]);
  with CodeGen1 do
  begin
    Str(NodeToStr(Bush[0]));
    Fun;
  end;
end;

procedure TForm1.Executor1OnCall1(MustReturn: Boolean);
begin
  if MustReturn then
  begin
    Executor1.DStack.Push(Executor1.RSTack.Value[1].CreateEQu);
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  With Executor1 do
  begin
    if Stop Then
    begin
      BeginExec;
      StackForm.STack:=Executor1.DSTack;
    end;
    Step;
    if Stop Then EndExec;
  end;
  StackForm.Refresh;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  StackForm.Show;
end;

procedure TForm1.Executor1OnCall2(MustReturn: Boolean);
begin
  Input(executor1,mustReturn);
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
  begin
    Memo1.Lines.SaveToFile(SaveDialog1.FileName);
  end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    Memo1.Lines.LoadFromFile(OpenDialog1.FileName);
  end;

end;

procedure TForm1.Executor1OnCall3(MustReturn: Boolean);
Var V:TValue;
    l,h:Extended;
begin
  if MustReturn then
  begin
    With Executor1 do
    begin
      V:=TNumValue.Create(0);
      case ParamCount of
        0:v.AsFloat:=Random;
        1:begin
          v.AsFloat:=Random(Round(Params[0].AsFloat));
        end;
        2:begin
          l:=Params[0].AsFloat;
          h:=Params[1].AsFloat;
          v.AsFloat:=l+Random(Round(h-l));
        end;
      end;
      executor1.FreeFrame;
      Executor1.DSTack.Push(v);
    end;
  end
  else
    executor1.FreeFrame;
end;

end.
