;RING0.ASM
;
;Copyright (C) 1997 Prasad Dabak and Sandeep Phadke and Milind Borate
;
;Assembler module containing the function to be executed through callgate

.386
.model small

.code

public _func

_func proc
;Setup standard stack frame 
        push ebp
        mov ebp, esp

;Issues a beep to show that you can do direct port I/O
;Not a good piece of 32-bit code, but still proves the fact

        pushad
        mov ax, 1000 
        mov bx, 200
        mov cx, ax
        mov al, 0b6h
        out 43h, al
        mov dx, 0012h
        mov ax, 34dch
        div cx
        out 42h, al
        mov al, ah
        out 42h, al
        in al, 61h
        mov ah, al
        or al, 03h
        out 61h, al
        l1:
                mov ecx, 4680
        l2:
                loop l2
                dec bx
                jnz l1
        mov al, ah
        out 61h, al
        popad

;Save away the registers which we modify
        push esi
        push ebx

;Get the contents of CR0, CR2, CR3 registers. Check if PDWORDS for holding
;CR0, CR2, CR3 are not NULL
;More strict checking needs to be added over here such as is pointer 
;writable etc, since if junk pointers are passed to this function,
;your NT machine can crash

;Get the first paramter from EBP+0Ch, since this function is called via
;a far call.
        mov esi, [ebp+0Ch]
        test esi, esi
        jz next
        mov ebx, cr0
        mov [esi], ebx

next:
        mov esi, [ebp+10h]
        test esi, esi
        jz next1
        mov ebx, cr2
        mov [esi], ebx

next1:
        mov esi, [ebp+14h]
        test esi, esi
        jz next2
        mov ebx, cr3
        mov [esi], ebx

next2:
;Restore the registers 
        pop esi
        pop ebx

        pop ebp

;Make a far return. Also follow the _stdcall calling convention.
        retf 0Ch
_func endp

END

