/*
CGATEAPP.C

Copyright (C) 1997 Prasad Dabak and Sandeep Phadke and Milind Borate

Sample application which uses CALLGATE.DLL API for creating callgates
*/

#include <windows.h>
#include <stdio.h>
#include "gate.h"

/* Declare the function present in RING0.ASM */
void func(int *cr0, int *cr2, int *cr3);

main()
{
	WORD CallGateSelector;
	int rc;
	short farcall[3];
	int mcr0, mcr2, mcr3;

	/* Create a callgate for function 'func' which takes '3' parameters 
	and get the callgate selector value in 'CallGateSelector'*/
	rc=CreateCallGate(func, 3, &CallGateSelector);

	/* Check if callgate creation succeeds */
	if (rc==SUCCESS) {
		printf("Selector allocated = %x\n", CallGateSelector);

		/*Prepare for making the far call. Forget about the offset 
		portion of far call, so no need to think about first two
		elements of farcall array */
		farcall[2]=CallGateSelector;
        _asm {
				/*Push the parameters required*/

                lea esi, mcr3
                push esi
                lea esi, mcr2
                push esi
                lea esi, mcr0
                push esi

				/*Make a far call*/
                call fword ptr [farcall]
        }

		/* Print the contents of control registers */
        printf("cr0=%x, cr2=%x, cr3=%x\n", mcr0, mcr2, mcr3);

		/* Release the callgate created using CreateCallGate*/
		rc=FreeCallGate(CallGateSelector);
		if (rc!=SUCCESS) {
			printf("FreeCallGate failed, CallGateSelector=%x, rc=%x\n",
						CallGateSelector, rc);
		}

	} else {
		printf("CreateCallGate failed, rc=%x\n", rc);
	}
	return 0;
}
