VERSION 5.00
Begin VB.Form Form1 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Rotate Bits"
   ClientHeight    =   1575
   ClientLeft      =   2775
   ClientTop       =   2145
   ClientWidth     =   6615
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   1575
   ScaleWidth      =   6615
   Begin VB.CommandButton cmdRight 
      Caption         =   "&>>"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   3360
      TabIndex        =   2
      Top             =   960
      Width           =   495
   End
   Begin VB.CommandButton cmdLeft 
      Caption         =   "&<<"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2760
      TabIndex        =   1
      Top             =   960
      Width           =   495
   End
   Begin VB.Label Label1 
      Caption         =   "Tip: Click bits to toggle. Click << and >> to rotate."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   4200
      TabIndex        =   3
      Top             =   960
      Width           =   2295
   End
   Begin VB.Image imgBits 
      Height          =   495
      Index           =   31
      Left            =   120
      Top             =   480
      Width           =   495
   End
   Begin VB.Label lblValue 
      Caption         =   "Value:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3975
   End
   Begin VB.Image imgStates 
      Height          =   225
      Index           =   1
      Left            =   4560
      Picture         =   "Rotate.frx":0000
      Top             =   120
      Visible         =   0   'False
      Width           =   180
   End
   Begin VB.Image imgStates 
      Height          =   225
      Index           =   0
      Left            =   4320
      Picture         =   "Rotate.frx":00FA
      Top             =   120
      Visible         =   0   'False
      Width           =   180
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Call Absolute, Version 1.01
'Copyright (c) 1996-97 SoftCircuits Programming
'Redistributed by Permission.
'
'SoftCircuits Programming
'http://www.softcircuits.com
'P.O. Box 16262
'Irvine, CA 92623
'
'CALLABS.DLL was designed to assist in duplicating the
'functionality of the Call Absolute statment in earlier DOS
'versions of Microsoft BASIC. It allows you to call any memory
'address under Win32.
'
'To use this technique, allocate memory that has execute
'access. Many variables allocated in VB can be executed.
'Memory allocated with GlobalAlloc can also be executed.
'Next, write the machine code bytes to that memory. This step
'requires knowledge of Intel 32-bit processor instructions.
'The last instruction should be RET (&HC3) which causes the
'processor to return to the code that called the memory.
'
'There are two advantages to this technique. One, you can
'write small custom assembly language routines without an
'assembler, and two, you can modify the code at run-time to
'create special purpose routines based on run-time conditions.
'
'Much of this technique requires only Visual Basic. However,
'Visual Basic provides no direct means to call the memory.
'This DLL provides this link. Use CallAbsolute to call a
'memory location that contains instructions. Use
'CallAbsoluteRegs to do the same thing except this version
'lets you use the CALLREGS UDT to set register values before
'the memory is called, and to return register values after the
'memory is called. The VarPtr function offers support if you
'need to obtain an address of a variable. Note that Visual
'Basic passes a copy of some variable types when calling a DLL
'function. For example, this is the case with strings and UDTs
'that contain strings. In these instances, VarPtr returns the
'address of the copy which would not normally be of any value.
'
'If you run into problems using this technique on some
'platforms, you might instead try calling GlobalAlloc() to
'allocate the memory block that you execute. If you plan to
'implement this technique in a commercial application, you
'should also consider some other issues that may make your
'program more reliable. The Microsoft Knowledge Base article
'Q127904 addresses these issues. Basically, the article
'recommends you call VirtualProtect() before and after you
'modify the block of memory to change the memory's protection
'level. The article also recommends you call
'FlushInstructionCache() under NT to prevent high-performance
'processors from executing cached instructions instead of
'the instructions you just modiified.
Option Explicit

Private Type CALLREGS
    EAX As Long
    EBX As Long
    ECX As Long
    EDX As Long
    ESI As Long
    EDI As Long
    Flags As Long
End Type

'CALLREGS Flags bit values
Private Const FLAGS_CARRY = &H1
Private Const FLAGS_PARITY = &H4
Private Const FLAGS_AUX = &H10
Private Const FLAGS_ZERO = &H40
Private Const FLAGS_SIGN = &H80

Private Declare Function CallAbsolute Lib "CALLABS.DLL" (Mem As Any) As Long
Private Declare Function CallAbsoluteRegs Lib "CALLABS.DLL" (Mem As Any, Regs As CALLREGS) As Long
Private Declare Function VarPtr Lib "CALLABS.DLL" (Mem As Any) As Long

Private m_Value As Long

Private RotLeftCode(0 To 3) As Byte
Private RotRightCode(0 To 3) As Byte

Private Sub Form_Load()
    Dim i As Integer
    imgBits(31) = imgStates(0)
    For i = 30 To 0 Step -1
        Load imgBits(i)
        imgBits(i) = imgBits(31)
        imgBits(i).Left = imgBits(i + 1).Left + imgBits(31).Width + 20
        imgBits(i).Top = imgBits(31).Top
        imgBits(i).Visible = True
    Next i
    'Create machine instructions for rotating left
    RotLeftCode(1) = &HD3  'Rol eax,cl
    RotLeftCode(2) = &HC0
    RotLeftCode(3) = &HC3  'Ret
    'Create machine instructions for rotating right
    RotRightCode(1) = &HD3  'Ror eax,cl
    RotRightCode(2) = &HC8
    RotRightCode(3) = &HC3  'Ret
    'Show initial value
    Call ShowValue
End Sub

Private Sub cmdLeft_Click()
    m_Value = RotateLeft(m_Value, 1)
    Call ShowValue
End Sub

Private Sub cmdRight_Click()
    m_Value = RotateRight(m_Value, 1)
    Call ShowValue
End Sub

Private Sub imgBits_MouseDown(index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim Mask As Long
    If Button = 1 Then
        Mask = GetBitValue(index)
        'Toggle selected bit
        m_Value = m_Value Xor Mask
        Call ShowValue
    End If
End Sub

Private Function RotateLeft(Value As Long, Bits As Integer)
    Dim Regs As CALLREGS
    Regs.EAX = Value
    Regs.ECX = Bits
    RotateLeft = CallAbsoluteRegs(RotLeftCode(1), Regs)
End Function

Private Function RotateRight(Value As Long, Bits As Integer)
    Dim Regs As CALLREGS
    Regs.EAX = Value
    Regs.ECX = Bits
    RotateRight = CallAbsoluteRegs(RotRightCode(1), Regs)
End Function

Private Sub ShowValue()
    Dim i As Integer
    For i = 0 To 31
        If m_Value And GetBitValue(i) Then
            imgBits(i) = imgStates(1)
        Else
            imgBits(i) = imgStates(0)
        End If
    Next i
    lblValue = "Value: &&H" & Right$("0000000" & Hex(m_Value), 8)
End Sub

Private Function GetBitValue(nBit As Integer) As Long
    'Prevent overflow of high bit
    If nBit = 31 Then
        GetBitValue = &H80000000
    Else
        GetBitValue = (2 ^ nBit)
    End If
End Function

