{TV like Resource Copier 4 DPMI programs. (C) 1995, 96 by Slava Gostrenko.}

{$IfNDef DPMI}
! Set Target to DPMI (Protected) !
{$EndIf}

program
  TVRPCopy;

uses
  Objects;

var
  IRes, ORes : TResourceFile;
  OStream    : PBufStream;

  IName, OName: string;

begin
  WriteLn ('=== TV like Resource Copier 4 DPMI programs. (C) 1995, 96 by Slava Gostrenko ===');

  if ParamCount <> 2 then
    WriteLn ('Usage: TVRPCopy <Source File> <Destination File>')
  else begin
    IName := ParamStr (1);
    OName := ParamStr (2);

    IRes. Init (New (PBufStream, Init (IName, stOpenRead, 32768)));

    if  (IRes. Stream <> nil)
    and (IRes. Stream^.Status = STOK)
    then begin
      New (OStream, Init (OName, stOpen, 32768));

      if (OStream = nil)
      or (OStream^. Status <> STOK) then begin
        Dispose (OStream, Done);
        New (OStream, Init (OName, stCreate, 32768));
      end;

      if  (OStream <> nil)
      and (OStream^. Status = STOK) then begin
        ORes. Init (OStream);
        OStream^. Seek (ORes. BasePos);
        Dispose (IRes. SwitchTo (OStream, False));
        WriteLn ('Installing new resources to ', OName, ' - done.');
      end else
        WriteLn ('Error opening Destination File');
    end else
      WriteLn ('Error opening Source File');

    IRes. Done;
  end;
end.
