{***************************************************************************}
{                                                                           }
{  File: BPR.PAS                                                            }
{  Borland Pascal 7.XX AutoCorrector                                        }
{                                                                           }
{  Copyright (c) 1994-96                                                   }
{     Alexander Petrosyan (General idea+BP reverse engineering+programming) }
{     Slava Gostrenko (Fast subwords searching algorithm+features)          }
{     jock STH (Input line)                                                 }
{                                                                           }
{***************************************************************************}

{$IFNDEF DPMI}
  ! set Target to "Protected Mode Application"
{$ENDIF}

{$A+,B-,E-,F+,G+,I-,N-,P-,Q-,R-,S-,T+,V-,X+}

{ $DEFINE Russian   } {Remove space before $ sign to use russian language   }
{ $DEFINE AutoSave  } {Remove space before $ sign to enable AutoSave feature}
{ $DEFINE VideoSubst} {Remove space before $ sign to enable VIdeoSubst feature}

{$IFDEF AutoSave}
{$DEFINE NeedDigiParamCheck} {digital parameter processing}
{$ENDIF}

{$IFDEF VideoSubst}
{$DEFINE NeedDigiParamCheck} {digital parameter processing}
{$ENDIF}

uses
  Dos,
  Objects,

  WRDList;

const
  VersionAndCopyright = '3.8 (c) 1994-96';
  SpaceChars = [' ', #9];
  CfgFileName = 'BPR.CFG';

type
  TCh = record C: Char; H: Byte end;

  PArr = ^TArr;
  TArr = array [0..26*26] of Integer;

  PCorrectorRec = ^TCorrectorRec;
  TCorrectorRec = record
    ID: Word;
    Sub: string;
  end;

  PCorrectorList = ^TCorrectorList;
  TCorrectorList = object (TWordList)
    IDs: PArr;
    function CreateRec (const S: String): Pointer;
    procedure FreeItem (Item: Pointer); virtual;
    function Compare (Key1, Key2: Pointer): Integer; virtual;
    procedure SetLimit (ALimit: Integer); virtual;
    procedure _Insert (Item: Pointer);
    procedure _AtInsert (Index: Integer; Item: Pointer);
    procedure _AtDelete (Index: Integer);
    procedure _AtFree (Index: Integer);
  end;

var
  WordList: array [MinWordLen..MaxWordLen] of TCorrectorList;
const
  MaxLen: Byte = 0;

{  }

procedure CalcMaxLen;
var
  I: Integer;
begin
  for I := Low (WordList) to High (WordList) do
    if WordList [I].Count <> 0 then MaxLen := I;
end;

{ TCorrectorList }

function TCorrectorList.CreateRec;
var
  CR: PCorrectorRec;
begin
  GetMem (CR, SizeOf (CR^.ID)+1+Length (S));
  CR^.Sub := S;
  CR^.ID :=
    (Byte (LowCase [CR^.Sub [1]])-Byte ('a'))*26  +
     Byte (LowCase [CR^.Sub [2]])-Byte ('a');
  CreateRec := CR;
end;

procedure TCorrectorList.FreeItem;
begin
  with PCorrectorRec (Item)^ do
    FreeMem (PCorrectorRec (Item), SizeOf (ID)+1+Length (Sub));
end;

function TCorrectorList.Compare;
begin
  Compare := inherited Compare (
    @PCorrectorRec (Key1)^.Sub, @PCorrectorRec (Key2)^.Sub);
end;

procedure TCorrectorList.SetLimit;
var
  OldLimit: Integer;
begin
  OldLimit := Limit;

  inherited SetLimit (ALimit);

  if Limit <> OldLimit then
  begin
    if (Limit = 0) and (OldLimit <> 0) then Dispose (IDs);
    if (OldLimit = 0) and (Limit <> 0) then
    begin
      New (IDs);
      FillChar (IDs^, SizeOf (IDs^), 0);
    end;
  end;
end;

procedure TCorrectorList._Insert;
var
  I: Integer;
begin
  if Search (Item, I) then _AtFree (I);
  _AtInsert (I, Item);
end;

procedure TCorrectorList._AtFree;
var
  Item: Pointer;
begin
  Item := At (Index);
  _AtDelete (Index);
  FreeItem (Item);
end;

procedure TCorrectorList._AtInsert;
var
  I: Integer;
begin
  inherited AtInsert (Index, Item);
  for I := PCorrectorRec (Item)^.ID + 1 to High (IDs^) do
    Inc (IDs^ [I]);
end;

procedure TCorrectorList._AtDelete;
var
  I: Integer;
begin
  for I := PCorrectorRec (At (Index))^.ID + 1 to High (IDs^) do
    Dec (IDs^ [I]);
  inherited AtDelete (Index);
end;

{  }

function GetID (const S: string): Word;
begin
  GetID :=
    (Byte (LowCase [S [1]])-Byte ('a'))*26  +
     Byte (LowCase [S [2]])-Byte ('a');
end;

{  }

var
  Old16, Old65, Old66, Old68: procedure;
const
  DoUpdate: Byte = 0;
  AutoCorrect: Boolean = True;

{$IfDef AutoSave}
  AutoSave : Boolean = False;
  WeAreInEditor: Boolean = False;
  SavePeriod : Longint = 60*18;
  IdleTime : Longint = 10*18;
  LastKeyPressedAt : Longint = 0;
  LastKeyIsCompileKey : Boolean = False;

procedure DoAutoSave;

  function GetShiftState: Byte; assembler;
  var ShiftState: Byte absolute $40:$17;
  asm
          MOV   ES,Seg0040
          MOV   AL,ES:ShiftState
  end;

const kbF2 = $3C00;
      SavedAtTime: Longint = 0;
var   R: Registers;
      Ticks: Longint;
begin
  R.AH := 0;
  Intr ($1A, R);
  LongRec(Ticks).Hi := R.CX;
  LongRec(Ticks).Lo := R.DX;
  if (Ticks - LastKeyPressedAt > IdleTime) and (Ticks - SavedAtTime > SavePeriod)
  and ((GetShiftState and $F) = 0) then begin
    SavedAtTime := Ticks;
    R.AH := 5;
    R.CX := kbF2;
    Intr($16, R);
  end;
end;
{$EndIf}

procedure WriteWordList; forward;

procedure New16 (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Integer); interrupt;
const
  MaxX = 132;
var
  ScreenWidth: ^Word;
  ScreenHeight: ^Byte;
  Buf, Buf1: array [0..MaxX-1] of TCh;
  Cursor: Longint;

  procedure Clear;
  const OnOffStr: array [Boolean] of string [9] = (
{$IFDEF Russian}
    '', '몫'
{$ELSE}
    'Turn on', 'Turn off'
{$ENDIF}
  );
  var
    I: Integer;
    StateStr: string;
  begin
    StateStr := 'F1 - ' + OnOffStr [AutoCorrect] +
{$IFDEF Russian}
    ' ⮬ ४.'
{$ELSE}
    ' auto correction.'
{$ENDIF}
{$IFDEF AutoSave}
    + ' F2 - ' + OnOffStr [AutoSave] +
{$IFDEF Russian}
    ' ⮬ .'
{$ELSE}
    ' auto save.'
{$ENDIF}
{$ENDIF}
    ;

    ScreenWidth := Ptr (Seg0040, $4A);
    ScreenHeight := Ptr (Seg0040, $84);
    for I := 0 to ScreenWidth^-1 do begin
      Word (Buf  [I]) := $0720;
      if I < Length (StateStr) then
        Word (Buf1 [I]) := $0700 + Ord (StateStr [I + 1])
      else
        Word (Buf1 [I]) := $0720;
    end;
    Cursor := $06070000;
  end;

  procedure Swap;
  var
    LocalCursor: LongInt;

    procedure DoSwap (var A, B; Size: Word);
    var
      I: Word;
      M: Byte;
    begin
      for I := 0 to Size - 1 do
      begin
        M := TByteArray (A) [I];
        TByteArray (A) [I] := TByteArray (B) [I];
        TByteArray (B) [I] := M;
      end;
    end;

  begin
    asm
      mov  ah, 03
      xor  bh, bh
      int  10h
      mov  WORD PTR LocalCursor [2], cx
      mov  WORD PTR LocalCursor [0], dx
    end;
    DoSwap (Ptr (SegB800, 0)^,
            Buf , ScreenWidth^ * 2);
    DoSwap (Ptr (SegB800, ScreenWidth^ * ScreenHeight^ * 2)^,
            Buf1, ScreenWidth^ * 2);
    DoSwap (Cursor, LocalCursor, SizeOf (Cursor));
    asm
      mov  ah, 02
      xor  bh, bh
      mov  dx, WORD PTR LocalCursor [0]
      int  10h
      mov  ah, 01
      mov  cx, WORD PTR LocalCursor [2]
      int  10h
    end;
  end;

const
  kbAltBkSp = $0800;
  kbEnter = $1C0D;
  kbCtrlEnter = $1C0A;
  kbShiftIns = $0500;

  kbShiftDel = $0700;
  kbCtrlDel = $0600;
  kbBkSp = $0E08;
  kbCtrlBkSp = $0EF7;
  kbDel0 = $5300;
  kbDel1 = $53E0;
  kbSpace = $3920;
  kbCtrlT = $1414;

  kbAltIns = $A200;
  kbAltDel = $A300;

  kbCtrl2 = $0300;
  kbCtrl6 = $071E;

{$IfDef AutoSave}
  {navigation keys that sometimes do not require redraw(int65)}
  kbHome      = $4700;
  kbEnd       = $4F00;
  kbPgUp      = $4900;
  kbPgDn      = $5100;
  kbIns       = $5200;
  kbLeft      = $4B00;
  kbRight     = $4D00;
  kbUp        = $4800;
  kbDown      = $5000;
  kbCtrlLeft  = $7300;
  kbCtrlRight = $7400;

  {compile keys}
  kbF4        = $3E00;
  kbF7        = $4100;
  kbF8        = $4200;
  kbF9        = $4300;
  kbShiftF9   = $5C00;
  kbCtrlF9    = $6600;
  kbAltF9     = $7000;
{$EndIf}

  BitZ = $40;

const
  InsDel: array [1..2] of string [16] = (
{$IFDEF Russian}
    '', ''
{$ELSE}
    'Insert', 'Delete'
{$ENDIF}
  );
  DoInsDel: Integer = 0;

var
  A: TCh absolute AX;
  Flag, Flag1: Boolean;
  S: string;
  CR: PCorrectorRec;
  Index: Integer;

  Scan        : Byte;
  CC          : Char;

{$IfDef AutoSave}
  R: Registers;
{$EndIf}

begin
  if A.H = $01 then A.H := $11;
  Flag1 := A.H = $11;
  Flag := A.H in [$00, $10];
  asm
    mov  ax, &ax
    mov  bx, &bx
    mov  cx, &cx
    pushf
    call Old16
    mov  &ax, ax
    pushf
    pop  ax
    mov  Flags, ax
  end;
  if Flag1 and ((Flags and BitZ) = 0) then
  begin
    if Word (AX) = kbAltIns then DoInsDel := 1;
    if Word (AX) = kbAltDel then DoInsDel := 2;
    if DoInsDel <> 0 then
    begin
      asm
        mov  ax, 2
        int  33h
      end;
      Clear;
      Swap;
      Write (' ', InsDel [DoInsDel], ' ' +
{$IFDEF Russian}
        '᫮' +
{$ELSE}
        'word' +
{$ENDIF}
        ': '
      );
      S[0]:=#0;
      repeat
       asm
         xor     ax,ax
         int     16h

         mov     Scan,ah
         mov     CC,al
         mov     ax,0c00h
         int     21h
       end;
       case Scan of
         {Esc}        1 : S[0]:=#0;
         {Enter}     28 : if Length (S) < 2 then Scan := 0;
         {BackSpace} 14 : if S[0] > #0 then
                           begin
                             Write(#8,' ',#8);
                             Dec(S[0]);
                           end;
         {F1}       $3B : begin
                            AutoCorrect := not AutoCorrect;
                            Scan := 1; {Emulate exit on Esc}
                          end;
{$IFDEF AutoSave}
         {F2}       $3C : begin
                            AutoSave := not AutoSave;
                            Scan := 1; {Emulate exit on Esc}
                          end;
{$ENDIF}
                   else   if S[0] < #64 then
                           begin
                            if LowCase [CC] in ValidLetters
                             then
                              begin
                                S[Ord(S[0])+1]:=CC;;
                                Inc(S[0]);
                                Write(CC);
                              end
                            end
                           else Write(#7);
       end;
      until (Scan = 1) or (Scan = 28);

      Swap;
      asm
        mov  ax, 1
        int  33h
      end;

      if ValidStr (S) then
        with WordList [Length (S)] do
        begin
          CR := CreateRec (S);
          case DoInsDel of
            1:
            begin
              _Insert (CR);
              WriteWordList;
            end;
            2:
              if Search (CR, Index)
              then
              begin
                _AtFree (Index);
                WriteWordList;
              end
              else
                FreeItem (CR);
          end;
          CalcMaxLen;
        end;

      DoInsDel := 0;
      Flags := Flags or BitZ;
      Exit;
    end;
  end
{$IfDef AutoSave}
  else
    if Flag1 and WeAreInEditor and AutoSave
    and (not LastKeyIsCompileKey) then
      DoAutoSave;
{$Else}
  ;
{$EndIf}
  if Flag then begin
    case AX of
      kbAltBkSp:
        DoUpdate := 4;
      kbEnter,
      kbCtrlEnter,
      kbShiftIns,
{      kbShiftDel,}
      kbCtrlDel,
      kbBkSp,
      kbDel0,
      kbDel1,
      kbCtrlBkSp:
        DoUpdate := 3;
      kbSpace,
      kbCtrlT,
      kbCtrl2,
      kbCtrl6:
        DoUpdate := 2;
      else
        if not (A.C in [#$00..#$1F, '''', #$E0])
        then DoUpdate := 1
        else DoUpdate := 0;
    end;
{$IfDef AutoSave}
    case AX of
    kbHome,kbEnd, kbPgUp,kbPgDn,kbIns,kbLeft,kbRight,
    kbUp,kbDown,kbCtrlLeft,kbCtrlRight: ;
    else
      WeAreInEditor := False;
    end;

    case AX of
    kbF4,kbF7,kbF8,kbF9,kbShiftF9,kbCtrlF9,kbAltF9:
      LastKeyIsCompileKey := True;
    else
      LastKeyIsCompileKey := False;
    end;

    R.AH := 0;
    Intr ($1A, R);
    LongRec(LastKeyPressedAt).Hi := R.CX;
    LongRec(LastKeyPressedAt).Lo := R.DX;
{$EndIf}
  end;
end;

var
  {CursorX, }CursorY: ^Integer;
  Y: Byte;

procedure New66 (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Integer); interrupt;
begin
  { 2FBAC }
  asm
    mov  bx,&bp
    les  di,ss:[bx+6]
    mov  &es,es
    mov  &di,di
  end;
  {  }
  CursorY := Ptr (ES, DI+$12+2);
  {CursorX := Ptr (ES, DI+$90);}
end;

procedure New68 (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Integer); interrupt;
begin
  { 238E2 }
  WordRec (AX).Hi := 0;
  {  }
  Y := WordRec (AX).Lo;
end;

const
  IDWhiteSpace    = #1;
  IDCommentS      = #2;
  IDReservedWords = #3;
  IDIdentifiers   = #4;
  IDSymbols       = #5;
  IDStrings       = #6;
  IDNumbers       = #7;
  IDAssembler     = #8;

type
  TAction = (DoNothing, DoLowCase, DoUpCase, DoCapitalize, DoDictionary);

const
  Action : array [#0 .. #8] of TAction
  = (DoUpcase,     DoNothing,    DoNothing,    DoLowCase,    DoDictionary,
                   DoNothing,    DoNothing,    DoUpcase,     DoNothing);

var
  PC, PI: array [0..26*26] of Byte;
  PP: array [Byte] of Byte;
  IS: array [Byte] of Word;
  ISCnt: Integer;
  Cnt, Beg: Byte;

procedure New65 (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Integer); interrupt;
var
  L, R: Integer;
  M: set of Byte;
  S, C: PChar;

  procedure Analise;

    procedure DoCorrect (var Sub: String);
    label
      Skip;
    var
      P, I, X: Integer;
    begin
      for P := 0 to Cnt-1 do
      begin
        X := L + PP [Beg+P];
        if X+Length (Sub) <= CX then
          if X-L in M then
          begin
            if not (X-L+1 in M) then goto Skip;

            for I := 2 to Length (Sub)-1 do
              if not (X-L+I in M) or
                (LowCase [S [X+I]] <> LowCase [Sub [1+I]]) then
                goto Skip;

            Move (Sub [1], S [X], Length (Sub));
            M := M - [X-L..X-L+Length (Sub)-1];
          end;
Skip:
      end;
    end;

  var
    X: Integer;
    C: Word;
    B: Integer;
    Len: Byte;
    Index: Integer;
    ID: Word;
    First: Boolean;
  label
    Found;
  begin
    if L <= R then
    begin
      if R-L > High (Byte)-1 then L := R-(High (Byte)-1);
      M := [0..R-L];

      if L <> R then
      begin
        IS [0] := 26*26;
        ISCnt := 1;
        for X := L to R-1 do
        begin
          C := (Byte (LowCase [S [X]])-Byte ('a'))*26  +
                Byte (LowCase [S [X+1]])-Byte ('a');
          asm
            mov   ax, ds
            mov   es, ax
            mov   di, OFFSET IS
            mov   ax, C
            mov   cx, ISCnt
            cld
            repne scasw
            je    Found
          end;
          IS [ISCnt] := C;
          PI [IS [Pred (ISCnt)]] := 1;

          Inc (ISCnt);
          Continue;
Found:
          asm
            sub   di, 2*2
            mov   di, [di]
            inc   BYTE PTR PI [di]
          end;
        end;
        PI [IS [Pred (ISCnt)]] := 0;

        for B := ISCnt-3 downto 1 do Inc (PI [IS [B]], PI [IS [Succ (B)]]);

        for X := L to R-1 do
        begin
          C := (Byte (LowCase [S [X]])-Byte ('a'))*26  +
                Byte (LowCase [S [X+1]])-Byte ('a');
          PP [PI [C]+PC [C]] := X-L;
          Inc (PC [C]);
        end;

        for Len := MaxLen downto Low (WordList) do
          with WordList [Len] do
            if Count <> 0 then
              for B := 1 to ISCnt-1 do
              begin
                ID := IS [B];
                First := True;
                for Index := IDs^ [ID] to IDs^ [ID+1]-1 do
                begin
                  if First then
                  begin
                    Cnt := PC [ID];
                    Beg := PI [ID];
                    First := False;
                  end;
                  DoCorrect (PCorrectorRec (At (Index))^.Sub);
                end;
              end;

        for B := 1 to ISCnt-1 do
          PC [IS [B]] := 0;
      end;

      for X := L to R do
        if X-L in M then
          S [X] := Upcase (S [X]);
    end;
  end;

var
  X: Integer;
  SY: Integer;
  Flag: Word;

begin
  { 23569 }
  DX := 0;
  asm
    mov  bx, &bp
    mov  ax, ss:[bx-24h]
    mov  Flag, ax
  end;
  if (Flag <> 0) and (DoUpdate <> 0) and AutoCorrect then
  begin
    SY := CursorY^;
    if (((DoUpdate <= 2) and (SY = Y)) or
      ((DoUpdate = 3) and (SY-Y+1 in [0..2])) or
      ((DoUpdate = 4) and (SY-Y in [0, 1]))) and
      (CX <> 0) then
    begin

      S := Ptr (ES, SI);
      C := Ptr (SSeg, Word (Ptr (SSeg, BP-$26)^));

      X := 0;
      while X < CX do
      begin
        case Action [C [X]] of
          DoLowCase:
            S [X] := LowCase [S [X]];
          DoUpcase:
            S [X] := UpCase (S [X]);
          DoCapitalize:
            if LowCase [S [X]] in ValidLetters then begin
              L := X;
              S [X] := UpCase (S [X]);
              Inc (X);

              while (X < CX)
              and   (C [X] = C [L])
              and   (LowCase [S [X]] in ValidLetters) do begin
                S [X] := LowCase [S [X]];
                Inc (X);
              end;

              Dec (X);
            end;
          DoDictionary:
            if LowCase [S [X]] in ValidLetters then begin
              L := X;

              while (X < CX)
              and   (C [X] = C [L])
              and   (LowCase [S [X]] in ValidLetters) do
                Inc (X);

              Dec (X);
              R := X;
              Analise;
            end;
        end;

        Inc (X);
      end;
    end;
  end;
{$IfDef AutoSave}
  WeAreInEditor := True;
{$EndIf}
end;

var
  SearchPath: string;

procedure SetSearchPath;
var
  D: DirStr;
  N: NameStr;
  E: ExtStr;
begin
  FSplit (ParamStr (0), D, N, E);
  SearchPath := '.;' + GetEnv ('PATH')+';'+D;
end;

var
  WordListPath: string;

procedure ReadWordList;
var
  F: Text;
  S: string;
  I: Integer;
begin
  FileMode := 0;
  WordListPath := FSearch ('words', SearchPath);
  if WordListPath = '' then
  begin
{$IFDEF Russian}
    WriteLn (' "WORDS."  ');
{$ELSE}
    WriteLn ('File "WORDS." not found');
{$ENDIF}
    Halt (1);
  end;
  Assign (F, WordListPath);
  Reset (F);
  if IOResult <> 0 then
  begin
{$IFDEF Russian}
    WriteLn ('   "', WordListPath, '"');
{$ELSE}
    WriteLn ('Can''t read "', WordListPath, '"');
{$ENDIF}
    Halt (2);
  end;
  for I := Low (WordList) to High (WordList) do
    with WordList [I] do
    begin
      Init (0, 5);
      Duplicates := True;
    end;
  while not EOF (F) do
  begin
    ReadLn (F, S);
    if ValidStr (S) then
      with WordList [Length (S)] do
        _Insert (CreateRec (S));
  end;
  Close (F);
  CalcMaxLen;
end;

procedure WriteWordList;
var
  F: Text;

  procedure DoWrite (var CR: TCorrectorRec);
  begin
    WriteLn (F, CR.Sub);
  end;

var
  S: string;
  I: Integer;
begin
  Assign (F, WordListPath);
  ReWrite (F);
  if IOResult <> 0 then
  begin
    Assign (F, 'words');
    SetFAttr (F, Archive);
    ReWrite (F);
  end;
  if IOResult = 0
  then
  begin
    for I := High (WordList) downto Low (WordList) do
      WordList [I].ForEach (@DoWrite);
    Close (F);
  end
  else
    Write (#7);
end;

{$IFDEF VideoSubst}

{ Int 10 handler }

const
  Columns = $4A;
  LastRow = $84;
  ColPg0  = $50;
  RowPg0  = $51;

function GetCursorOfs: Word;
begin
  GetCursorOfs := Mem [Seg0040: RowPg0] * MemW [Seg0040: Columns]
                + Mem [Seg0040: ColPg0];
end;

procedure SetCursor (CursorOfs: Word);
var Col, Row: Byte;
begin
  Row := CursorOfs div MemW [Seg0040: Columns];
  Col := CursorOfs mod MemW [Seg0040: Columns];
  asm
    mov  AH, 02h
    mov  BH, 0 {= page number}
    mov  DH, Row
    mov  DL, Col

    int  10h
  end;
end;

var
  Old10: procedure;

const
  Subst3DMode: Boolean = False;
  Subst2Mode : Integer = $109;
  FirstCall10: Boolean = True;
var
  SubstFromCS: Word;

procedure New10(Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Word); interrupt;
var RestoreCursor: boolean;
begin
  RestoreCursor := False;

  if (AX = $0003) and Subst3DMode then begin
    if FirstCall10 then begin
      FirstCall10 := False;
      SubstFromCS := CS;
    end;

    if SubstFromCS = CS then begin
      RestoreCursor := True;
      asm
        call GetCursorOfs
        push ax
      end;

      if Subst2Mode >= 256 then begin
        AX := $4F02;
        BX := Subst2Mode or $8000;
      end else
        AX := Subst2Mode or $80;
    end;
  end;

  asm
    push ds
    push bp

    push flags
    push cs
    push offset @retpoint

    push word (old10 + 2)
    push word (old10)

    mov ax, &ax
    mov bx, &bx
    mov cx, &cx
    mov dx, &dx
    mov si, &si
    mov di, &di
    mov ds, &ds
    mov es, &es
    mov bp, &bp

    retf  { call :-) }
@retpoint:

    push bp
    mov  bp, sp
    mov  bp, ss: [bp + 2]

    mov &ax, ax
    mov &bx, bx
    mov &cx, cx
    mov &dx, dx
    mov &si, si
    mov &di, di
    mov &ds, ds
    mov &es, es

    pop ax
    mov &bp, ax

    pushf
    pop ax
    mov flags, ax

    pop bp
    pop ds
  end;

  if RestoreCursor then asm
    call SetCursor
  end;
end;

{ End of Int 10 handler }

{$ENDIF}

procedure UpcaseStr (var S: string);
var
  B: Byte;
begin
  for B := 1 to Length (S) do
    S [B] := Upcase (S [B]);
end;

procedure DeleteSpacesAtStart (var S: string);
begin
  while (Length (S) > 0) and (S [1] in SpaceChars) do
    Delete (S, 1, 1);
end;

function ProcessConfigItem (S: string; InCmdLine: Boolean): Boolean;
  function ProcessActionParam (S: string; const Keyword: string;
                                var Action: TAction): Boolean;
  begin
    ProcessActionParam := False;

    if Pos (Keyword, S) = 1 then begin
      Delete (S, 1, Length (Keyword));

      while Length (S) > 0 do begin
        case S [1] of
          'N': Action := DoNothing;
          'L': Action := DoLowCase;
          'U': Action := DoUpCase;
          'C': Action := DoCapitalize;
          'D': Action := DoDictionary;
          else begin
            Delete (S, 1, 1);
            Continue;
          end;
        end;

        ProcessActionParam := True;
        Break;
      end;
    end;
  end;

{$IFDEF  NeedDigiParamCheck}
var
  L     : Longint;

  function GetDigitFromParam (Param: string; var Value: Longint): Boolean;
  var J, Code: Integer;
  begin
    GetDigitFromParam := False;
    J := Length(Param);
    while (J > 0) and (not (Param[J] in ['0'..'9'])) do Dec(J);
    if J > 0 then begin
      Param[0] := Chr(J);
      J := 1;
      while (not (Param[J] in ['0'..'9'])) do Inc(J);
      Delete(Param, 1, J-1);
      Val(Param, Value, Code);
      GetDigitFromParam := Code = 0;
    end;
  end;
{$ENDIF}

begin
  ProcessConfigItem := True;

  DeleteSpacesAtStart (S);

  if (Length (S) = 0) then
    Exit;

  if S [1] in ['/', '\', '-'] then
    Delete (S, 1, 1)
  else
    if InCmdLine then begin
      ProcessConfigItem := False;
      Exit;
    end;

  UpcaseStr (S);

  if (S [1] in [';', ':']) or (Pos ('REM', S) = 1) then
    Exit;

  if ProcessActionParam (S, 'WHITESPACE',    Action [IDWhiteSpace])
  or ProcessActionParam (S, 'COMMENTS',      Action [IDCommentS])
  or ProcessActionParam (S, 'RESERVEDWORDS', Action [IDReservedWords])
  or ProcessActionParam (S, 'IDENTIFIERS',   Action [IDIdentifiers])
  or ProcessActionParam (S, 'SYMBOLS',       Action [IDSymbols])
  or ProcessActionParam (S, 'STRINGS',       Action [IDStrings])
  or ProcessActionParam (S, 'NUMBERS',       Action [IDNumbers])
  or ProcessActionParam (S, 'ASSEMBLER',     Action [IDAssembler])
  then
    Exit;

{$IFDEF AutoSave}
  if Pos ('AUTOSAVE', S) = 1 then begin
    AutoSave := True;
    if GetDigitFromParam (S, L) then
      SavePeriod := L * 18;
  end else
  if Pos ('IDLETIME', S) = 1 then begin
    if GetDigitFromParam (S, L) then
      IdleTime := L * 18;
  end else
{$ENDIF}
{$IFDEF VideoSubst}
  if Pos ('VIDEOSUBST', S) = 1 then begin
    Subst3DMode := True;
    if GetDigitFromParam (S, L) then
      Subst2Mode := L;
  end else
{$ENDIF}
    ProcessConfigItem := False;
end;

function EvalParameters: string;
var
  CfgFileLocation : string;
  F               : Text;
  S               : string;
  I               : Integer;
begin
  CfgFileLocation := FSearch (CfgFileName, SearchPath);
  if CfgFileLocation <> '' then begin
    Assign (F, CfgFileLocation);
    Reset (F);
    if IOResult <> 0 then
    begin
{$IFDEF Russian}
      WriteLn ('   "', CfgFileLocation, '"');
{$ELSE}
      WriteLn ('Can''t open "', CfgFileLocation, '"');
{$ENDIF}
      Halt (4);
    end;

    while not EOF (F) do begin
      ReadLn (F, S);
      ProcessConfigItem (S, False);
    end;
  end;

  S := '';
  for I := 1 to ParamCount do
    if not ProcessConfigItem (ParamStr (I), True) then
      S := S + ' ' + ParamStr (I);

{$IFDEF AutoSave}
  if AutoSave then begin
{$IFDEF Russian}
    WriteLn('AutoSave ਮ ', SavePeriod div 18, ' ᥪ㭤. IdleTime ', IdleTime div 18, ' ᥪ㭤.');
{$ELSE}
    WriteLn('AutoSave period is ', SavePeriod div 18, ' seconds. IdleTime is ', IdleTime div 18, ' seconds.');
{$ENDIF}
  end;
{$ENDIF}

{$IFDEF VideoSubst}
  if Subst3DMode then begin
{$IFDEF Russian}
    WriteLn('3 ० 㤥   ० ', Subst2Mode);
{$ELSE}
    WriteLn('3d videomode will be substituted to ', Subst2Mode);
{$ENDIF}
  end;
{$ENDIF}

  EvalParameters := S;
end;

procedure TypeWordCount;
var
  I: Integer;
  Total: Integer;
begin
  Total := 0;
  for I := Low (WordList) to High (WordList) do
    Inc (Total, WordList [I].Count);
  WriteLn ({$IFDEF Russian}': '{$ELSE}'Words: '{$ENDIF}, Total);
end;

var
  BP            : string;
  P             : procedure;
  AlreadyStarted: Boolean;
  I             : Integer;
  Parameters    : string;
begin
  FillChar (PC, SizeOf (PC), 0);
  WriteLn (
{$IFDEF Russian}
    'AutoCorrector   ' + VersionAndCopyright + ' ᠭ  &  ७'
{$ELSE}
    'AutoCorrector  Version ' + VersionAndCopyright + ' Alexander Petrosyan & Slava Gostrenko'
{$ENDIF}
    );
  SetSearchPath;

  BP := FSearch ('bp.xxx', SearchPath);
  if BP = '' then
  begin
{$IFDEF Russian}
    WriteLn ('   "BP.XXX".');
{$ELSE}
    WriteLn ('Can''t locate "BP.XXX".');
{$ENDIF}
    Halt (3);
  end;

  Parameters := EvalParameters;

  GetIntVec ($16, @P);
  AlreadyStarted := Ofs (P) = Ofs (New16);
  if not AlreadyStarted then
  begin
    ReadWordList;  TypeWordCount;
    GetIntVec ($16, @Old16);  SetIntVec ($16, @New16);
    GetIntVec ($65, @Old65);  SetIntVec ($65, @New65);
    GetIntVec ($66, @Old66);  SetIntVec ($66, @New66);
    GetIntVec ($68, @Old68);  SetIntVec ($68, @New68);

{$IFDEF VideoSubst}
    if Subst3DMode then begin
      asm
        call GetCursorOfs
        push ax
      end;

      if Subst2Mode >= 256 then asm
        mov AX, $4F02;
        mov BX, Subst2Mode
        or  BX, $8000
        int 10h
      end else asm
        mov AX, Subst2Mode;
        or  AX, $80
        int 10h
      end;

      asm
        call SetCursor
      end;

      GetIntVec ($10, @Old10);  SetIntVec ($10, @New10);
    end;
{$ENDIF}
  end;
  SwapVectors;
  Exec (BP, Parameters);
  SwapVectors;
  if DosError <> 0 then
{$IFDEF Russian}
    WriteLn ('   "', BP, '".  訡: ', DosError);
{$ELSE}
    WriteLn ('Can''t start "', BP, '". ErrorNo: ', DosError);
{$ENDIF}
  if not AlreadyStarted then
  begin
{$IFDEF VideoSubst}
    if Subst3DMode then begin
      SetIntVec ($10, @Old10);
      asm
        call GetCursorOfs
        push ax

        mov ax, $83
        int 10h

        call SetCursor
      end;

      if Mem [Seg0040: RowPg0] > Mem [Seg0040: LastRow] then begin
        SetCursor (Mem [Seg0040: LastRow] * MemW [Seg0040: Columns]);
        WriteLn;
      end;
    end;
{$ENDIF}

    SetIntVec ($68, @Old68);
    SetIntVec ($66, @Old66);
    SetIntVec ($65, @Old65);
    SetIntVec ($16, @Old16);
    if DosError = 0 then TypeWordCount;
    for I := Low (WordList) to High (WordList) do
      WordList [I].Done;
  end;
end.
