{ BNMMATH.PAS - BNM statistical and mathematic routines

  title    : BNMMATH
  version  : 1.0
  date     : Apr 22,1993
  author   : J R Ferguson
  language : Borland Pascal v7.0 with Objects
  target   : MS-Windows v3.1
  usage    : Unit
}

{$I BNMOPTS.INC}

UNIT BNMMath;

INTERFACE

function Binomiaal(n,k: longint; p: extended): extended;
function BinomiaalCumulatief(n,k1,k2: longint; p: extended): extended;

function HyperGeo(Npop,n,Kpop,k: longint): extended;
function HyperGeoCumulatief(Npop,n,Kpop,k1,k2: longint): extended;

function Poisson(m: extended; k: longint): extended;
function PoissonCumulatief(m: extended; k1,k2: longint): extended;

function Normaal(x,sigma,mu: extended): extended;


IMPLEMENTATION

{ --- local definitions --- }

const epsilon = 1.0E-6;

(*
function fac(i: longint): extended;
var f: extended;
begin
  f:= 1.0;
  while i>1 do begin
    f:= f*i;
    dec(i);
  end;
  fac:= f;
end;
*)

function NoverK(n,k: longint): extended;
var x: extended; i: longint;
begin
(*NOverK:= fac(n)/fac(k)/fac(n-k);*)
  if k > n-k then k:= n-k;
  if k <= 0 then NOverK:= 1.0
  else begin
    x:= 1.0;
    for i:= 0 to k-1 do
      x:= x * (n-i) / (k-i);
    NOverK:= x;
  end
end;

function power(x: extended; n: longint): extended;
{ modeled after an algoithm by Dennis E. Hamilton v1.08
  Dr Dobbs Journal of Software Tools, nr 112, FEB 1986 }
var i: longint; r: extended;
begin
  if (n=0) or (x = 1.0) then power:= 1.0
  else begin
    i:= abs(n);
    while not odd(i) do begin x:= sqr(x); i:= i shr 1 end;
    r:= x;
    while i <> 1 do begin
      repeat x:= sqr(x); i:= i shr 1; until odd(i);
      r:= r*x;
    end;
    if n < 0 then power:= 1.0/r else power:= r;
  end;
end;


{ --- global routines --- }

function Binomiaal(n,k: longint; p: extended): extended;
begin Binomiaal:= NoverK(n,k) * power(p,k) * power(1-p,n-k); end;

function BinomiaalCumulatief(n,k1,k2: longint; p: extended): extended;
var k: longint; r,s: extended; q: extended;
begin
  if k1 > k2 then BinomiaalCumulatief:= 0.0
  else begin
    if p = 1.0 then q:= 0.0 else q:= p/(1-p);
    k:= k1; r:= Binomiaal(n,k,p); s:= r;
    while (k < k2) and (r > epsilon) do begin  {<=== PM niet altijd convergent !}
      r:= (n-k)/(k+1) * q * r;
      s:= s + r;
      inc(k);
    end;
    BinomiaalCumulatief:= s;
  end;
end;

function HyperGeo(Npop,n,Kpop,k: longint): extended;
begin HyperGeo:= NoverK(Kpop,k) * NoverK(Npop-Kpop,n-k) / NOverK(Npop,n); end;

function HyperGeoCumulatief(Npop,n,Kpop,k1,k2: longint): extended;
var k: longint; r: extended;
begin
  r:= 0.0;
  for k:= k1 to k2 do r:= r + HyperGeo(Npop,n,Kpop,k);
  HyperGeoCumulatief:= r;
end;

function Poisson(m: extended; k: longint): extended;
var i: longint; x: extended;
begin
(*Poisson:= power(m,k) * exp(-m) / fac(k);*)
  x:= 1.0;
  for i:= 1 to k do
    x:= x * m / i;
  Poisson:= x * exp(-m);
end;

function PoissonCumulatief(m: extended; k1,k2: longint): extended;
var k: longint; r,s: extended;
begin
  if k1 > k2 then PoissonCumulatief:= 0.0
  else begin
    k:= k1; r:= Poisson(m,k); s:= r;
    while (k < k2) and (r > epsilon) do begin { <=== PM Niet altijd convergent !}
      inc(k);
      r:= m/k * r;
      s:= s + r;
    end;
    PoissonCumulatief:= s;
  end;
end;

function Normaal(x,sigma,mu: extended): extended;
{ Hasting's benadering }
const
  P  =  0.2316419;    C3 =  1.78147937;
  C1 =  0.31938153;   C4 = -1.821255978;
  C2 = -0.356563782;  C5 =  1.330274429;
var
  u,t,r: extended;
begin
  if sigma = 0.0 then begin if x > mu then Normaal:= 1.0 else Normaal:= 0.0 end
  else begin
    u:= abs(x-mu)/sigma;
    t:= 1.0 / (1.0 + P * u);
    r:= 1.0 - 1/sqrt(2*Pi) * exp(-u*u/2) *
              t*(C1 + t*(C2 + t*(C3 + t*(C4 + t*C5))));
    if x > mu then Normaal:= r else Normaal:= 1.0 - r;
  end;
end;


END.
