{ BNM.PAS - Kansberekening  bij steekproef - Binomiale verdeling en afgeleiden

  title    : BNM
  version  : 1.0
  date     : Apr 22,1993
  author   : J R Ferguson
  language : Borland Pascal v7.0 with Objects
  target   : MS-Windows v3.1
  usage    : program

  Naar: H.P. Anderson, "Statistische technieken en hun toepassingen"
        Nijgh & Van Ditmar, Den Haag, 1969 (5e druk)
        ISBN 90 236 0186 6
}

{$I BNMOPTS.INC}  { compiler options }

PROGRAM BNM;


uses
  WinDos , WinTypes, WinProcs, Strings,
  Objects, OWindows, ODialogs,
  BnmMath;

{$R BNM.RES}      { resources }
{$I BNMRESC.INC}  { resource related constants }

const
{ defaults }
  C_DflOptOnafh = true;
  C_DflOptZoek  = false;
  C_DflOper     = id_EQ;
  C_DflMeth     = id_BinomiaalFormule;

{ other constants }
  C_MaxLongStr  = 5;
  C_MaxRealStr  = 7;

type
  P_MainDlgBuf  = ^T_MainDlgBuf;
  P_MainWindow  = ^T_MainWindow;
  P_Application = ^T_Application;

  T_Oper        = id_LT..id_GT;
  T_Meth        = id_BinomiaalFormule..id_Hypergeometrisch;

  T_MainDlgBuf  = record
    Str_n     : array[0..C_MaxLongStr] of char;
    Str_Npop  : array[0..C_MaxLongStr] of char;
    Str_k     : array[0..C_MaxLongStr] of char;
    Str_p     : array[0..C_MaxRealStr] of char;
    Str_kans  : array[0..C_MaxRealStr] of char;
    Opt_Oper  : array[T_Oper] of word;
    Opt_Onafh : word;
    Opt_Zoek  : word;
    Opt_Meth  : array[T_Meth] of word;
  end;

  T_MainWindow  = object(TDlgWindow)
    k, n, Npop  : longint;
    p, kans     : extended;
    OptOnafh    : boolean;
    OptZoek     : boolean;
    Oper        : T_Oper;
    Meth        : T_Meth;
    constructor Init(V_Parent: PWindowsObject; V_Title: PChar);
    destructor  Done; virtual;
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var V_Class: TWndClass); virtual;
    procedure   MathInit;
    procedure   MathTerm;
    procedure   DlgInit;
    procedure   DlgTerm;
    procedure   DlgImport;
    function    DlgExport: boolean;
    procedure   ErrorMsg(V_ErrMsg: PChar);
    procedure   CMHelpUitleg(var V_Msg: TMessage); virtual cm_First + cm_HelpUitleg;
    procedure   CMHelpInfo  (var V_Msg: TMessage); virtual cm_First + cm_HelpInfo;
    procedure   IDBereken   (var V_Msg: TMessage); virtual id_First + id_Bereken;
    procedure   ZoekMethode;
    procedure   BinomiaalFormule;
    procedure   BinomiaalNormaal;
    procedure   PoissonFormule;
    procedure   PoissonNormaal;
    procedure   HyperGeometrisch;
  end;

  T_Application = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

var
  G_Application : T_Application;


{ --- General routines --- }

function SetCheck(b: boolean): word;
begin if b then SetCheck:= bf_Checked else SetCheck:= bf_UnChecked; end;


{ --- T_MainWindow methods --- }

constructor T_MainWindow.Init(V_Parent: PWindowsObject; V_Title: PChar);
begin
  inherited Init(V_Parent, V_Title);
  MathInit;
  Dlginit;
end;

destructor  T_MainWindow.Done;
begin
  MathTerm;
  DlgTerm;
  inherited Done;
end;

function T_MainWindow.GetClassName: PChar;
begin GetClassName:= 'BNMMAIN'; end;

procedure T_MainWindow.GetWindowClass(var V_Class: TWndClass);
begin
  inherited GetWindowClass(V_Class);
  V_Class.hIcon:= LoadIcon(HInstance,MakeIntResource(ICO_MAINWIN));
end;

procedure T_MainWindow.MathInit;
begin
  k            := 0;
  n            := 0;
  Npop         := 0;
  p            := 0.0;
  kans         := 0.0;
  OptOnafh     := C_DflOptOnafh;
  OptZoek      := C_DflOptZoek;
  Oper         := C_DflOper;
  Meth         := C_DflMeth;
end;

procedure T_MainWindow.MathTerm;
begin
  {PM}
end;

procedure T_MainWindow.DlgInit;
var Control: PControl; var i: integer;
begin
  Control:= New(PEdit    , InitResource(@Self, id_n     , C_MaxLongStr+1));
  Control:= New(PEdit    , InitResource(@Self, id_Npop  , C_MaxLongStr+1));
  Control:= New(PEdit    , InitResource(@Self, id_k     , C_MaxLongStr+1));
  Control:= New(PEdit    , InitResource(@Self, id_p     , C_MaxRealStr+1));
  Control:= New(PStatic  , InitResource(@Self, id_kans  , C_MaxRealStr+1));
  for i:= id_LT to id_GT do
    Control:= New(PRadioButton, InitResource(@Self, i));
  Control:= New(PCheckBox, InitResource(@Self, id_Onafh));
  Control:= New(PCheckBox, InitResource(@Self, id_Zoek ));
  for i:= id_BinomiaalFormule to id_Hypergeometrisch do
    Control:= New(PRadioButton, InitResource(@Self, i));
  TransferBuffer:= new(P_MainDlgBuf);
  DlgImport;
end;

procedure T_MainWindow.DlgTerm;
begin
  dispose(TransferBuffer);
end;

procedure T_MainWindow.DlgImport;
var i: integer;
begin with P_MainDlgBuf(TransferBuffer)^ do begin
  Str(n       ,Str_n);
  Str(k       ,Str_k);
  Str(Npop    ,Str_Npop);
  Str(p   :7:5,Str_p);
  Str(kans:7:5,Str_kans);
  Opt_Onafh  := SetCheck(OptOnafh);
  Opt_Zoek   := SetCheck(OptZoek);
  for i:= id_LT               to id_GT               do Opt_Oper[i]:= SetCheck(i = Oper);
  for i:= id_BinomiaalFormule to id_Hypergeometrisch do Opt_Meth[i]:= SetCheck(i = Meth);
  TransferData(tf_SetData);
end; end;


function  T_MainWindow.DlgExport: boolean;
var i: integer;

  function GetLong(s: PChar; var value: LongInt; min, max: LongInt; msg: PChar): boolean;
  var n: LongInt; ErrPos: integer;
  begin
    Val(s,n,ErrPos);
    if (ErrPos=0) and (n >= min) and (n <= max) then begin value:= n; GetLong:= true; end
    else begin ErrorMsg(msg); GetLong:= false; end;
  end;

  function GetReal(s: PChar; var value: extended; min, max: extended; msg: PChar): boolean;
  var x: extended; ErrPos: integer;
  begin
    Val(s,x,ErrPos);
    if (ErrPos=0) and (x >= min) and (x <= max) then begin value:= x; GetReal:= true; end
    else begin ErrorMsg(msg); GetReal:= false; end;
  end;

begin with P_MainDlgBuf(TransferBuffer)^ do begin {DlgExport}
  TransferData(tf_GetData);
  OptOnafh := Opt_Onafh = bf_Checked;
  OptZoek  := Opt_Zoek  = bf_Checked;
  for i:= id_LT to id_GT do
    if Opt_Oper[i] = bf_Checked then Oper:= i;
  for i:= id_BinomiaalFormule to id_Hypergeometrisch do
    if Opt_Meth[i] = bf_Checked then Meth:= i;
  DlgExport:= GetLong(Str_n, n, 0  , 99999, 'n ongeldig')
          and GetLong(Str_k, k, 0  , n    , 'k ongeldig')
          and GetReal(Str_p, p, 0.0, 1.0  , 'p ongeldig')
          and((OptOnafh and (Meth <> id_HyperGeometrisch)) or
              GetLong(Str_Npop, Npop, n, MaxLongInt, 'N ongeldig'));
end; end;


procedure T_MainWindow.ErrorMsg(V_ErrMsg: PChar);
begin MessageBox(HWindow, V_ErrMsg,'fout',mb_IconExclamation or mb_OK); end;

procedure T_MainWindow.CMHelpUitleg(var V_Msg: TMessage);
begin
  G_Application.ExecDialog(New(PDialog,Init(@Self,MakeIntResource(DLG_UITLEG))));
end;

procedure T_MainWindow.CMHelpInfo(var V_Msg: TMessage);
begin
  MessageBox(HWindow, 'Kansberekening bij steekproef'#13 +
                      'Binomiale verdeling en afgeleiden'#13#13 +
                      'BNM v1.0 (MS-Windows v3.1)'#13 +
                      '(c) 1993, J.R. Ferguson',
                      'Informatie',
                      mb_IconInformation or mb_OK);
end;

procedure T_MainWindow.IDBereken(var V_Msg: TMessage);
begin
  if DlgExport then begin
    if OptZoek then ZoekMethode
    else case Meth of
      id_BinomiaalFormule : BinomiaalFormule;
      id_BinomiaalNormaal : BinomiaalNormaal;
      id_PoissonFormule   : PoissonFormule;
      id_PoissonNormaal   : PoissonNormaal;
      id_HyperGeometrisch : HyperGeometrisch;
    end;
    DlgImport;
  end;
end;


procedure T_MainWindow.ZoekMethode;

  procedure ZoekBinomiaal;
  var p1: extended;
  begin
    if p <= 0.5 then p1:= p else p1:= 1-p;
    if (p1 = 0.0) or (n < 9 * (1-p1)/p1) then BinomiaalFormule else BinomiaalNormaal;
  end;

  procedure ZoekPoisson;
  begin if n * p > 10 then PoissonNormaal else BinomiaalFormule; end;

begin {ZoekMethode}
  if OptOnafh or (Npop >= 10 * n) then begin
    if (n <= 10) or (p >= 0.1) then ZoekBinomiaal else ZoekPoisson;
  end
  else HyperGeometrisch;
end;


procedure T_MainWindow.BinomiaalFormule;
var i: longint;
begin
  Meth := id_BinomiaalFormule;
  case Oper of
    id_LT : kans:= BinomiaalCumulatief(n, 0  , k-1, p);
    id_LE : kans:= BinomiaalCumulatief(n, 0  , k  , p);
    id_EQ : kans:= Binomiaal(n,k,p);
    id_GE : kans:= BinomiaalCumulatief(n, k  , n  , p);
    id_GT : kans:= BinomiaalCumulatief(n, k+1, n  , p);
  end;
end;

procedure T_MainWindow.BinomiaalNormaal;
var sigma, mu: extended;
begin
  Meth  := id_BinomiaalNormaal;
  mu    := n*p;
  sigma := sqrt(mu*(1-p));
  case Oper of
    id_LT : kans:= Normaal(k-0.5,sigma,mu);
    id_LE : kans:= Normaal(k+0.5,sigma,mu);
    id_EQ : kans:= Normaal(k+0.5,sigma,mu) - Normaal(k-0.5,sigma,mu);
    id_GE : kans:= 1.0 - Normaal(k-0.5,sigma,mu);
    id_GT : kans:= 1.0 - Normaal(k+0.5,sigma,mu);
  end;
end;

procedure T_MainWindow.PoissonFormule;
begin
  Meth := id_PoissonFormule;
  case Oper of
    id_LT : kans:= PoissonCumulatief(n*p,0  ,k-1);
    id_LE : kans:= PoissonCumulatief(n*p,0  ,k  );
    id_EQ : kans:= Poisson(n*p,k);
    id_GE : kans:= PoissonCumulatief(n*p,k  ,n  );
    id_GT : kans:= PoissonCumulatief(n*p,k+1,n  );
  end;
end;

procedure T_MainWindow.PoissonNormaal;
var sigma, mu: extended;
begin
  Meth  := id_PoissonNormaal;
  mu    := n * p;
  sigma := sqrt(mu);
  case Oper of
    id_LT : kans:= Normaal(k-0.5,sigma,mu);
    id_LE : kans:= Normaal(k+0.5,sigma,mu);
    id_EQ : kans:= Normaal(k+0.5,sigma,mu) - Normaal(k-0.5,sigma,mu);
    id_GE : kans:= 1.0 - Normaal(k-0.5,sigma,mu);
    id_GT : kans:= 1.0 - Normaal(k+0.5,sigma,mu);
  end;
end;

procedure T_MainWindow.HyperGeometrisch;
var Kpop: longint;
begin
  Meth:= id_HyperGeometrisch;
  Kpop:= round(p * Npop);
  case Oper of
    id_LT : kans:= HyperGeoCumulatief(Npop,n,Kpop,0  ,k-1);
    id_LE : kans:= HyperGeoCumulatief(Npop,n,Kpop,0  ,k  );
    id_EQ : kans:= HyperGeo(Npop,n,Kpop,k);
    id_GE : kans:= HyperGeoCumulatief(Npop,n,Kpop,k  ,n  );
    id_GT : kans:= HyperGeoCumulatief(Npop,n,Kpop,k+1,n  );
  end;
end;



{ --- T_Application methods --- }

procedure T_Application.InitMainWindow;
begin MainWindow:= New(P_MainWindow,Init(nil,MakeIntResource(DLG_MAINWIN))); end;


{ --- Main program --- }

BEGIN
  with G_Application do begin
   Init('BNM');
   Run;
   Done;
  end;
END.
