{        Ŀ        }
{         This UNIT has been created by Bartha Istvn  2000.01.22          }
{                }
{ Description: Reads and displays the contents of a text file;               }
{                                                                            }
{ Usage: var filepath:string;   - path of the text file (c:\docs\...)        }
{            firstline:integer; - starting line to read from                 }
{            line:integer;      - nr of lines read from file                 }
{            total:integer;     - nr of all lines in a file                  }
{            wrapline:integer:  - nr of wrapped lines                        }
{            error:string;      - error code: 0='File was read..ok'          }
{                                             1='File was not found'         }
{                                             2='File is too big'            }
{            startline:integer; - from wich (file) line to display the text  }
{            maxline:integer;   - the max nr of lines to display             }
{            maxchar:integer;   - the max nr of characters in a line         }
{            wrap:integer;      - switch of wrap mode ( 0=OFF 1=ON )         }
{                                                                            }
{       READFILE(filepath,firstline,line,error); - read the file into memory }
{       VIEWFILE(startline,maxline,maxchar,wrap);    - shows 'selected' text }
{       COUNTLINE(filepath,lines);                   - total number of lines }
{       COUNTWRAP(beginline,maxline,maxchar,wrapline); - nr of wrapped lines }

                             { THIS IS A UNIT ! }

UNIT Viewer; {$S-}  { WARNING ! This unit may still be buggy }

INTERFACE

var READFILE_Reads_the_file_into_memory:word;
var VIEWFILE_Displays_the_file:word;
var COUNTLINE_Counts_nr_of_lines_in_the_file:word;
var COUNTWRAP_Counts_nr_of_Wrapped_lines:word;

procedure AboutViewer;
procedure Readfile(var filepath:string; var firstline:integer; var line:integer; var error:integer);
procedure CountLine(var filepath:string; var total:integer);
procedure CountWrap(var beginline,maxline,maxchar,wrapline:integer);
procedure Viewfile(var startline,maxline,maxchar,wrap:integer);

IMPLEMENTATION
uses Crt;
var textfile:text; l1:char;
    v:array[-1..32000] of char;               { vector of all letters }
    l:array[-1..10000] of integer; { line separator: 'begin nr'of new line }
    line2,c,ch,ch8,comp,p,x,y,x2,y2:integer;


procedure Readfile(var filepath:string; var firstline:integer; var line:integer; var error:integer);
label 1,2;
begin line:=0; error:=0; c:=0; if filepath='' then goto 2;

FillChar(v,Sizeof(v),' ');
{repeat v[c]:=' ';c:=c+1; until c=32001;   { clear the garbage from vector }

{$I-}Close(textfile);{$I+}if IOresult<>0 then delay(0);
assign(textfile,filepath);
{$I-}reset(textfile);{$I+}if IOresult<>0 then           { open for reading }
begin error:=1;goto 2;end;

if firstline>1 then                                  { go to starting line }
begin c:=1; repeat readln(textfile);c:=c+1; until c=firstline; end;

c:=0;line:=0;l[0]:=1;
repeat
  c:=c+1;
  repeat
    read(textfile,l1);                                     { read a letter }
    { writeln('char ',c,'<=>',Ord(l1)); readkey;  { Debug: show ASCII code }

    { If empty line was detected: }
    if Ord(l1)=10 then begin v[c-3]:='';v[c-2]:=' ';v[c-1]:=' ';goto 1;end;
    { Explanation: if the program  meets an empty line, it skips 2 letters
        (counter increases, but no sign read) then reads ASCII 13, then 10 }

    v[c]:=l1;                                    { save letter into vector }
    if Ord(l1)=9 then v[c]:='';   { if 6 space marker (o) found then mark }
    c:=c+1;
    if(c+2>31900)or(line+2>9900)then
    begin line:=line-1;error:=2;goto 2; end;    { too big }

  until eoln(textfile);     { - spin this cicle until it's end of the line }
1: c:=c+1; v[c]:=''; line:=line+1;        { mark and count th end of line }
  l[line]:=c+1;                  { save next line's first char's order nr. }
  if Ord(l1)<>10 then readln(textfile);
until eof(textfile);        { - spin this cicle until it's end of the file }
v[c+1]:='';                                    { mark the end of the file }

2: {$I-}Close(textfile);{$I+}if IOresult<>0 then delay(0);
end;


procedure CountLine(var filepath:string; var total:integer);
label 1;
begin
{$I-}Close(textfile);{$I+}if IOresult<>0 then delay(0);
assign(textfile,filepath);
{$I-}reset(textfile);{$I+}if IOresult<>0 then           { open for reading }
begin total:=0;goto 1;end;

total:=0;
repeat
  total:=total+1;readln(textfile);
until eof(textfile);
1:end;


procedure CountWrap(var beginline,maxline,maxchar,wrapline:integer);
label 1,2;
begin
line2:=0;c:=0;ch:=0;wrapline:=0;c:=l[beginline-1]; if beginline<>1 then ch:=1;
repeat
  if v[c]='' then                                 { if 6 space mark found }
  begin
    if(ch+6<=maxchar)and(v[c-1]<>'')then
    begin
      if(v[c-1]='')and(ch+7<=maxchar)then ch:=ch+1;
      ch:=ch+6; goto 1;
    end;
    if(ch+7<=maxchar)and(v[c-1]='')then
    begin
      ch:=ch+7; goto 1;
    end;
    goto 2; { if maxchar won't allow the spaces }
     1:
  end;
  begin
    if(v[c]='')or(ch=maxchar+1)then  { if end of line mark found or limit }
    begin 2:
      if ch=maxchar+1 then wrapline:=wrapline+1;
      ch:=0; line2:=line2+1;
      if(v[c]<>'')and(line2<>maxline)then ch:=ch+1;
    end;
  end;
  c:=c+1; ch:=ch+1; { encrease total(c) and current line(ch) char. counter }
until (v[c]='') or (line2=maxline);  { if end of file mark found or limit }
end;


procedure Viewfile(var startline,maxline,maxchar,wrap:integer);
label 1;
begin
x:=Wherex;y:=Wherey;                      { get cursor position at startup }
line2:=0;c:=0;ch:=1;ch8:=1;c:=l[startline-1];  if startline<>1 then ch:=1;{}

{ writeln('-> Maximum nr. of lines : ',maxline);{}
{ writeln('-> Startline : ',startline);{}
{ writeln('-> Nr of start character: ',c);readkey;{}

if v[c]='' then goto 1;

repeat
  if v[c]='' then                               { if space mark was found }
  begin
    comp:=9-ch8; p:=0;
    if ch+comp-1<=maxchar then
    repeat
      write(' ');
      p:=p+1;
    until p=comp;     ch:=ch+comp-1; ch8:=0;
  end else
  begin
    if(v[c]='')or(ch>=maxchar+1)then  { if end of line mark found or limit }
    begin { writeln;{}
      ch:=0;ch8:=0;  y2:=Wherey;  x2:=Wherex;
      {if(x2=1)and(v[c]<>'')and(maxchar+x-1<>80)then c:=c-1 else{}
      if x2<>1 then gotoxy(x,y2+1);                    { jump to next line }
      line2:=line2+1;
      { => unwrapped display }
      if wrap=0 then c:=l[startline+line2-1]-1 else
      { => wrapped display }
      begin
        y2:=Wherey;
        if(v[c]<>'')and(line2<>maxline)then begin write(v[c]);ch:=ch+1;end;
      end;{}
    end
    else write(v[c]);
  end;    { Readkey;{} y2:=Wherey;

  c:=c+1; ch:=ch+1; ch8:=ch8+1; if ch8=9 then ch8:=1;

until (v[c]='') or (y2=maxline+y);   { if end of file mark found or limit }
1:
{ writeln('-> File was Displayed !');readkey;{}
end;


procedure AboutViewer;
begin
textcolor(10);textbackground(0);clrscr;
writeln('        Ŀ  ');
writeln('         This UNIT has been created by Bartha Istvn  2000.01.20    ');
writeln('          ');
textcolor(15);delay(100);
writeln;
writeln(' Description: Reads and displays the contents of a text file;         ');
writeln;
writeln(' Usage: var filepath:string;   - path of the text file (c:\docs\...)  ');
writeln('            firstline:integer; - starting line to read from           ');
writeln('            line:integer;      - nr of lines read from file           ');
writeln('            total:integer;     - nr of all lines in a file            ');
writeln('            wrapline:integer:  - nr of wrapped lines                  ');
writeln('            error:string;      - error code: 0=''File was read..ok''    ');
writeln('                                             1=''File was not found''   ');
writeln('                                             2=''File is too big''      ');
writeln('            startline:integer; - from wich (file) line to display the text ');
writeln('            maxline:integer;   - the max nr of lines to display       ');
writeln('            maxchar:integer;   - the max nr of characters in a line   ');
writeln('            wrap:integer;      - switch of wrap mode ( 0=OFF 1=ON )   ');
writeln;
writeln('       READFILE(filepath,firstline,line,error); - read the file into memory ');
writeln('       VIEWFILE(startline,maxline,maxchar,wrap);    - shows ''selected'' text ');
writeln('       COUNTLINE(filepath,lines);                   - total number of lines ');
writeln('       COUNTWRAP(beginline,maxline,maxchar,wrapline); - nr of wrapped lines ');
readkey;{textcolor(7);clrscr;}
end;


end.

{----------------------------- HOW IT WORKS: --------------------------------}

Any kind of text-file (3 lines):

{-- BOF ---}

Is this a text file ? Yes it is ... |  1. -> text in the file
Is this a text file ? Yes it is ... |     -> (nothing happens)
                                    |
2nd     line     coming up ...      |  2. -> text in the file
       8       8       8            |
2ndline coming up ...             |     -> how it is displayed
                                    |
 This      is     so   erratic ...  |  3. -> text in the file
       8       8       8            |
 This   is  so   erratic ...      |     -> how it is displayed

{-- EOF ---}

Explanation:
    1. Nothing happens if only 1 space
  2-3. The lines 'are separated' into pieces of 8 letters,
       if there's space at the eight letter (last) then it
       'looks' for spaces before it and if finds more than
       one then it replaces it with the nr. 9 ASCII code.
    -> here it is simbolized with the '' sign !
