{        Ŀ      }
{         This UNIT has been created by Bartha Istvn  2002.03.01        }
{              }
{ Description: Makes you able to use files instead of arrays;              }
{ Usage: var/const order:longint;       - the ordernumber (index) of data  }
{                  value:integer;       - input data variable/constant     }
{                  strin:string;        - input data variable/constant     }
{        const SwapPathValue:string;    - path of the swapfile for numbers }
{        const SwapPathStrin:string;    - path of the swapfile for strings }
{                                                                          }
{        putv(order,value);             - save value with index order      }
{        getv(order,value);             - get value with index order       }
{        puts(order,strin);             - save string with index order     }
{        gets(order,strin);             - get string with index order      }
{        value(order):integer;          - value with index order           }
{        strin(order):string;           - string with index order          }
{        DeleteSwapFile;                - deletes the current swap file    }

                            { THIS IS A UNIT ! }

UNIT Swap;

INTERFACE
var SwapPathValue:string;
var SwapPathStrin:string;
var first_run:integer;
var maxbuffer:longint;
var minbuffer:longint;
var buffer:array[0..5999] of char;

procedure AboutSwap;
procedure putv(order:longint;    value:integer);
procedure getv(order:longint;var value:integer);
function  value(order:longint):integer;
procedure puts(order:longint;    strin:string);
procedure gets(order:longint;var strin:string);
function  strin(order:longint):string;
procedure DeleteSwapFile;

IMPLEMENTATION
uses Crt,Dos;
var vfile,sfile:file;
    NumRead,NumWritten:word;
    invalue:array[0..4] of char;
    instrin:array[0..29] of char;
    svalue:string;
    code:integer; c,i,size:longint;


procedure DiskFull;
begin writeln('ERROR: Disk full !');HALT; end;

{==========================  Integer Commands  ==============================}

procedure putv(order:longint;value:integer);
begin
  order:=order+1; { Start numbering from zero }
  if SwapPathValue=''then SwapPathValue:='swp-val.$$$';
  assign(vfile,SwapPathValue);
  {$I-}reset(vfile,1);{$I+}if IOresult<>0 then rewrite(vfile,1);

  FillChar( svalue,Sizeof( svalue),' '); FillChar( invalue,5,' ');

  size:=FileSize(vfile);
  if (size div 5)<order then Seek(vfile,size)
                        else Seek(vfile,(order-1)*5);

  for c:=1 to order-(size div 5)-1 do
  begin
    BlockWrite( vfile, invalue, 5, NumWritten );
    if NumWritten<>5 then DiskFull;
  end;

  str(value,svalue);  for c:=0 to 4 do invalue[c]:=svalue[c+1];
  BlockWrite( vfile, invalue, 5, NumWritten ); if NumWritten<>5 then DiskFull;
  Close(vfile);
end;


procedure getv(order:longint;var value:integer);
begin
  order:=order+1; { Start numbering from zero }
  if SwapPathValue='' then SwapPathValue:='swp-val.$$$';
  assign(vfile,SwapPathValue);
  {$I-}reset(vfile,1);{$I+}if IOresult<>0 then begin value:=0;exit; end;

  svalue:=''; FillChar(invalue,5,' ');

  Seek(vfile,(order-1)*5);
  BlockRead( vfile, invalue, 5, NumRead );

  c:=0;
  repeat
    svalue:=svalue+invalue[c];
    inc(c);
  until(c=5)or(invalue[c]=' ');

  Val(svalue, value, code); Close(vfile);
end;


function value(order:longint):integer;
var vl:integer;
begin
  getv(order,vl);
  value:=vl;
end;

{============================  String Commands  =============================}

procedure puts(order:longint;    strin:string);
begin
  order:=order+1; { Start numbering from zero }
  if first_run=0 then
  begin
    first_run:=1;
    if SwapPathStrin=''then SwapPathStrin:='swp-str.$$$';
    assign(sfile,SwapPathStrin);
    {$I-}reset(sfile,1);{$I+}if IOresult<>0 then rewrite(sfile,1);
  end;

  FillChar( instrin[0],30,' ');

  size:=FileSize(sfile);
  if (size div 30)<order then Seek(sfile,size)
                         else Seek(sfile,(order-1)*30);

  for c:=1 to order-(size div 30)-1 do
  begin
    BlockWrite(sfile,instrin,30,NumWritten);
    if NumWritten<>30 then DiskFull;{}
  end;

  for c:=0 to length(strin)-1 do instrin[c]:=strin[c+1];

  BlockWrite(sfile,instrin,30,NumWritten); if NumWritten<>30 then DiskFull;{}
end;


procedure gets(order:longint;var strin:string); { Buffered swapping ;-) }
begin
  strin:='';

  if(order>maxbuffer)or(order<minbuffer)or(maxbuffer=minbuffer)then
  begin
    FillChar( buffer,5999,' ');       { If not in buffer => make new buffer }

    Seek(sfile,(order)*30);
    BlockRead( sfile, buffer, 5999, NumRead );

    minbuffer:=order;
    maxbuffer:=order+(Numread div 30)-1;
  end;

  i:=(order-minbuffer)*30; c:=i;         { If in buffer => read from buffer }
  repeat
    if buffer[c]=' ' then break;
    strin:=strin+buffer[c];
    inc(c);
  until c=i+30;

end;


function strin(order:longint):string;
var st:string;
begin
  gets(order,st);
  strin:=st;
end;


procedure DeleteSwapFile;
begin
  assign(sfile,SwapPathValue);
  {$I-}erase(sfile);{$I+}if IOresult<>0 then code:=0;
  assign(sfile,SwapPathStrin);
  {$I-}erase(sfile);{$I+}if IOresult<>0 then code:=0;
end;


procedure AboutSwap;
begin
textcolor(10);textbackground(0);clrscr;
writeln('         Ŀ     ');
writeln('          This UNIT has been created by Bartha Istvn  2002.03.01       ');
writeln('              ');
textcolor(15);delay(100);
writeln(' Description: Makes you able to use files instead of arrays;              ');
writeln;
writeln(' Usage: var/const order:longint;       - the ordernumber (index) of data  ');
writeln('                  value:integer;       - input data variable/constant     ');
writeln('                  strin:string;        - input data variable/constant     ');
writeln('        const SwapPathValue:string;    - path of the swapfile for numbers ');
writeln('        const SwapPathStrin:string;    - path of the swapfile for strings ');
writeln;
writeln('        putv(order,value);             - save value with index order      ');
writeln('        getv(order,value);             - get value with index order       ');
writeln('        puts(order,strin);             - save string with index order     ');
writeln('        gets(order,strin);             - get string with index order      ');
writeln('        value(order):integer;          - value with index order           ');
writeln('        strin(order):string;           - string with index order          ');
writeln('        DeleteSwapFile;                - deletes the current swap file    ');
readkey;{textcolor(7);clrscr;}
end;

end.