{        Ŀ        }
{         This UNIT has been created by Bartha Istvn  2002.05.10          }
{                }
{ Description: Starts a command prompt for reading user input;               }
{ Usage: const                                                               }
{            x0,y0:integer;             - startup coordinates;               }
{            max:integer;               - length of displayed string;        }
{        var                                                                 }
{            result:string;             - the result variable;               }
{            rln_enter,rln_esc,         - if ENTER,ESC or TAB is pressed,    }
{            rln_tab:integer;             corresponding variable becomes 1;  }
{            rln_nospace:integer;       - no leading and trailing spaces     }
{                                                                            }
{            ReadLine(x0,y0,max,result) - command to call this unit;         }

                            { THIS IS A UNIT ! }

UNIT Rln; {$S-}

INTERFACE
var READLINE_starts_a_command_prompt_to_read_user_input:word;
var rln_enter,rln_esc,rln_tab:integer;
var rln_reset:integer;
var rln_nospace:integer;

procedure AboutReadL;
procedure ReadLine( x0,y0:integer; max:integer; var result:string );

IMPLEMENTATION

uses Crt;
const maxch=80;
var x,sx,c,last,firstrun,ins:integer;
    key:char;
    line:array[1..maxch] of char;


procedure EAT(nr:integer);
begin
  c:=nr;
  if c<>last then
  repeat line[c]:=line[c+1]; inc(c); until c=last;
  line[c]:=#0;
end;

procedure Show_mouse;
begin  asm mov ax,01h;int 33h end;  end;

procedure Hide_mouse;
begin  asm mov ax,02h;int 33h end;  end;

procedure READLINE( x0,y0:integer; max:integer; var result:string );
label 0;
begin

  if(firstrun=0)or(rln_reset=1)then
  begin
    if(max<=0)or(max>80)then begin result:='Error';exit;end;
    last:=Length(result); x:=last+1; if x>max then sx:=x-max else sx:=1;
    FillChar( line[1], maxch, #0);
    for c:=1 to Length(result) do line[c]:=result[c];
    gotoxy(x0,y0);
    Hide_Mouse; for c:=sx to sx+max-1 do write(line[c]); Show_Mouse;
    firstrun:=1;rln_reset:=0;
  end;

  rln_tab:=0;rln_enter:=0;rln_esc:=0;

{  gotoxy(1,1); writeln('sx:',sx,' x:',x,' last:',last,' line:',line);{}
{  gotoxy(1,8); writeln(' data:',result);{}

  gotoxy(x0+x-sx,y0);
  if KeyPressed then key:=readkey else exit;

  case key of
    #9 : begin rln_tab:=1;   goto 0; end;                { TAB }
    #13: begin rln_enter:=1; goto 0; end;                { ENTER }
    #27: begin rln_esc:=1;   goto 0; end;                { ESC }
    #8 : if x>1 then                                     { BKSPACE }
         begin
           if x>last then  begin x:=x-1;line[x]:=#0;last:=last-1; end
                     else  begin EAT(x-1);x:=x-1;last:=last-1; end;
           if(x-sx<=max)and(sx<>1)then dec(sx);
         end;
    #0:  case readkey of       { Special keys }
           #82: if ins=0 then                            { INSERT }
                begin
                   ins:=1;asm mov ah,01h; mov ch,03h; mov cl,01h; int 10h end;
                end else
                begin
                   ins:=0;asm mov ah,01h; mov ch,06h; mov cl,07h; int 10h end;
                end;
           #83: begin                                    { DELETE }
                  if x<=last then  begin EAT(x);last:=last-1; end;
                end;
           #75: begin                                    { <- }
                  if x>1 then  begin x:=x-1; if x+1=sx then dec(sx); end;
                end;
           #77: begin                                    { -> }
                  if x<last+1 then  begin x:=x+1; if x-1-sx=max then inc(sx); end;
                end;
           #79: begin                                    { END }
                  x:=last+1; if last-sx>=max then sx:=x-max;
                end;
           #71: begin x:=1;sx:=1; end;                   { HOME }
         end;
  else
    if last<>maxch then
    begin
      if x>last then begin line[x]:=key;last:=x; x:=x+1; end
      else
      begin
        if ins=0 then
        begin
          c:=last; repeat line[c+1]:=line[c];dec(c); until c=x-1;
          last:=last+1;
        end;
        line[x]:=key; x:=x+1;
      end;
      if x-1-sx=max then inc(sx);
    end else if(ins=1)and(x<>last+1)then begin line[x]:=key;x:=x+1; end;
  end;

  gotoxy(x0,y0);
  Hide_Mouse; for c:=sx to sx+max-1 do write(line[c]); Show_Mouse;

0:

c:=maxch;
repeat
  if line[c]=#0 then dec(c);
until (c=0)or(line[c]<>#0);

result:=Copy(line,1,c);
if rln_nospace=1 then
begin
  while (Length(result)>0) and (result[1]=' ') do Delete(result,1,1);
  while (Length(result)>0) and (result[Length(result)]=' ') do
  Delete(result,Length(result),1);
end;

end;


procedure AboutReadL;
begin
textcolor(10);textbackground(0);clrscr;
writeln('        Ŀ       ');
writeln('         This UNIT has been created by Bartha Istvn  2002.05.10         ');
writeln('               ');
textcolor(15);delay(100);
writeln;
writeln(' Description: Starts a command prompt for reading user input;              ');
writeln(' Usage: const                                                              ');
writeln('            x0,y0:integer;             - startup coordinates;              ');
writeln('            max:integer;               - length of displayed string;       ');
writeln('        var                                                                ');
writeln('            result:string;             - the result variable;              ');
writeln('            rln_enter,rln_esc,         - if ENTER,ESC or TAB is pressed,   ');
writeln('            rln_tab:integer;             corresponding variable becomes 1; ');
writeln('            rln_nospace:integer;       - no leading and trailing spaces    ');
writeln('                                                                           ');
writeln('            ReadLine(x0,y0,max,result) - command to call this unit;        ');
readkey;{textcolor(7);clrscr;}
end;


end.