{        Ŀ        }
{          This UNIT has been created by Bartha Istvn  2000.3.27          }
{                }
{ Description: Standard File Operations (utilities);                         }
{ Usage: var paramstr1:string;        - first parameter (eg. path...)        }
{            paramstr2:string;        - second parameter (eg. path...)       }
{            overw:integer;           - overwrite switch: 0=OFF 1=ON         }
{            real :integer;           - real delete switch: 0=OFF 1=ON       }
{            error:integer;           - errorcode variable                   }
{            path::string;            - a path variable                      }
{                                                                            }
{            AddBslash(path);         - adds a backslash if needed           }
{            DelBslash(path);         - deletes the backslash if possible    }
{            UpperCase(str);          - transforms into uppercase            }
{            FileExists(cpath):boolean;     - True/False                     }
{            DirExists(path):boolean;       - True/False                     }
{            Fcopy(paramstr1,paramstr2,overw,error) - copy a file            }
{            Fmove(paramstr1,paramstr2,overw,error) - move a file            }
{            Fdelete(paramstr1,real,error) - delete a file                   }

                           { THIS IS A UNIT ! }

UNIT Futils;
{$I-,S-}

INTERFACE
var FCOPY_copies_a_file_to_new_path_or_name:word;
var FMOVE_moves_a_file_to_new_path_or_name_with_rename_method:word;
var FDELETE_deletes_a_file_with_normal_or_real_delete:word;

procedure AboutFutils;
procedure AddBslash(var path:string);
procedure DelBslash(var path:string);
procedure UpperCase(var str:string);
function  FileExists(cpath:string):boolean;
function  DirExists(path:string):boolean;

procedure Fcopy(paramstr1,paramstr2:string; overw:integer; var error:integer);
procedure Fmove(paramstr1,paramstr2:string; overw:integer; var error:integer);
procedure Fdelete(paramstr1:string; real:integer; var error:integer);

IMPLEMENTATION
uses Crt,Dos;


procedure AddBslash(var path:string); { Use this with eg. GetDir(); }
begin
  if(Length(path)<>3)and(path[Length(path)]<>'\')then path:=path+'\';
end;


procedure DelBslash(var path:string); { Use this with eg. ChDir(); }
begin
  if(Length(path)<>3)and(path[Length(path)]='\')then Delete(path,Length(path),1);
end;


procedure UpperCase(var str:string);
var i:integer;
begin
  for i:=1 to Length(str) do str[i]:=Upcase(str[i]);
end;


function FileExists(cpath:string):boolean;
var tf:text;
begin
  {$I-}Close(tf);{$I+}If IOresult<>0 then cpath:=cpath; assign(tf,cpath);
  {$I-}reset(tf);{$I+}if IOresult<>0 then FILEEXISTS:=False else FILEEXISTS:=True;
  if cpath=''then FILEEXISTS:=False;
end;


function DirExists(path:string):boolean;
var Cd:string;
begin
  GetDir(0,Cd); DELBSLASH(path);
  {$I-}ChDir(path);{$I+}if IOresult<>0 then DIREXISTS:=False else DIREXISTS:=True;
  if path=''then DIREXISTS:=False;{} ChDir(Cd);
end;


procedure Fcopy(paramstr1,paramstr2:string; overw:integer; var error:integer);
var infile,outfile:file;
    S:PathStr; dir1,dir2:DirStr; nm1,nm2:NameStr; ext1,ext2:ExtStr;
    Cd,path1,path2:string;
    NumRead,NumWritten:word;
    Chs:array[0..62600] of char;
label 1;

begin
  S:=''; GetDir(0,Cd); error:=0;

  Fsplit(paramstr1,dir1,nm1,ext1);
  Fsplit(paramstr2,dir2,nm2,ext2);

  if dir1='' then begin dir1:=Cd;if Length(Cd)<>3 then dir1:=dir1+'\'; end;
  if dir2='' then begin dir2:=Cd;if Length(Cd)<>3 then dir2:=dir2+'\'; end;

  if nm2+ext2='' then begin nm2:=nm1;ext2:=ext1; end;
  path1:=dir1+nm1+ext1;
  path2:=dir2+nm2+ext2;

  UpperCase(path1);
  UpperCase(path2);

  if Length(dir2)<>3 then Delete(dir2,Length(dir2),1);

  assign(infile,paramstr1);
  {$I-}reset(infile,1);{$I+}if IOresult<>0 then begin error:=1;goto 1; end;

  if path1=path2 then begin error:=2;goto 1; end;

  {$I-}ChDir(dir2);{$I+}if Ioresult=0 then S:=FSearch(nm2+ext2,'');

  if(S<>'')and(S<>Cd) then begin error:=-1;if overw=0 then goto 1; end; 

  assign(outfile,path2);
  {$I-}rewrite(outfile,1);{$I+}if IOresult<>0 then begin error:=3;goto 1; end;

  repeat
    BlockRead(infile, Chs,SizeOf(Chs),NumRead);
    BlockWrite(outfile, Chs,NumRead, NumWritten);
  until (NumRead=0) or (NumWritten<>NumRead);

  if NumWritten<>NumRead then error:=-2; { Drive is full }
  close(infile);close(outfile);
1:
{$I-}ChDir(Cd);{$I+}
end;


procedure Fmove(paramstr1,paramstr2:string; overw:integer; var error:integer);
var f:text;
label 1;

begin
error:=0;
assign(f,paramstr2); {$I-}reset(f);{$I+}if IOresult=0 then
begin
  error:=-1;if overw=0 then goto 1;
  {$I-}erase(f);{$I+}error:=IOresult; if error<>0 then goto 1;
end; { File already exists }

assign(f,paramstr1);{$I-}rename(f,paramstr2);{$I+}error:=IOresult;
if error=17 then { -> Cannot rename across drives ! }
begin
  Fcopy(paramstr1,paramstr2,overw,error);
  if error<>0 then goto 1;
  assign(f,paramstr1);{$I-}erase(f);{$I+}
end;
1:end;


procedure Fdelete(paramstr1:string; real:integer; var error:integer);
var fl:file;

begin
error:=0;
assign(fl,paramstr1);{$I-}reset(fl);{$I+} error:=IOresult;
if real=1 then begin {$I-}rewrite(fl);{$I+} error:=IOresult; end;
{$I-}Close(fl);{$I+}  
{$I-}erase(fl);{$I+} error:=IOresult;
end;


procedure AboutFutils;
begin
textcolor(10);textbackground(0);clrscr;
writeln('       Ŀ     ');
writeln('         This UNIT has been created by Bartha Istvn  2000.3.27       ');
writeln('            ');
textcolor(15);delay(100);
writeln;
writeln(' Description: Standard File Operations (utilities);                     ');
writeln(' Usage: var paramstr1:string;        - first parameter (eg. path...)    ');
writeln('            paramstr2:string;        - second parameter (eg. path...)   ');
writeln('            overw:integer;           - overwrite switch: 0=OFF 1=ON     ');
writeln('            real :integer;           - real delete switch: 0=OFF 1=ON   ');
writeln('            error:integer;           - errorcode variable               ');
writeln('            path::string;            - a path variable                  ');
writeln;
writeln('            AddBslash(path);         - adds a backslash if needed       ');
writeln('            DelBslash(path);         - deletes the backslash if possible');
writeln('            UpperCase(str);          - transforms into uppercase        ');
writeln('            FileExists(cpath):boolean;     - True/False                 ');
writeln('            DirExists(path):boolean;       - True/False                 ');
writeln('            Fcopy(paramstr1,paramstr2,overw,error) - copy a file        ');
writeln('            Fmove(paramstr1,paramstr2,overw,error) - move a file        ');
writeln('            Fdelete(paramstr1,real,error) - delete a file               ');
readkey;{textcolor(7);clrscr;}
end;

end.
