{       Ŀ       }
{        This UNIT has been created by Bartha Istvn  2001.09.13         }
{              }
{ Description: Finds any file (that exists) on a specified drive;          }
{ Usage: var Spath,Fname,Fpath:string;      - the variables                }
{        Spath:='c:\...\...';               - the path to search in        }
{        Fname:='command.com';              - the file to search for       }
{        Find(Spath,Fname,Fpath);           - find the  file  and put it's }
{                                             path into the Fpath variable }
{ Note: If there is no file found then Fpath will be :     'notfound'      }

                           { THIS IS A UNIT ! }

UNIT Findit; {$S-}

INTERFACE
var FIND_finds_a_file___SearchPath_filename_FoundfilesPath:word;

procedure AboutFindit;
procedure Find(var Spath,Fname,Fpath:string);

IMPLEMENTATION
uses Crt,Dos;
var
 dirattr:set of 16..55;               { Directory attribute numbers }
 drec:SearchRec;                      { Directory search record }
 frec:SearchRec;                      { File search record }
 vd:array[0..200]of SearchRec;        { Directory search record array }
 path:string;                         { Searchpath variable }
 level:integer;                       { Directory-level counter }
 i:integer;                           { Other useful variables }


procedure GETSTARTPATH(var Spath:string);   { Gets the curr drive or spath }
begin
 if Spath='' then GetDir(0,Spath);   { If no path specified then current.. }

                                   { Make sure that the path ends with '\' }
 if Spath[Length(Spath)]<>'\' then Spath:=Spath+'\';

 for i:=1 to Length(Spath) do Spath[i]:=UpCase(Spath[i]); { Make it upcase }
end;


procedure CutLast(var dirpath:string);      { Cuts down the last directory }
var tmp:string;
    i1,i2,i3:byte;
begin
  tmp:=dirpath;
repeat
  i3:=i2;
  i2:=i1;
  i1:=Pos('\',tmp);
  tmp[Pos('\',tmp)]:='!';
until i1=0;
dirpath:=copy(dirpath,1,i3);
end;

procedure Find(var Spath,Fname,Fpath:string);
label 0,1;
begin
  GETSTARTPATH(Spath); path:=Spath; level:=-1;
  dirattr:=[16..23,48..55];
  { 16-23: 16,1,2,4 variations, 48-55: 16,1,2,4,32 variations }

repeat
{------------------ Searching for the specified FILE ------------------------}
  FindFirst(path + fname, 39 { hidden+readonly+sysfile+archive }, frec);
  if DosError=0 then
  begin
    Fpath:=path;goto 0;
  end;

{---------------------- Searching for directories ---------------------------}		 { DIRECTORY searching }
  FindFirst(path + '*',Directory,drec);
  while DosError=0 do
  begin
                                            { Checking whether it is a dir }
    if(drec.attr in dirattr)and(drec.name[1]<>'.')then
    begin
      level:=level+1;                    { Directory level (depth) counter }
      vd[level]:=drec;              { Putting directory record into vector }
      path:=path+drec.name+'\';
      goto 1;
    end else FindNext(drec);                     { Search for the next dir }
  end;

  repeat
    if level=-1 then Break;
    CUTLAST(path);                        { Cut the last dir from the path }
    drec:=vd[level];                          { Remember last recorded dir }
    FindNext(drec);                                    { Find the next dir }
    if doserror=0 then                          { If found then go into it }
    begin
      path:=path+drec.name+'\';
      vd[level]:=drec;
      goto 1;
    end;
    level:=level-1;                     { If notfound then step back a dir }
  until level=-1;
1:
until level=-1;                      { Until there's no place to step back }
Fpath:='notfound';         { If there isn't any dir in startpath then exit }
0:end;


procedure AboutFindit;
begin
textcolor(10);textbackground(0);clrscr;
writeln('        Ŀ      ');
writeln('         This UNIT has been created by Bartha Istvn  2001.09.13        ');
writeln('              ');
textcolor(15);delay(100);
writeln;
writeln(' Description: Finds any file (that exists) on a specified drive;          ');
writeln;
writeln(' Usage: var Spath,Fname,Fpath:string;      - the variables                ');
writeln('        Spath:=''c:\...\...'';               - the path to search in        ');
writeln('        Fname:=''command.com'';              - the file to search for       ');
writeln('        Find(Spath,Fname,Fpath);           - find the  file  and put it''s');
writeln('                                             path into the Fpath variable ');
writeln;
writeln(' Note: If there is no file found then Fpath will be :     ''notfound''    ');
readkey;{textcolor(7);clrscr;}
end;

end.


