{       Ŀ      }
{        This UNIT has been created by Bartha Istvn  2000.09.02,08       }
{             }
{ Description: displays a complete error-message if an error occures;       }
{                                                                           }
{ Usage: var ErrorNr,GrErrorNr,Graphresult:integer;  - the variables        }
{        GrErrorNr:=Graphresult;                 - setup the error-codes    }
{        ErrorNr:=ExitCode;                                                 }
{        ErrorMsg(ExitCode,Graphresult):string;      - the error-message    }
{                                    U may use it only with Exitproc ...    }
{        DisplayErrorMsg(ErrorNr,GrErrorNr:integer); - shows a nice window  }
{        Setexit;            - setting up a complete exiting procedure      }
{        Stexit;             - same as above but without clrscr;            }
{                                                                           }
{ Note: If want to use the built in exit command along with this unit, then }
{       you should use it in the following way: System.Exit;                }


UNIT Exit;                 { THIS IS A UNIT ! }
{$V-,D-}

INTERFACE
var ErrorNr,GrErrorNr,Graphresult: integer;

procedure AboutExit;
function ErrorMsg(ErrorNr,Grerrornr:integer):string;
procedure DisplayErrorMsg(ErrorNr,GrErrornr:integer);
procedure SetExit;
procedure StExit;

IMPLEMENTATION         { Modified in 2002.06.08 (WIN was added, etc.) }
uses Dos,Crt,Graph;
var exitsave :pointer; nc :integer;


procedure WIN(x1,y1,x2,y2:integer);
var x,y:integer; win:string[6];
begin
win:='ɻȼͺ';

for x:=x1 to x2 do for y:=y1 to y2 do begin gotoxy(x,y);write(' ');end;

gotoxy(x1,y1);write(win[1]);gotoxy(x2,y1);write(win[2]);
gotoxy(x1,y2);write(win[3]);gotoxy(x2,y2);write(win[4]);

for x:=x1+1 to x2-1 do
begin gotoxy(x,y1);write(win[5]); gotoxy(x,y2);write(win[5]); end;

for y:=y1+1 to y2-1 do
begin gotoxy(x1,y);write(win[6]); gotoxy(x2,y);write(win[6]); end;
end;


function ErrorMsg(ErrorNr,Grerrornr:integer):string;
var m : string;
begin
m:='';
 case errornr of
 1: m:='Invalid function number';
 2: m:='File not found';
 3: m:='Path not found';
 4: m:='Too many open files';
 5: m:='File access denied';
 6: m:='Invalid file handle';
 12: m:='Invalid file access code';
 15: m:='Invalid drive number';
 16: m:='Cannot remove current directory';
 17: m:='Cannot rename across drives';
 18: m:='No more files';
 100: m:='Disk read error';
 101: m:='Disk write error';
 102: m:='File not assigned';
 103: m:='File not open';
 104: m:='File not open for input';
 105: m:='File not open for output';
 106: m:='Invalid numeric format';
 150: m:='Disk is write-protected';
 151: m:='Bad drive request struct length';
 152: m:='Drive not ready';
 154: m:='CRC error in data';
 156: m:='Disk seek error';
 157: m:='Unknown media type';
 158: m:='Sector Not Found';
 159: m:='Printer out of paper';
 160: m:='Device write fault';
 161: m:='Device read fault';
 162: m:='Hardware failure';
 200: m:='Division by zero';
 201: m:='Range check error';
 202: m:='Stack overflow error';
 203: m:='Heap overflow error';
 204: m:='Invalid pointer operation';
 205: m:='Floating point overflow';
 206: m:='Floating point underflow';
 207: m:='Invalid floating point operation';
 208: m:='Overlay manager not installed';
 209: m:='Overlay file read error';
 210: m:='Object not initialized';
 211: m:='Call to abstract method';
 212: m:='Stream registration error';
 213: m:='Collection index out of range';
 214: m:='Collection overflow error';
 215: m:='Arithmetic overflow error';
 216: m:='General Protection fault';end;
if Grerrornr<>0 then
 begin
 case Grerrornr of
 1: m:='BGI graphics not installed';
 2: m:='Graphics hardware not detected';
 3: m:='Device driver file not found';
 4: m:='Invalid device driver file';
 5: m:='Not enough memory to load driver';
 6: m:='Out of memory in scan fill';
 7: m:='Out of memory in flood fill';
 8: m:='Font file not found';
 9: m:='Not enough memory to load font';
 10: m:='Invalid graphics mode for selected driver';
 11: m:='Graphics error (generic error)';
 12: m:='Graphics I/O error';
 13: m:='Invalid font file';
 14: m:='Invalid font number';end;
 end;
if Errornr=255 then m:='Control-Break was pressed';
ErrorMsg:=m;
end;


procedure DisplayErrorMsg(ErrorNr,GrErrornr:integer);
begin
  textbackground(4); textcolor(15);
  WIN(18,10,62,13);
  if ErrorNr<100 then gotoxy(36,11) else gotoxy(35,11);
  write('Error(',ErrorNr,'):');
  gotoxy((81-Length( ErrorMsg(ErrorNr,GrErrornr) )) div 2,12);
  write(ErrorMsg(ErrorNr,GrErrornr));
end;


{$F+}
function exiting:string;
var  regs : registers;
begin
  Closegraph;                                      { closing graphic mode }
  textbackground(0);textcolor(7);if nc<>1 then clrscr;
  if (Exitcode<>0)or(Graphresult<>0)then
  begin if nc=1 then clrscr;
    DisplayErrorMsg(Exitcode,Graphresult);readkey;
  end;
  begin with regs do begin AX:=0;intr(51,regs);end;end; { reset the mouse }
  Exitproc:=Exitsave;HALT;        { reset variables and terminate program }
end;
{$F-}


procedure SetExit;
begin
  Exitsave:=Exitproc;
  Exitproc:=@exiting;
end;


procedure StExit;
begin
  Exitsave:=Exitproc;
  Exitproc:=@exiting;nc:=1;
end;


procedure AboutExit;
begin
textcolor(10);textbackground(0);clrscr;
writeln('        Ŀ    ');
writeln('         This UNIT has been created by Bartha Istvn  2000.09.02,08     ');
writeln('            ');
textcolor(15);delay(100);
writeln;
writeln(' Description: displays a complete error-message if an error occures; ');
writeln;
writeln(' Usage: var ErrorNr,GrErrorNr,Graphresult:integer;  - the variables       ');
writeln('        GrErrorNr:=Graphresult;                 - setup the error-codes   ');
writeln('        ErrorNr:=ExitCode;                                                ');
writeln('        ErrorMsg(ExitCode,Graphresult):string;      - the error-message   ');
writeln('                                    U may use it only with Exitproc ...   ');
writeln('        DisplayErrorMsg(ErrorNr,GrErrorNr:integer); - shows a nice window ');
writeln('        Setexit;            - setting up a complete exiting procedure     ');
writeln('        Stexit;             - same as above but without clrscr;           ');
readkey;{textcolor(7);clrscr;}
end;

end.
