{       Ŀ       }
{        This UNIT has been created by Bartha Istvn  2001.09.06         }
{              }
{ Description: Makes the mouse available in Text or Graphic mode;          }
{ Usage: var x,y,b:integer;                - the variables                 }
{        Textmode:integer;                 - set to 1 for textmode coords. }
{        Mousemotion:integer;              - turns to 1 if mouse has moved }
{                                                                          }
{        Resetm;                           - reset the mouse               }
{        Show_mouse;                       - show the mousecursor          }
{        Hide_mouse;                       - hide the mousecursor          }
{        Setshape(bc,fc,ac);               - set mouse color & ascii chr.  }
{        Getmc(x,y,b);                     - get current mouse coordinates }
{                                            and buttonstatus              }
{        Setmc(x,y);                       - set mouse coordinates         }
{        Setxr(xl,xr);                     - set mouse x range             }
{        Setyr(yu,yd);                     - set mouse y range             }
{                                                                          }
{ Where: x = X coordinate; y = Y coordinate; b = pressed button nr. (0-3)  }

                            { THIS IS A UNIT ! }

UNIT Bmouse; {$S-}

INTERFACE
var RESETM_Resets_the_mousecursor:word;
var SHOW_MOUSE_Shows_the_mousecursor:word;
var HIDE_MOUSE_Hides_the_mousecursor:word;
var SETSHAPE_Sets_the_mouse_color_and_ascii_chr:word;
var GETMC_Gets_the_mouse_coordinates_x_y_and_buttonstatus_b:word;
var SETMC_Sets_the_mouse_coordinates_x_y:word;
var SETXR_Sets_the_x_range:word;
var SETYR_Sets_the_y_range:word;
var Textmouse:integer;
var Mousemotion:integer;
var Xsaved,Ysaved:integer;

procedure AboutBmouse;
procedure Resetm;
procedure Show_mouse;
procedure Hide_mouse;
procedure Setshape( bc,fc,ac : integer);
procedure Getmc(var x,y,b : integer);
procedure Setmc( x,y : integer);
procedure Setxr( xl,xr : integer);
procedure Setyr( yu,yd : integer);

IMPLEMENTATION
uses Crt;

procedure Resetm;
begin
  asm
  mov ax,00h
  int 33h
  end
end;

procedure Show_mouse;
begin
  asm
  mov ax,01h
  int 33h
  end;
end;

procedure Hide_mouse;
begin
  asm
  mov ax,02h
  int 33h
  end;
end;

procedure Setshape( bc,fc,ac : integer);
var b,f,a:byte;
begin
  b:=bc*16;f:=fc;a:=ac;
  asm
  mov bx,00h
  mov ax,0Ah
  mov cx,00h
  mov dh,[b]
  add dh,[f]
  mov dl,[a]
  int 33h
  end;
end;

procedure Getmc(var x,y,b : integer);
var x1,y1,b1:word;
begin
  asm
  mov ax,03h
  int 33h
  mov [x1],cx
  mov [y1],dx
  mov [b1],bx
  end;

  if Textmouse=1 then begin x:=(x1 div 8)+1; y:=(y1 div 8)+1; end
                 else begin x:=x1;           y:=y1;           end; b:=b1;
  Mousemotion:=0;
  if(Xsaved<>0)and((Xsaved<>x)or(Ysaved<>y))then Mousemotion:=1;
  Xsaved:=x; Ysaved:=y;

end;

procedure Setmc( x,y : integer);
begin
  if Textmouse=1 then begin x:=(x-1)*8; y:=(y-1)*8; end;
  asm
  mov ax,04h
  mov cx,[x]
  mov dx,[y]
  int 33h
  end;
end;

procedure Setxr( xl,xr : integer);
begin
  if Textmouse=1 then begin xl:=(xl-1)*8; xr:=(xr-1)*8; end;
  asm
  mov ax,07h
  mov cx,[xl]
  mov dx,[xr]
  int 33h
  end
end;

procedure Setyr( yu,yd : integer);
begin
  if Textmouse=1 then begin yu:=(yu-1)*8; yd:=(yd-1)*8; end;
  asm
  mov ax,08h
  mov cx,[yu]
  mov dx,[yd]
  int 33h
  end;
end;


procedure AboutBmouse;
begin
textcolor(10);textbackground(0);clrscr;
writeln('        Ŀ         ');
writeln('         This UNIT was created by Bartha Istvn  2001.09.06           ');
writeln('                 ');
textcolor(15);delay(100);
writeln;
writeln(' Description: Makes the mouse available in Text or Graphic mode;         ');
writeln;
writeln(' Usage: var x,y,b:integer;                - the variables                ');
writeln('        Textmode:integer;                 - set to 1 for textmode coords.');
writeln('        Mousemotion:integer;              - turns to 1 if mouse has moved');
writeln;
writeln('        Resetm;                           - reset the mouse              ');
writeln('        Show_mouse;                       - show the mousecursor         ');
writeln('        Hide_mouse;                       - hide the mousecursor         ');
writeln('        Setshape(bc,fc,ac);               - set mouse color & ascii chr. ');
writeln('        Getmc(x,y,b);                     - get current mouse coordinates');
writeln('                                            and buttonstatus             ');
writeln('        Setmc(x,y);                       - set mouse coordinates        ');
writeln('        Setxr(xl,xr);                     - set mouse x range            ');
writeln('        Setyr(yu,yd);                     - set mouse y range            ');
writeln;
writeln(' Where: x = X coordinate; y = Y coordinate; b = pressed button nr. (0-3) ');
readkey;{textcolor(7);clrscr;}
end;

end.

{ FINALLY !  Show_mouse, Hide_mouse and Setmc(x,y) procedures were added
             to the unit by  rewriting  some assambler procs from the
             freepascal MOUSE.PPU on 2001.08.31
             Every procedure was rewritten in assambler and Setxr, Setyr,
             Setshape procedures were added to the unit on 2001.09.06     }

                         Faster,Smoother,Smaller !





{      Here comes the old version of BMOUSE (compatible with tp5.5):

UNIT Bmouse;

INTERFACE

procedure Resetm;
procedure Show_mouse;
procedure Hide_mouse;
procedure Getmc(var x,y,b : integer);
procedure Setmc(var x,y : integer);


IMPLEMENTATION
uses Dos;
var  regs : registers;

procedure Resetm;
begin
  regs.AX:=0;
  intr(51,regs);
end;

procedure Show_mouse;
begin
  regs.AX:=1;
  intr(51,regs);
end;

procedure Hide_mouse;
begin
  regs.AX:=2;
  intr(51,regs);
end;

procedure Getmc(var x,y,b : integer);
begin
  regs.AX:=3;
  intr(51,regs);
  x:=regs.CX;
  y:=regs.DX;
  b:=regs.BX;
end;

procedure Setmc(var x,y : integer);
begin
  regs.AX:=4;
  regs.CX:=x;
  regs.DX:=y;
  intr(51,regs);
end;

end. { END OF OLD VERSION: 2000.09.04 }
