{       Ŀ       }
{        This UNIT has been created by Bartha Istvn  2001.12.27         }
{              }
{ Description: Contains very fast & useful Crt routines;                  }
{ Usage: var x,y:integer;                  - the variables                 }
{             ch:char;                                                     }
{             st:string;                                                   }
{                                                                          }
{        Putch(x,y,ch);                    - write a character to x,y      }
{        Putchar(x,y,ch,bc,tc);            - write a character to x,y      }
{                                            with the colors bc and tc     }
{        Writexy(x,y,st);                  - write a string to x,y         }
{                                                                          }
{ Note: Parts of this unit were taken from William C. Thompson's Xcrt unit }

                            { THIS IS A UNIT ! }

UNIT Bcrt; {$S-}

INTERFACE
procedure PUTCH(x,y:integer; ch:char);
{ Places a character on the x,y coordinates of a 25/80 mode screen.
  It is 9 times faster than TP's Crt (fastest if stackchk is off). }
procedure PUTCHAR(x,y:integer; ch:char; bc,tc{at}:byte);
procedure WRITEXY(x,y:integer; st:string);
function  GETCH:char;
procedure SHOWCURSOR;
procedure HIDECURSOR;
procedure FLUSHKEY;
procedure CREATEWINDOW( x1,y1,x2,y2,ty :integer);
procedure SHADEWINDOW( x1,y1,x2,y2,col :integer);
procedure SAVEWINDOW( snr,x1,y1,x2,y2 :integer);
procedure RESTOREWINDOW( snr,x1,y1 :integer);
procedure RESTOREWINDOWS( snr1,x1,y1, snr2,x2,y2 :integer);

IMPLEMENTATION
uses Crt;

const maxs=4;

type
  screen = array[1..25,1..80] of record
                                   ch:char;
                                   at:byte;
                                end;
  screenptr = ^screen;

var  active:screenptr;
     act:screen;
     saved:array[1..maxs] of screen;
     windata:array[1..maxs,1..4] of byte;
     r,c,row,col:byte;


procedure PUTCH(x,y:integer; ch:char);
var offset:integer;
begin
  offset:=2*(x-1)+160*(y-1);
  Mem[$B800:offset]:=Ord(ch);
  Mem[$B800:offset+1]:=textattr;
end;


procedure PUTCHAR(x,y:integer; ch:char; bc,tc{at}:byte);
var offset:integer;
begin
  offset:=2*(x-1)+160*(y-1);
  Mem[$B800:offset]:=Ord(ch);
  Mem[$B800:offset+1]:=bc*16+tc{at};
end;


procedure WRITEXY(x,y:integer; st:string);
var  i:integer;
begin
  for i:=1 to length(st) do PUTCH(x+i-1,y,st[i])
end;


function GETCH:char; { Extended Readkey function }
{ What it does: This function correctly reads in a keypress and returns the
  correct value for special keys like F1,<-,Home,etc.
  Why: If you press an ordinary key (eg. the semicolon, its keyvalue is 59)
  then the Readkey function returns immediately #keyvalue (#59), but if you
  press a special key (like F1 which also has the value of 59) then Readkey
  returns #0 and only after that (after you assigned it) will it receive the
  #keyvalue (in this case #59).
  Try it:       key:=readkey;writeln(Ord(key));writeln(Ord(readkey));       }

var ch: char;
begin
  ch:=readkey;
  if ch=#0 then                        { If a special character was pressed }
  begin
    ch:=readkey;       { ch receives the #keyvalue of the special character }

    case Ord(ch) of                                  { Giving unique values }
      59..68: getch:=Chr(Ord(ch)+147); { F1-F10 }          { 206..215 }
      75:     getch:=#201;             { <- }
      77:     getch:=#202;             { -> }
      72:     getch:=#200;             { /\ }
      80:     getch:=#203;             { \/ }
      82:     getch:=#194;             { INSERT }
      83:     getch:=#197;             { DELETE }
      71:     getch:=#195;             { HOME }
      79:     getch:=#198;             { END }
      73:     getch:=#196;             { PAGE UP }
      81:     getch:=#199;             { PAGE DOWN }

      115:    getch:=#204;             { CTRL + <- }
      116:    getch:=#205;             { CTRL + -> }
      132:    getch:=#228;             { CTRL + PAGE UP }
      118:    getch:=#230;             { CTRL + PAGE DOWN }
      45:     getch:=#191;             { ALT+X }
    end;
  end else getch:=ch;                       { If a standard key was pressed }
end;


procedure SHOWCURSOR;
begin
  asm
  mov ah,01h
  mov ch,06h
  mov cl,07h
  int 10h
  end
end;


procedure HIDECURSOR;
begin
  asm
  mov ah,01h
  mov ch,01h
  mov cl,00h
  int 10h
  end
end;


procedure FLUSHKEY;
begin
  asm
  mov ax,0C00h
  int 21h
  end
end;


procedure CREATEWINDOW(x1,y1,x2,y2,ty:integer);
var x,y:integer; win:array[1..6]of string[6];
begin
win[1]:='ɻȼͺ';
win[2]:='ڿĳ';
win[3]:='ַӽĺ';
win[4]:='ոԾͳ';
win[5]:='';
win[6]:='      ';

for x:=x1 to x2 do for y:=y1 to y2 do PUTCH(x,y,' ');

PUTCH(x1,y1,win[ty,1]);
PUTCH(x2,y1,win[ty,2]);
PUTCH(x1,y2,win[ty,3]);
PUTCH(x2,y2,win[ty,4]);

for x:=x1+1 to x2-1 do
begin
  PUTCH(x,y1,win[ty,5]);
  if ty<>5 then PUTCH(x,y2,win[ty,5]) else PUTCH(x,y2,'');
end;

for y:=y1+1 to y2-1 do
begin PUTCH(x1,y,win[ty,6]); PUTCH(x2,y,win[ty,6]); end;
end;


procedure SHADEWINDOW(x1,y1,x2,y2,col:integer);
var offset,x,y:integer;

function shattr(attr:byte):byte;
var sh:byte;
begin
  sh:=attr and $07;
  if(sh=0)or(sh=7)then shattr:=8 else shattr:=sh;
  if col<>-1 then shattr:=col*16+col;
end;

begin
x1:=x1+2;inc(x2);inc(y1);inc(y2); if(x1>80)or(y1>25)then exit;

if x1<1 then x:=1 else x:=x1;
repeat
  offset:=2*(x-1)+160*(y2-1);
  if y2<26 then Mem[$B800:offset+1]:=shattr(Mem[$B800:offset+1]); inc(x);
until(x=x2+1)or(x=81);

y:=y1;
repeat
  offset:=2*(x2-1)+160*(y-1);
  if x2<81 then Mem[$B800:offset+1]:=shattr(Mem[$B800:offset+1]);{}
  if x2<80 then Mem[$B800:offset+3]:=shattr(Mem[$B800:offset+1]); inc(y);
until(y=y2+1)or(y=26);
end;


procedure SAVEWINDOW( snr,x1,y1,x2,y2 :integer);
begin
if(snr>maxs)or(x1<1)or(y1<1)or(x2<1)or(y2<1)or(x1>=x2)or(y1>=y2)then exit;

windata[snr,1]:=x1;windata[snr,2]:=y1;windata[snr,3]:=x2;windata[snr,4]:=y2;
active:=ptr($B800,0);    { Assigning a pointer to the screen (video segment) }

for r:=y1 to y2 do
begin
  for c:=x1 to x2 do saved[snr,r,c]:=active^[r,c]; { Save the pointer to mem }
end;
end;


procedure RESTOREWINDOW( snr,x1,y1 :integer);
begin
if(snr>maxs)or(y1<1)then exit;
r:=windata[snr,2];row:=y1;
repeat
  if x1<1 then begin c:=windata[snr,1]-x1+1; col:=1;end
          else begin c:=windata[snr,1];     col:=x1;end;
  repeat
    active^[row,col]:=saved[snr,r,c];{ Writing from mem. to pointer (screen) }
    inc(c);inc(col);
  until(c=windata[snr,3]+1)or(col=81);
  inc(r);inc(row);
until(r=windata[snr,4]+1)or(row=26);
end;


procedure RESTOREWINDOWS( snr1,x1,y1, snr2,x2,y2 :integer);
begin
{if(snr1>maxs)or(snr2>maxs)or(x1<1)or(y1<1)or(y2<1)then exit; { Error chk.}
active:=ptr($B800,0); { Assigning a pointer to the screen (video segment) }

Move(active^,act,Sizeof(act));     { Move the data from pointer to memory }

r:=windata[snr1,2];row:=y1;  { Loop for inserting the first screen-window }
repeat
  c:=windata[snr1,1];col:=x1;
  repeat
    act[row,col]:=saved[snr1,r,c];
    inc(c);inc(col);
  until(c=windata[snr1,3]+1)or(col=81);
  inc(r);inc(row);
until(r=windata[snr1,4]+1)or(row=26);

r:=windata[snr2,2];row:=y2; { Loop for inserting the second screen-window }
repeat
  if x2<1 then begin c:=windata[snr2,1]-x2+1; col:=1;end
          else begin c:=windata[snr2,1];     col:=x2;end;
  repeat
    act[row,col]:=saved[snr2,r,c];
    inc(c);inc(col);
  until(c=windata[snr2,3]+1)or(col=81);
  inc(r);inc(row);
until(r=windata[snr2,4]+1)or(row=26);

Move(act,active^,Sizeof(act));  { Move the data from memory to pointer }
end;


end.
