{ BINTTST.PAS : Test BINTPR.PAS  --  Turbo Pascal v4.0 and up
  J R Ferguson, May 21, 1991
}

program binttst(output,data);

const
  datafile  = 'BINTTST.DAT';

type
  datatype  = string[10];
  ptnode    = ^node;
  node      = record
                elem : datatype;
                l,r  : ptnode
              end;

var
  data      : text;


procedure printelem(var elem: datatype);
  begin
    write(elem);
  end;


{$I BINTPR.PAS}

procedure create(var root: ptnode);
  begin
    root:= nil
  end;

procedure insert(var ptr: ptnode; element: datatype);
  begin
    if ptr=nil then begin
      new(ptr);
      with ptr^ do begin
        elem:= element;
        l:= nil;
        r:= nil
      end
    end
    else if element < ptr^.elem
      then insert(ptr^.l,element)
      else insert(ptr^.r,element)
  end;

procedure buildtree(var root: ptnode);
  var element: datatype;
  begin
    assign(data,datafile); reset(data);
    while not eof(data) do begin
      readln(data,element);
      insert(root,element)
    end;
    close(data)
  end;

procedure clear(var ptr: ptnode);
  begin
    if ptr<>nil then begin
      clear(ptr^.l);
      clear(ptr^.r);
      dispose(ptr)
    end
  end;

procedure main;
  var tree : ptnode;
  begin
    create(tree);
    buildtree(tree);
    bintreeprint(tree);
 {  writeln; write('CR:'); readln;  }
    clear(tree);
  end;

begin main end.
