;
; maxMUSIC music interface for mpu-401 compatible cards (works with sbawe32
; and gus general midi emulation too), size: 272b
; thanks go to bob mcqueer, jeff mallory, greg lee, jamal hannah and
; jcab/vangelisteam for their documentations
; (c) 1997 by florian haller/austrian emerging illegal operations underground
; started 19970511.1745.GRAZ.AT
; finished 19970629.2111.GRAZ.AT

;
; definitions

  MPU_dataport            EQU 0330h
  MPU_statusport          EQU 0331h
  MPU_writebyte           EQU 40h
  MPU_readbyte            EQU 80h

;
; variable data

  HANDLER_oldtimer        DW ?
  HANDLER_oldtimerseg     DW ?
  MUSIC_segment           DW ?
  MUSIC_offset            DW ?
  MUSIC_position          DW ?
  MUSIC_counter           DB ?

;
; functions

;----------------------------------------------------------------------------
; proc MPU_wait: waits for the mpu-401 interface to send/read byte
; INPUT: bl - mode (see above); MODIFIES: dx

  MPU_wait                proc near
    push     ax                         ; save byte
    sub      ax, ax
    mov      dx, MPU_statusport
    MPU_wait_loop:                      ; wait for mpu
    dec      ah
    jz       MPU_wait_error
    in       al, dx
    and      al, bl
    jnz      MPU_wait_loop
    pop      ax
    dec      dx
    ret
    MPU_wait_error:
    pop      ax
    mov      byte ptr cs: [MUSIC_play_counter], 0ebh  ; 0ebh = jmp
    ret
  endp                    MPU_wait

;----------------------------------------------------------------------------
; proc MPU_reset: resets the mpu-401 chip
; MODIFIES: al, bl, dx

  MPU_reset               proc near
    mov      dx, MPU_statusport
    mov      al, 0ffh
    out      dx, al
    mov      bl, MPU_readbyte
    call     MPU_wait
    in       al, dx
    inc      dx
    mov      al, 3fh
    out      dx, al
    call     MPU_wait
    in       al, dx
    mov      bl, MPU_writebyte
    call     MPU_wait
    mov      al, 0ffh
    out      dx, al
    ret
  endp                    MPU_reset

;----------------------------------------------------------------------------
; proc MUSIC_start: starts playing a song through general midi
; INPUT: ds:si - address of song; MODIFIES: ax, bl, cx, dx, ds

  MUSIC_start             proc near
    mov      ax, ds                     ; initialize variables
    mov      cs: MUSIC_segment, ax
    mov      cl, 0
    MUSIC_start_loop:                   ; set instruments
    mov      al, cl
    mov      bl, MPU_writebyte
    call     MPU_wait
    add      al, 0c0h
    out      dx, al
    inc      cl
    lodsb
    shr      al, 1
    pushf
    call     MPU_wait
    out      dx, al
    popf
    jnc      MUSIC_start_loop
    push     cs
    pop      ds
    mov      ax, 351ch                  ; save old timer handler
    int      21h
    mov      HANDLER_oldtimer, bx
    mov      HANDLER_oldtimerseg, es
    lea      dx, MUSIC_play
    mov      ah, 25h                    ; set new timer handler
    int      21h
    mov      MUSIC_offset, si
    mov      MUSIC_position, si
    mov      MUSIC_counter, 1
    ret
  endp                    MUSIC_start

;----------------------------------------------------------------------------
; proc MUSIC_play: processes a general midi song

  MUSIC_play              proc far
    pusha
    push     ds
    dec      cs: MUSIC_counter          ; check counter
  MUSIC_play_counter:
    jnz      MUSIC_play_return
    mov      ax, cs: MUSIC_segment
    mov      ds, ax
    mov      si, cs: MUSIC_position     ; move to song data
    lodsb
    shr      al, 1
    mov      cs: MUSIC_counter, al
    mov      bl, MPU_writebyte
    jc       MUSIC_play_note            ; set, play notes
    cmp      al, 0                      ; absolute end reached?
    jne      MUSIC_play_end             ; no, leave player
    mov      si, cs: MUSIC_offset       ; yes, move to song begin
    mov      cs: MUSIC_counter, 1
    jmp      MUSIC_play_end             ; ... and escape
    MUSIC_play_note:
    lodsb
    mov      cl, al
    shr      al, 4
    and      cl, 15
    shl      cl, 3
    add      al, 90h
    call     MPU_wait
    out      dx, al
    lodsb
    shr      al, 1                      ; set note
    pushf
    call     MPU_wait
    out      dx, al
    mov      al, cl
    call     MPU_wait
    out      dx, al
    popf
    jnc      MUSIC_play_note
    MUSIC_play_end:
    mov      cs: MUSIC_position, si
    MUSIC_play_return:
ifdef TIMER_user
    jmp      TIMER_user
    MUSIC_play_userjmp:
endif
    mov      al, 20h
    out      20h, al
    pop      ds
    popa
    iret
  endp                    MUSIC_play

;----------------------------------------------------------------------------
; proc MUSIC_stop: stops playing a midi song
; MODIFIES: ax, bl, cx, dx, ds

  MUSIC_stop              proc near
    push     cs
    pop      ds
    mov      dx, HANDLER_oldtimer
    mov      ax, HANDLER_oldtimerseg
    mov      ds, ax
    mov      ax, 251ch                  ; restore old timer handler
    int      21h
    mov      bl, MPU_writebyte
    mov      cx, 16
    MUSIC_stop_loop:
    call     MPU_wait
    mov      al, cl
    add      al, 0afh
    out      dx, al
    call     MPU_wait
    mov      al, 123
    out      dx, al
    call     MPU_wait
    mov      al, 0
    out      dx, al
    loop     MUSIC_stop_loop
    ret
  endp                    MUSIC_stop

; EOF