;
; maxMEM memory interface for real mode, allocates biggest xms extended
; memory block available, xms 3+ required, size: 265b (macros not included)
; (c) 1997 by florian haller/austrian emerging illegal operations underground
; started 19970628.1043.GRAZ.AT
; finished 19970723.1957.GRAZ.AT

;
; definitions

  XMS_movestruc           struc
    datalength              DD ?
    sourcehandle            DW ?
    sourceoffsetlo          DW ?
    sourceoffset            DW ?
    desthandle              DW ?
    destoffsetlo            DW ?
    destoffset              DW ?
  XMS_movestruc           ends

;
; variable data

  XMS_control             DW ?
  XMS_controlseg          DW ?
  XMS_handle              DW ?
  XMS_move                XMS_movestruc <65536, ?, 0, ?, ?, 0, ?>
  FRAME_selected          DW ?
  FRAME_segment           DW ?

;
; functions

;----------------------------------------------------------------------------
; proc MEM_init: initializes and allocates memory
; INPUT: es - psp segment; MODIFIES: bx, dx, ds, es
; OUTPUT: cf - set if error, ax - memory size (kb), fs - FRAME_segment

  MEM_init                proc near
    push     cs
    pop      ds
    mov      ax, ss                     ; resize psp memory
    mov      bx, sp
    shr      bx, 4
    inc      bx
    add      bx, ax
    mov      ax, es
    sub      bx, ax
    mov      ah, 4ah
    int      21h
    mov      ax, 4300h                  ; check for driver
    int      2fh
    cmp      al, 80h
    jne      MEM_init_error
    mov      ax, 4310h                  ; get xms control
    int      2fh
    mov      XMS_controlseg, es
    mov      XMS_control, bx
    mov      ah, 0                      ; get xms version
    call     dword ptr [XMS_control]
    cmp      ah, 3
    jb       MEM_init_error
    mov      ah, 8                      ; query free memory
    call     dword ptr [XMS_control]
    and      bl, 80h
    jnz      MEM_init_error
    push     ax                         ; save amount of memory
    mov      dx, ax
    mov      ah, 9                      ; allocate extended memory
    call     dword ptr [XMS_control]
    cmp      al, 1
    jne      MEM_init_error
    mov      XMS_handle, dx
    mov      bx, 1000h
    mov      ah, 48h                    ; allocate frame (64k)
    int      21h
    jc       MEM_init_doserror
    mov      fs, ax
    mov      FRAME_segment, ax
    call     FRAME_adjust_reset
    pop      ax                         ; restore extended memory block size
    clc
    ret
    MEM_init_error:
    stc
    ret
    MEM_init_doserror:
    pop      ax
    stc
    mov      ah, 0ah
    mov      dx, XMS_handle
    call     dword ptr [XMS_control]
    ret
  endp                    MEM_init

;----------------------------------------------------------------------------
; proc FRAME_adjust: adjusts the dos frame to access xms memory
; INPUT: si - new page

  FRAME_adjust            proc near
    push     ax bx ds si si
    FRAME_adjust_store:
    mov      ax, cs
    mov      ds, ax
    mov      XMS_move.sourcehandle, 0
    mov      ax, FRAME_segment
    mov      XMS_move.sourceoffset, ax
    mov      ax, XMS_handle
    mov      XMS_move.desthandle, ax
    mov      ax, FRAME_selected
    mov      XMS_move.destoffset, ax
    mov      si, offset XMS_move
    mov      ah, 0bh
    call     dword ptr [XMS_control]
    FRAME_adjust_reload:
    mov      ax, XMS_handle
    mov      XMS_move.sourcehandle, ax
    pop      si
    mov      XMS_move.sourceoffset, si
    mov      FRAME_selected, si
    mov      XMS_move.desthandle, 0
    mov      ax, FRAME_segment
    mov      XMS_move.destoffset, ax
    mov      si, offset XMS_move
    mov      ah, 0bh
    call     dword ptr [XMS_control]
    pop      si ds bx ax
    retn
    FRAME_adjust_di:
    push     ax bx ds si
    mov      si, di
    push     si
    jmp      FRAME_adjust_store
  FRAME_adjust_reset:
    push     ax bx ds si 0
    jmp      FRAME_adjust_reload
  endp                    FRAME_adjust

;----------------------------------------------------------------------------
; proc MEM_exit: frees allocated memory
; MODIFIES: ax, dx, es

  MEM_exit                proc near
    push     cs: FRAME_segment
    pop      es
    mov      ah, 49h
    int      21h
    mov      ah, 0ah
    mov      dx, cs: XMS_handle
    call     dword ptr cs: [XMS_control]
    ret
  endp                    MEM_exit

;
; macros

;----------------------------------------------------------------------------
; macro xlodsb: works like lodsb but accesses only xms memory
; INPUT: esi - address (not adjusted), fs - MUST be FRAME_segment
; OUTPUT: al - byte

  xlodsb                  macro
  local xlodsb_load
    push     esi
    push     offset xlodsb_load
    shr      esi, 16
    cmp      si, cs: FRAME_selected
    jne      FRAME_adjust
    add      sp, 2
    xlodsb_load:
    pop      esi
    mov      al, fs: [si]
  endm                    xlodsb

;----------------------------------------------------------------------------
; macro xstosb: works like stosb but accesses only xms memory
; INPUT: edi - address (not modified), al - byte, fs - MUST be FRAME_segment

  xstosb                  macro
  local xstosb_store
    push     edi
    push     offset xstosb_store
    shr      edi, 16
    cmp      di, cs: FRAME_selected
    jne      FRAME_adjust_di
    add      sp, 2
    xstosb_store:
    pop      edi
    mov      fs: [di], al
  endm                    xstosb

; EOF