;
; maxGRAPH graphic interface for vesa (compatible) cards, size: 98b (macros
; not included)
; thanks go to georg stark/yakuza for inspiration
; (c) 1997 by florian haller/austrian emerging illegal operations underground
; started 19970702.1050.GRAZ.AT
; finished 19970723.1934.GRAZ.AT

;
; definitions

  VESA_640x400x256        EQU 100h
  VESA_640x480x256        EQU 101h
  VESA_800x600x256        EQU 103h
  VESA_1024x768x256       EQU 105h

;
; variable data

  VESA_selectwindow       DW ?
  VESA_selectwindowseg    DW ?
  VESA_window             DW 0ffffh

;
; functions

;----------------------------------------------------------------------------
; proc VESA_init: initializes vesa interface
; INPUT: cx - mode (see above), stack - 282 bytes MUST be free
; MODIFIES: ax, di, si, ds, es; OUTPUT: cf - set if error, gs - 0a000h

  VESA_init               proc near
    push     cs
    pop      ds
    push     ss
    pop      es
    mov      di, sp
    sub      di, 282
    push     di
    mov      ax, 4f01h
    int      10h
    pop      di
    cmp      ax, 4fh
    jne      VESA_init_error
    mov      ax, es: [di + 12]
    mov      VESA_selectwindow, ax
    mov      ax, es: [di + 14]
    mov      VESA_selectwindowseg, ax
    mov      bx, cx
    mov      ax, 4f02h
    int      10h
    cmp      ax, 4fh
    jne      VESA_init_error
    mov      ax, 0a000h
    mov      gs, ax
    clc
    ret
    VESA_init_error:
    stc
    ret
  endp                    VESA_init

;----------------------------------------------------------------------------
; proc VESA_exit: just sets textmode 3 (80x25x16)
; MODIFIES: ax

  VESA_exit               proc near
    mov      ax, 3
    int      10h
    ret
  endp                    VESA_exit

;----------------------------------------------------------------------------
; proc VESA_adjustwindow: sets the vesa window
; INPUT: di - page; OUTPUT: ax - status (4f if succesfull)

  VESA_adjustwindow        proc near
    push     ax bx dx
    mov      bx, 0
    mov      dx, di
    mov      cs: VESA_window, di
    call     dword ptr [VESA_selectwindow]
    pop      dx bx ax
    retn
  endp                     VESA_adjustwindow

;----------------------------------------------------------------------------
; proc COLOR_setpalette: sets a color palette located at ds:si
; INPUT: al - first index, ds:si - 768 byte array, cx - count * 3
; MODIFIES: cx, dx

  COLOR_setpalette        proc near
    mov      dx, 3c8h
    out      dx, al
    inc      dx
    rep      outsb
    ret
  endp                    COLOR_setpalette

;
; macros

;----------------------------------------------------------------------------
; macro VESA_pixel: sets a pixel
; INPUT: edi - linear position, al - pixel, gs - MUST be 0a000h

  VESA_pixel               macro
  local VESA_pixel_set
    push     edi
    push     offset VESA_pixel_set
    shr      edi, 16
    cmp      cs: VESA_window, di
    jne      VESA_adjustwindow
    add      sp, 2
    VESA_pixel_set:
    pop      edi
    mov      gs: [di], al
  endm                     VESA_pixel

; EOF