;
; this is part of the maxSYS real mode assembler interface by
; florian haller/aeiou written in 1997
;
; demostrates the use of maxMUSIC and maxUTIL in com-files
; the "music" is available in three different versions:
; - music.sm0 is the raw data (so you can load it in maxTRACK)
; - music.sm1 is the optimized format (which maxMUSIC can play) and
; - optimum.sm1, which is used in this test, is even more
; optimized (added the "continue" commands)
; it also demostrates how to setup a user timer
;

.model tiny
.386
.code
org 100h

start:
  call MPU_reset
  mov ah, 9
  mov dx, offset message
  int 21h
  mov si, offset music
  call MUSIC_start
  loop1:
  call KEYB_checkkey
  jz loop1
  call MUSIC_stop
  call KEYB_clearbuffer
  push cs                               ; MUSIC_start modified ds
  pop ds
  mov ah, 9
  mov dx, offset stopped
  int 21h
  mov ah, 4ch
  int 21h

TIMER_user:                             ; this is our own timer
  mov dl, 46
  mov ah, 2
  int 21h                               ; write a . to standard output
  jmp MUSIC_play_userjmp                ; get back to the music timer

message db 'playing...', 36
stopped db 'stopped.', 13, 10, 36

music db 001h, 00ch, 00dh, 00fh, 07bh, 00dh, 00fh, 07dh, 00dh, 00fh, 07fh, 00dh
      db 00fh, 081h, 00dh, 00fh, 083h, 00dh, 00fh, 085h, 00dh, 00fh, 087h, 00dh
      db 00fh, 089h, 00dh, 00fh, 08bh, 00dh, 00fh, 08dh, 00dh, 00fh, 08fh, 00dh
      db 00fh, 08dh, 00dh, 00eh, 08bh, 00dh, 00dh, 089h, 00dh, 00ch, 087h, 00dh
      db 00bh, 085h, 00dh, 00ah, 083h, 00dh, 009h, 081h, 00dh, 008h, 07fh, 00dh
      db 007h, 07dh, 00dh, 006h, 07bh, 031h, 005h, 079h, 00ch, 000h

  include ..\..\resource\maxmusic.asm
  include ..\..\resource\maxutil.asm

end start