****************************************************
* Example for using conditional with user messages *
****************************************************

#EXTRAON  -- Allow extra mnemonics

#ifdef DEBUG
                    #message  Assembling in DEBUG Mode
SPEED               EQU       $00                 ;115200 bps rate for SIM11E to go faster
#else
SPEED               EQU       $30                 ;9600 bps rate
#endif

BAUD                EQU       $102B

                    ORG       $D000
Start               lds       #$1ff
                    lda       #SPEED
                    sta       BAUD
          ;--- more code ---

          ;--- the following RMB is only used to force an ERROR
          ;--- for the following IF condition
#ifdef ERROR
                    rmb       $2FB7               $2FB7 causes error
#else
                    rmb       $2FB6               $2FB6 causes no error
#endif
                    bra       *

          ;You can use the following condition in all your programs to prevent
          ;from writing code that will not fit the device's EPROM
#if * > $FFC0
  #ifdef DEBUG
    #warning Program too big; runs into reserved memory
  #else
    #error Program too big; runs into reserved memory
  #endif
#endif

          ;Instead of the above conditional you could also define a
          ;memory range with $MEMORY and the assembler will warn about
          ;going outside the defined range.  To test it uncomment the
          ;following two lines and comment the above conditional.

;#MEMORY $D000 $FFBF
;#MEMORY $FFD6 $FFFF

                    org       $FFFE
                    dw        Start