
Program EXAMPLE;

 Uses Mcgalib, Animlib, Crt, Memory;

 Type
  buffer = array[0..6406] of byte;

 Const
  VGA256 = 19;
  TEXT = 3;
  SHIP_SERIES : integer = 1;
  SCENERY_SERIES : integer = 3;

 Var
  sprite : integer;
  last_sprite : integer;
  x, y, yold: integer;
  SPRMAX : integer;
  flip: integer;
  BLOCKSAVE : ^buffer;       { Pointer on buffer for screen block }
  Ch : Char;

  test: Pointer;
  headptr : Pointer;
  head : ^SPRITEHEADER absolute headptr;
  test1: longint;

    { First, allocation of memory buffer }

 Begin

  writeln('Initial memory ', MemAvail);

  GetMem( BLOCKSAVE, 6406);

  if sprite_alloc(BUFFERSIZE) = False Then
   Begin
     writeln('Not enough memory...');
     Exit;
   End;

    { Loading sprites  }

 writeln('Loading invaders.dat...');
 if sprites_load('invaders.dat', 65512) = 0 Then
 Begin
   writeln('File invader.dat no found...');
   Exit;
 End;

    { Setting VGA 256 colors screen }

 selectscreen(VGA256);

    { Setting a full screen window }

 window19(0, 0, 319, 199);

    { Drawing the scenery }

 for y := 0 to 1 do
  for x := 0 to 4 do
   csprite256c(x * 80, y * 80 + 20, SPVECTOR[get_first(SCENERY_SERIES)]);

    { Now, setting window's limits left, top, right, bottom }

 window19(40, 20, 280, 179);

    { Animation example }

 x := 140;
 y := 5;
 yold := y;
 getblock(x, yold, x + 31, y + 49, BLOCKSAVE);  { Saving background }
 flip := 0;

     { Starting at the first image in the ship animation }
     { On dmarre avec la premire image de l'animation de vaisseau }

 sprite := get_first(SHIP_SERIES);

     { The last sprite is number of the first + number of frames - 1 }
     { Le dernier sprite est le numro du premier + nombre de frames - 1 }

 last_sprite := sprite + get_frame_number(SHIP_SERIES) - 1;

 while y < 180 do
 Begin
  synchro;
  putblock(x, yold, BLOCKSAVE);              { Restoring background }
  getblock(x, y, x + 31, y + 49, BLOCKSAVE); { Saving new area }
  sprite256c(x, y, SPVECTOR[sprite]);        { Sprite display }


   flip := 1 - flip;          { Slow cycling / Ralentit cyclage }
   if flip = 1 then
   Begin
    sprite := sprite + 1;
    if sprite > last_sprite then
    Begin
     sprite := get_first(SHIP_SERIES);  { Last sprite reached, restart }
    End;
   End;

   Delay(100);        { Slow down and set all computers same speed }
   yold := y;
   y := y + 1;

  if KeyPressed = True Then y := 180;

 End;

 selectscreen(TEXT);  { Restores DOS text screen }
 Exit;                { Exit program }

End.
