/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   LockAPI.cpp, Definition for class Lockable and LockServer
   designed for Cross Platform API Library by Moby Disk
   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */

#ifndef __lockapi_h__
#define __lockapi_h__

#include "PipeAPI.h"
#include "ThreadAPI.h"

// Lock server scale
#define LS_QUEUESIZE     1000
// Lock server commands
#define LOCKAPI_LOCK     1
#define LOCKAPI_UNLOCK   2
#define LOCKAPI_SHUTDOWN 3

class Lockable;
class LockServer;

// Lock server message structure
typedef struct {
  int       command;          // Command for the lockeserver
  int       count;            // Count of Lockable objects
  int       who;              // Unique id for the locker(usually thread/process id)
  Lockable *item[5];          // List of Lockable objects
} LockStruct;

// List of things waiting to be locked
typedef struct {
  Lockable *item;             // Lockable waiting to be locked
  int       who;              // Unique id for the locker(usually thread/process id)
} LockNode;


class LockServer : public Threadable {
  protected:
    LockNode     lockList[LS_QUEUESIZE];
    int          lockTail, n;
    int          scanlock(Lockable *toLock, int who);
    int          queue(Lockable *toLock, int who);
  public:
    Pipe         lockPipe;
    virtual void main();
    void         done(int threadID);
};

class Lockable {
  protected:
    volatile int lockVal;
    static       LockServer *locker;
    static void  send(int command, int id, Lockable *object);
  public:
    Lockable() : lockVal(0) {}

    static void  init();
    static void  done(int threadID);

    static void  lockMany(int threadID, Lockable *a, Lockable *b);
    void         lock(int threadID);
    void         unlock(int threadID);

  friend class LockServer;
};

#endif