/* Algomath library */
/* release 0.93 beta 4.1998*/
/* see Readme.txt for details */


#include <math.h>
#include <stdlib.h>
int p_pt(int t);
int am_asciiconv[]={1000000000,
					100000000,
					10000000,
					1000000,
					100000,
					10000,
					1000,
					100,
					10,
					1};


/* sum of digits */
int am_sumdigits(int n)
{
	int Sum = 0;

	if(n < 0)
		n = -n;

	while(n >= am_asciiconv[0])
	{
		n -= am_asciiconv[0];
		Sum++;
	}
	while(n >= am_asciiconv[1])
	{
		n -= am_asciiconv[1];
		Sum++;
	}
	while(n >= am_asciiconv[2])
	{
		n -= am_asciiconv[2];
		Sum++;
	}
	while(n >= am_asciiconv[3])
	{
		n -= am_asciiconv[3];
		Sum++;
	}
	while(n >= am_asciiconv[4])
	{
		n -= am_asciiconv[4];
		Sum++;
	}
	while(n >= am_asciiconv[5])
	{
		n -= am_asciiconv[5];
		Sum++;
	}
	while(n >= am_asciiconv[6])
	{
		n -= am_asciiconv[6];
		Sum++;
	}
	while(n >= am_asciiconv[7])
	{
		n -= am_asciiconv[7];
		Sum++;
	}
	while(n >= am_asciiconv[8])
	{
		n -= am_asciiconv[8];
		Sum++;
	}

	return Sum + n;
}


/* alternating sum of digits */
int am_sumdigitsalt(int n)
{
	int i;
	int Sum = 0;
	int PlusMinus = 1;

	if(n < 0)
		n = -n;

	i=0;
	while(n < am_asciiconv[i])
		i++;
	for(;i < 9;i++)
	{
		if(PlusMinus)
			while(n >= am_asciiconv[i])
			{
				n -= am_asciiconv[i];
				Sum++;
			}
		else
			while(n >= am_asciiconv[i])
			{
				n -= am_asciiconv[i];
				Sum--;
			}
		PlusMinus = 1 - PlusMinus;
	}

	if(PlusMinus)
		return Sum + n;
	else
		return Sum - n;
}


/* rotate n by x, in base 10, x > 0 => right, x < 0 => left */
int am_rotate(int n,int x)
{
	int i,j;
	int Temp;

	if(n == 0)
		return 0;
	if(x == 0)
		return n;

	j = 8;
	i = 1;
	while(n > am_asciiconv[j])
	{
		i++;
		j--;
	}

	while(x < 0)
		x += i;
	x %= i;

	i = 1;
	for(j = 1; j <= x; j++)
		i *= 10;
	j = 9;
	Temp = n / i;
	while(Temp > am_asciiconv[j])
		j--;
	return am_asciiconv[j] * (n % i) + Temp;
}


/* sum of divisors of n, n not included */
int am_sumdivisors(int n)
{
	int Kleng=1;
	int Grouss=n;
	int Sum=0;

	if(n < 2)
		return 0;

	while(Kleng<Grouss)
	{
		if((n % Kleng) == 0)
		{
			Sum += Kleng;
			Grouss = n / Kleng;
			if(Kleng != Grouss)
				Sum += Grouss;
		}
		Kleng++;
	}

	return Sum - n;
}

/* sorting digits, e.g. 65123 => 12356 */
int am_sortdigits(int n)
{
	int i,j;
	int Temp;
	int Ziffer[]={0,0,0,0,0,0,0,0,0,0};

	if(n < 0)
		n = -n;

	for(i = 0; i < 9; i++)
	{
		Temp = 0;
		while(n >= am_asciiconv[i])
		{
			n -= am_asciiconv[i];
			Temp++;
		}
		Ziffer[Temp]++;
	}
	Ziffer[n]++;

	n = 0;
	for(i = 1; i <= 9; i++)
		for(j = 1; j <= Ziffer[i]; j++)
			n = n * 10 + i;

	return n;
}



/* do we have a prime number ? */
int am_primetest(int t)
{
     int a=5;
     if (t<4)
        {
         if (t==2)
             return 1;
         if (t==3)
             return 1;
         return -1;
        }
     if (t%2==0)
         return -1;
     if (t%3==0)
         return -1;
    while (a*a<=t)
          {
           if (t%a==0)
               return -1;
           if (t%(a+2)==0)
               return -1;
           a=a+6;
          }
     return 1;
}


/* create an array of prime numbers */
void am_primearray (int f, int l,int *a )
{

 int i=5;
 int p=3;
 int n=0;
 if (f<3)
     {
      if (f<2)
         {
          a[0]=2;
          a[1]=3;
          n=n+2;
          
         }
         else
         {
          a[0]=3;
          n++;
         }
     }

 
 for (;;)
 {
  
		if ( p_pt(i) == 1 )
		     {
			  if (p>=f)
			      {
			       a [ n ] = i;
				   n++;
                   if ( n == l )
			          {
				       return;
				      }
				  }
		      p++;
	    	}
	        i = i+2;
			if ( p_pt(i) == 1 )
			     {
				  if (p>=f)
				  	{
				  	 a [ n ] = i;
				  	 n++;
                      if ( n == l )
				         {
					      return;
					     }
				    }
			      p++;
				 
				 }
				 
	i = i + 4;
  }
}
int p_pt(int t)
{
    
    int a=5;
    while (a*a<=t)
          {
           if (t%a==0)
               return -1;
           if (t%(a+2)==0)
               return -1;
           a=a+6;
          }
     return 1;
}



/* factorization */
void am_factorize(int n,int* Feld)
{
	int a;
	int i = 0;

	if(n <= 1)
	{
		*Feld=0;
		return;
	}

	while((n&1) == 0)
	{
		Feld[++i] = 2;
		n >>= 1;
	}
	while((n%3) == 0)
	{
		Feld[++i] = 3;
		n /= 3;
	}
	while((n%5) == 0)
	{
		Feld[++i] = 5;
		n /= 5;
	}
	while((n%7) == 0)
	{
		Feld[++i] = 7;
		n /= 7;
	}

	for(a = 11; a * a <= n; a += 6)
	{
		while((n%a) == 0)
		{
			Feld[++i] = a;
			n /= a;
		}
		while((n%(a + 2)) == 0)
		{
			Feld[++i] = a + 2;
			n /= a + 2;
		}
	}
	if(n > 1)
		Feld[++i] = n;

	Feld[0] = i;
return;
}


/* greatest common divisor */
int am_gcd(int a,int b)
{
	int c;

	if(a == 0)
		return 0;
	if(b == 0)
		return 0;
	if(a < 0)
		a = -a;
	if(b < 0)
		b = -b;

	while(b)
	{
		c = a;
		a = b;
		b = c % b;
	}

	return a;
}

/*  Goldbach's Conjecture  */
int am_goldbach(int a,int *p)
{
int e=5,k;
 if (am_primetest(a-3)==1)
     {
      p[0]=3;
      p[1]=a-3;
      return 1;
     }
k=a/2+1;
while(e<k)
     {
      if (p_pt(e)==1)
         {
          if(am_primetest(a-e)==1)
             {
              p[0]=e;
              p[1]=a-e;
              return 1;
             }
         }
       e=e+2;
       if (p_pt(e)==1)
         {
          if(am_primetest(a-e)==1)
             {
              p[0]=e;
              p[1]=a-e;
              return 1;
             }
         }
      e=e+4;
     }
return -1;
}
