program EasySerial;

uses
  Windows,
  Messages;

var hInst: longint;
    EnteredName, EnteredSerial: string;
{$R dialog.res}
{$R bitmap.res}
{$R icon.res}

procedure Finalize(Dlg: hWnd);
var Text: array [0..255] of char;
begin
  GetDlgItemText(Dlg,102,Text,SizeOf(Text));
  EnteredName:=Text;
  GetDlgItemText(Dlg,103,Text,SizeOf(Text));
  EnteredSerial:=Text;
  EndDialog(Dlg, 1);
end;

procedure EndDlg(WParam: Word; Dlg: HWnd);
begin
  case LoWord(WParam) of
    IDOK: Finalize(Dlg);
  end;
end;

function DlgProc(Dialog: HWnd; Msg, WParam: Word; LParam: Longint): Bool; stdcall;
var hBMP: HBITMAP;
begin
  case Msg of
    WM_COMMAND: EndDlg(WParam, Dialog);
    WM_CLOSE: Finalize(Dialog);
    WM_INITDIALOG:
    begin
      // set up our nice image
      hBMP:=LoadBitmap(hInst,'LOGO');
      SendDlgItemMessage(Dialog,104,STM_SETIMAGE,IMAGE_BITMAP,hBMP);
    end;
  end;
  DlgProc := FALSE;
end;

function CalculateSerial(const Name: string):string;
var i: integer;
    serial: dword;
begin
  dec(serial,serial);          // Serial=0
  for i:=1 to length(Name) do
  begin
    serial:=serial+ord(Name[i]);
    serial:=serial xor $12345678;
  end;
  Str(serial,result);
end;

procedure CreateDlgWindow;
begin
  hInst := $400000; //GetModuleHandle(nil);  // returns always $400000 (ImageBase), but who cares?
  DialogBoxParam(hInst, 'PASSWD', 0, @DlgProc, 0);

  if CalculateSerial(EnteredName)=EnteredSerial then
     MessageBox(GetDesktopWindow,'Thank you for registering Easy Serial','Registration successful',MB_ICONINFORMATION)
  else
      MessageBox(GetDesktopWindow,'Entered serial is incorrect!','Registration not successful',MB_ICONHAND);
end;

begin
  CreateDlgWindow;
end.


