unit ACLibDemo;
interface

uses Windows, ImageHlp, Registry, Classes, SysUtils, Messages;


// ***** Breakpoints detection *****
// DEMO VERSION...

// ***** Debugger/other tools termination *****
// DEMO VERSION...

// ***** Debugger/other tools detection *****
function SICE_Detect_CreateFile:boolean;
function Debugger_Detect_API:boolean;
function DeDe_Detect_EnumWindows:boolean;
// + many others in full version

// ***** Anti-unpacking functions *****
function PECheckSum_Win32(const FileName: string):boolean;
// + many others in full version

// ***** Misc. functions *****
// DEMO VERSION...

// ***** Crash Program/Windows functions *****
procedure Crash_App_VMMCall;
procedure Crash_Win_CPUReset;
// + many others in full version

function Win9xMe:boolean;


const EXCEPTION_CONTINUE_EXECUTION = -1;
      EXCEPTION_CONTINUE_SEARCH    =  0;

implementation


function DecodeString(Encoded: string):string;
// decodes encoded string
var i:integer;
begin
  result:='';
  for i:=1 to length(Encoded) do
      result:=result+chr(ord(Encoded[i])-10);
end;

function SICE_Detect_CreateFile:boolean;
var Handle: THandle;
    Driver: string;
const SICE={'\\.\SICE'} 'ff8f]SMO';
      NTICE={'\\.\NTICE'} 'ff8fX^SMO';
begin
  if Win9xMe then Driver:=SICE else Driver:=NTICE;
  Driver:=DecodeString(Driver);
  // You can try to use functions
  // _lcreat and _lopen, which are old and not
  // used (therefore, not easy to detect)

  // Handle:=_lcreat(PChar(Driver),0);
  // if Handle=HFILE_ERROR then
  // ...

  // Also, you can try to open other SoftICE
  // drivers: SIWVID (video driver) and SIWDEBUG

  Handle:=CreateFile(PChar(Driver),GENERIC_READ or GENERIC_WRITE,
            FILE_SHARE_READ+FILE_SHARE_WRITE,nil,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);

  if Handle=INVALID_HANDLE_VALUE then
     result:=false
  else
  begin
    result:=true;
    CloseHandle(Handle);
  end;
end;

function Debugger_Detect_API:boolean;
type TIsDebuggerPresent=function:boolean; stdcall;
const IsDbgPresent={'IsDebuggerPresent'}'S}Nolqqo|Z|o}ox~';
var h: HINST;
    IsDebuggerPresent: TIsDebuggerPresent;
begin
  result:=false;
  h:=GetModuleHandle('kernel32');
  if h=0 then exit;
  IsDebuggerPresent:=GetProcAddress(h,PChar(DecodeString(IsDbgPresent)));
  if not Assigned(IsDebuggerPresent) then exit;
  result:=IsDebuggerPresent;
end;

function DeDe_Detect_EnumWindows:boolean;
var DeDeFound: BOOL;
// EnumWindowsProc
function EnumWndsProc(Handle:hWnd;LParam:longint):boolean; stdcall;
const DeDe = {'DeDe '} 'NoNo*';
var wText: array [1..256] of char;
    PDedeFound: PBOOL;
begin
  GetWindowText(Handle,@wText[1],SizeOf(wText));
  if StrPos(@wText[1],PChar(DecodeString(DeDe)))<>nil then
  begin
    PDeDeFound:=Ptr(LParam);
    PDeDeFound^:=true;
  end;
  result:=true;
end;
// Main function part
begin
  DeDeFound:=false;
  EnumWindows(@EnumWndsProc,Integer(@DeDeFound));
  Result:=DeDeFound;
end;

function PECheckSum_Win32(const FileName: string):boolean;
var HeaderSum, CheckSum: DWORD;
begin
  MapFileAndChecksum(PChar(FileName),HeaderSum,CheckSum);
  if CheckSum=HeaderSum then
     result:=true
  else
      result:=false;
end;

function Win9xMe:boolean;
begin
  result:=true;
  asm
    mov eax,cs
    test al,100b
    jne @Win9x
    mov result,false
   @Win9x:
  end;
end;

procedure Crash_App_VMMCall;
asm
  db $CD, $20, $3F, 1, 1, 0 // VxDCall VMM_GetDDBList
end;

procedure Crash_Win_CPUReset;
asm
  mov ax,0feh
  out 64h,ax
end;

end.
