unit options;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, ACLib, ImageHlp, Registry;

  {$I defines.inc}

type
  TOptionsDlg = class(TForm)
    Bevel1: TBevel;
    Slow: TLabel;
    Fast: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Speed: TLabel;
    Population: TLabel;
    Time: TLabel;
    OKBtn: TButton;
    CancelBtn: TButton;
    SpeedSet: TTrackBar;
    PopulationSet: TTrackBar;
    GameTimeSet: TEdit;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label3: TLabel;
    Label4: TLabel;
    NameSet: TEdit;
    KeySet: TEdit;
    Button1: TButton;
    procedure OKBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OptionsDlg: TOptionsDlg;

implementation

uses Main;

{$R *.dfm}

procedure TOptionsDlg.OKBtnClick(Sender: TObject);
begin
  SwatForm.LiveTime := SpeedSet.Max + 1 - SpeedSet.Position;
  SwatForm.Frequence := PopulationSet.Position;

  if aclGetText(GameTimeSet.Handle)<>'100' then
  begin
    if Main.GenerateSerial(Main.UserName)=Main.UserKey then
       SwatForm.GameTime := StrToInt(GameTimeSet.Text)
    else
        MessageBox(Handle,'You can not change game time in demo version.','Shareware',MB_ICONINFORMATION);
  end;

  // limit the value of GameTime to a reasonable length
  if (SwatForm.GameTime < 1) then
    SwatForm.GameTime := 150;
  if (SwatForm.GameTime > 9999) then
    SwatForm.GameTime := 9999;
end;

procedure TOptionsDlg.FormShow(Sender: TObject);
var Head: PImageNtHeaders;
begin
  SpeedSet.Position := SpeedSet.Max + 1 - SwatForm.LiveTime;
  PopulationSet.Position := SwatForm.Frequence;
  GameTimeSet.Text := inttoStr(SwatForm.GameTime);

  Head:=GetImageNTHeaders;
  {$IFDEF RELEASE}
  if PECheckSum_ACLib(ParamStr(0))<>Head.FileHeader.TimeDateStamp then
     close;
  {$ENDIF}
end;

procedure TOptionsDlg.CancelBtnClick(Sender: TObject);
begin
  if ((GetAsyncKeyState(VK_SHIFT) and $8000)=$8000) then
     PageControl1.ActivePage:=TabSheet2
  else
      close;
end;

procedure TOptionsDlg.Button1Click(Sender: TObject);
begin
  with TRegistry.Create do
  begin
    OpenKey('Software\migeel\SWAT',true);
    WriteString('UserName',NameSet.Text);
    WriteString('UserKey',KeySet.Text);
    Main.UserName:=NameSet.Text;
    Main.UserKey:=KeySet.Text;
  end;
  PageControl1.ActivePage:=TabSheet1;
end;

end.
