unit FMDecryptTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DecryptEngine;

type
  TDcTest = class(TForm)
    Label1: TLabel;
    GroupBox1: TGroupBox;
    Button1: TButton;
    Label2: TLabel;
    Button2: TButton;
    DecryptEngine: TDecryptEngine;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DcTest: TDcTest;

implementation

{$R *.DFM}

procedure TDcTest.Button1Click(Sender: TObject);
begin
  {$I encrypt_start.inc}
  ShowMessage('This message will be shown only if license.lic present!');
  {$I encrypt_stop.inc}
end;

procedure TDcTest.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TDcTest.FormShow(Sender: TObject);
begin
  // CanDecrypt is set to true if LicenseFile exists
  // if file is not packed, lets act as if it was registered
  if (DecryptEngine.CanDecrypt) or
       (DecryptEngine.FileEncrypted=false) then
  begin
    Label1.Caption:='Registered';
    Button1.Enabled:=true;
  end;

  // FileEncrypted is true if file is encrypted
  if DecryptEngine.FileEncrypted then
     Label2.Caption:='File is encrypted.';

  // decrypts the application (only if license file present)
  DecryptEngine.DecryptApplication;
end;

end.
