unit TestForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ACLib,
  StdCtrls, ComCtrls;

type
  TFrmTest = class(TForm)
    GroupBox1: TGroupBox;
    Detect: TListView;
    RefreshList: TButton;
    GroupBox2: TGroupBox;
    Breakpoints: TListView;
    RefreshBPs: TButton;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    RefreshUnp: TButton;
    FrogsICE: TButton;
    GroupBox4: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    Label5: TLabel;
    Label6: TLabel;
    procedure RefreshListClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RefreshBPsClick(Sender: TObject);
    procedure RefreshUnpClick(Sender: TObject);
    procedure FrogsICEClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmTest: TFrmTest;

implementation

{$R *.DFM}

procedure TFrmTest.RefreshListClick(Sender: TObject);
begin
  with Detect do
  begin
    Items[0].Checked:=SICE_Detect_CreateFile;
    Items[1].Checked:=SICE_Detect_Int68h;
    Items[2].Checked:=SICE_Detect_Registry;
    Items[3].Checked:=SICE_Detect_Autoexec;
    Items[4].Checked:=SICE_Detect_Boundschecker;
    Items[5].Checked:=SICE_Detect_Int1;
    //Items[6].Checked:=SICE_Detect_API;
    Items[7].Checked:=SICE_TRW_Detect_Int1Int3;
    Items[8].Checked:=TRW_Detect_CreateFile;
    Items[9].Checked:=Debugger_Detect_API;
    Items[10].Checked:=Debugger_Detect_Asm;
    Items[11].Checked:=Monitors_Detect_FindWindow;
    Items[12].Checked:=Monitors_Detect_FindDriver;
    Items[13].Checked:=DeDe_Detect_EnumWindows;
  end;
end;

procedure TFrmTest.FormShow(Sender: TObject);
begin
  RefreshListClick(nil);
  RefreshBPsClick(nil);
  RefreshUnpClick(nil);
end;

procedure TFrmTest.RefreshBPsClick(Sender: TObject);
begin
  with Breakpoints do
  begin
    Items[0].Checked:=API_HasBPX(@MessageBoxA);
    Items[1].Checked:=API_HasBPR(@MessageBoxA);
    Items[2].Checked:=BPMset;
  end;
end;

procedure TFrmTest.RefreshUnpClick(Sender: TObject);
var Head: PImageNtHeaders;
    Unpacked: boolean;
begin
  Unpacked:=false;
  Label1.Caption:=Format('FileSize: %d',[GetExeFileSize]);
  Head:=GetImageNTHeaders;

  Label2.Caption:=Format('SizeOfInitializedData: %d',[Head.OptionalHeader.SizeOfInitializedData]);
  Label3.Caption:=Format('SizeOfUnInitializedData: %d',[Head.OptionalHeader.SizeOfUnInitializedData]);
  Label4.Caption:='PE Checksum: ';
  if PECheckSum_Win32(ParamStr(0)) then
     Label4.Caption:=Label4.Caption+'valid'
  else
      Label4.Caption:=Label4.Caption+'invalid';

  if GetExeFileSize>200000 then Unpacked:=true;
  if Head.OptionalHeader.SizeOfInitializedData>40000 then Unpacked:=true;
  if Head.OptionalHeader.SizeOfUnInitializedData=0 then Unpacked:=true;
  if not PECheckSum_Win32(ParamStr(0)) then Unpacked:=true;

  if Unpacked=true then
  begin
    with GroupBox3 do
    begin
      Font.Color:=clRed;
      Caption:=Caption+'UNPACKED';
    end;
  end
  else
      Groupbox3.Caption:=Groupbox3.Caption+'not unpacked';
end;

procedure TFrmTest.FrogsICEClick(Sender: TObject);
begin
  Detect_FrogsICE_Kill;
end;

procedure TFrmTest.Button1Click(Sender: TObject);
begin
  Crash_App_VMMCall;
end;

procedure TFrmTest.Button2Click(Sender: TObject);
begin
  Crash_App_AccessViolation;
end;

end.
