Unit McVIS;

Interface

Uses Views, Objects, App, Drivers, Dialogs, McConst, McUnit;

Const
  CCPUView   = #1#5#9#10;
  CCPUWindow = #64#65;

Type
  PMyView=^TMyView;
  TMyView=Object(TView)
    Buffer : TVideoBuf;
    Constructor Init(Bounds:TRect);
    Procedure Draw; Virtual;
    Procedure InitBuffer;
    Procedure SetBufferStr(X,Y:Integer; Str:String; attrib:Byte);
  End;

  PMemoryMcView=^TMemoryMcView;
  TMemoryMcView=Object(TMyView)
    VScroll: PScrollBar;
    TopLeftAddress: Word;
    Constructor Init(Bounds: TRect);
    Procedure HandleEvent(Var Event: TEvent); Virtual;
    Procedure Draw; Virtual;
  End;

  PMemoryMcWindow=^TMemoryMcWindow;
  TMemoryMcWindow=Object(TWindow)
    MemoryView: PMemoryMcView;
    Constructor Init(Var Bounds: TRect; ATitle: TTitleStr; ANumber: Integer);
    Procedure Close; Virtual;
    Procedure HandleEvent(Var Event: TEvent); Virtual;
  End;

  PRegistersMcView=^TRegistersMcView;
  TRegistersMcView=Object(TMyView)
    Selected: Byte;
    Constructor Init(Bounds: TRect);
    Procedure Draw; Virtual;
    Procedure HandleEvent(Var Event: TEvent); Virtual;
  End;

  PRegistersMcWindow=^TRegistersMcWindow;
  TRegistersMcWindow=Object(TWindow)
    RegistersView: PRegistersMcView;
    Constructor Init(Var Bounds: TRect; ATitle: TTitleStr; ANumber: Integer);
    Procedure Close; Virtual;
  End;

  PCPUMcView=^TCPUMcView;
  TCPUMcView=Object(TMyView)
    VScroll           : PScrollBar;
    TopLeftAddress    : Word;
    ScreenViewAddress : Word;
    Dissasembling     : Boolean;
    CurrentAddress    : Word;
    Line              : String;
    NumByte           : Byte;
    Constructor Init(Bounds:TRect; Start : Word );
    Procedure HandleEvent(Var Event: TEvent); Virtual;
    Procedure CheckTopLeft;
    Procedure Draw; Virtual;
    function  GetPalette: PPalette; Virtual;
    Procedure InitPos ( Start : Word );
  End;

  PCPUMcWindow=^TCPUMcWindow;
  TCPUMcWindow=Object(TWindow)
    CPUView : PCPUMcView;
    Constructor Init(Var Bounds:TRect; ATitle:TTitleStr; ANumber:Integer; Start : Word );
    Procedure   Close; Virtual;
    function    GetPalette: PPalette; Virtual;
  End;

  PTimeView=^TTimeView;
  TTimeView=Object(TMyView)
    Time    : LongInt;
    AllTime : LongInt;
    Command_: String;
    Constructor Init(Bounds: TRect);
    Procedure HandleEvent(Var Event:TEvent); Virtual;
    Procedure Draw; Virtual;
    Procedure Clear;
    Procedure Calc;
  End;

  PTimeWindow=^TTimeWindow;
  TTimeWindow=Object(TWindow)
    TimeView : PTimeView;
    Constructor Init(Var Bounds: TRect; ATitle: TTitleStr; ANumber: Integer);
    Procedure   Close; Virtual;
  End;

  PStackView=^TStackView;
  TStackView=Object(TMyView)
    Constructor Init(Bounds: TRect);
    Procedure HandleEvent(Var Event:TEvent); Virtual;
    Procedure Draw; Virtual;
    Procedure Clear;
  End;

  PStackWindow=^TStackWindow;
  TStackWindow=Object(TWindow)
    StackView : PStackView;
    Constructor Init(Var Bounds: TRect; ATitle: TTitleStr; ANumber: Integer);
    Procedure   Close; Virtual;
  End;

Const MemoryMcWindow    : PMemoryMcWindow=Nil;
      RegistersMcWindow : PRegistersMcWindow=Nil;
      CPUMcWindow       : PCPUMcWindow=Nil;
      TimeWindow        : PTimeWindow=Nil;
      StackWindow       : PStackWindow=Nil;
Implementation

Constructor TMyView.Init(Bounds:TRect);
Begin
  TView.Init(Bounds); InitBuffer;
End;

Procedure TMyView.Draw;
Begin
  WriteBuf( 0, 0,Size.X,Size.Y,Buffer);
End;

Procedure TMyView.SetBufferStr(X,Y:Integer; Str:String; attrib:Byte);
Var
  BegBuf, EndBuf : Word;
Begin
  BegBuf:=X+Y*Size.X; EndBuf:=Size.X+Y*Size.X;
  If BegBuf+Length(str)>EndBuf Then str:=Copy(str,1,EndBuf-BegBuf);
  MoveStr(Buffer[BegBuf],str,GetColor(attrib));
End;

Procedure TMyView.InitBuffer;
Begin MoveChar(Buffer[0],' ',GetColor(1),(SizeOf(Buffer)div 2)-1); End;

Constructor TMemoryMcWindow.Init(Var Bounds:TRect; ATitle:TTitleStr; ANumber:Integer);
Begin
  TWindow.Init(Bounds,ATitle,ANumber);
  Bounds.Assign( 1, 1,Size.X-1,Size.Y-1);
  MemoryView:=New(PMemoryMcView,Init(Bounds));
  Insert(MemoryView);
  MemoryView^.VScroll:=StandardScrollBar(sbVertical);
  MemoryMc^.CalcLastMemoryAddress;
  MemoryView^.VScroll^.SetRange(0,MemoryMc^.LastMem);
  MemoryView^.VScroll^.SetStep((Size.Y-2)*NumByteofLine,8);
End;

Procedure TMemoryMcWindow.HandleEvent(Var Event: TEvent);
Begin
  TWindow.HandleEvent(Event);
  Case Event.What Of
   evBroadcast: Case Event.Command Of
     cmScrollBarChanged:
       MemoryView^.TopLeftAddress:=MemoryView^.VScroll^.Value;
     else Exit;
    End;
  else Exit;
  End;
  ReDraw;
End;

Constructor TMemoryMcView.Init;
Begin
  TView.Init(Bounds);
  TopLeftAddress:=0;
  Options:=Options Or ofPreProcess;
  GrowMode:=gfGrowHiX Or gfGrowHiY;
End;

Procedure TMemoryMcView.HandleEvent(Var Event:TEvent);
Var ScreenViewAddress:Word;
Begin
  TView.HandleEvent(Event);
  MemoryMc^.CalcLastMemoryAddress;
  ScreenViewAddress:=Size.Y * NumByteOfLine;
  Case Event.What Of
   evKeyDown : Case Event.KeyCode Of
      kbDown : If TopLeftAddress <  MemoryMc^.LastMem-8 Then Inc (TopLeftAddress, 8 );
      kbUp   : If TopLeftAddress >= 8 Then Dec (TopLeftAddress, 8 );
      kbPgDn : If TopLeftAddress <  MemoryMc^.LastMem-ScreenViewAddress
                 Then Inc(TopLeftAddress,ScreenViewAddress)
                   else TopLeftAddress:=MemoryMc^.LastMem-ScreenViewAddress;
      kbPgUp : If TopLeftAddress>=ScreenViewAddress
                 Then Dec(TopLeftAddress,ScreenViewAddress)
                   else TopLeftAddress:=0;
    else Exit;
    End;
   evBroadcast: Case Event.Command Of
                 cmScrollBarChanged: TopLeftAddress:=VScroll^.Value;
    End;
  End;
  VScroll^.Value:=TopLeftAddress;
  Owner^.ReDraw;
End;

Procedure TMemoryMcView.Draw;
Var
  st     : String;
  Address: Word;
  br,br1 : Byte;

  Function GetDataAddressStr:String;
  Var
    st   : String;
    Data : Byte;
  Begin
    MemoryMc^.GetByte(Address,Data);
    st:=TransleteString(Data,Config.TypeViewSystem Or $10);
    While Length(St)<5 do st:=' '+st;
    GetDataAddressStr:=st;
  End;

Begin
  InitBuffer;
  MemoryMc^.CalcLastMemoryAddress;
  Address:=TopLeftAddress; br:=0;
  Repeat
    Str(Address:6,st);
    For br1:=1 to 5 Do If St[Br1]=' ' Then st[br1]:='0';
    SetBufferStr(0,br,st,1);
    For br1:=1 to NumByteOfLine Do
      Begin
        If Address<=MemoryMc^.LastMem Then st:=GetDataAddressStr else st:=' ';
        If MemoryMc^.GetChangeByte(Address) Then
          SetBufferStr((br1-1)*5+7,br,st,4)
            else SetBufferStr ((br1-1)*5+7,br,st,1);
        Inc(Address);
      End;
    Inc(br);
  until (br=Size.Y+1) Or (Address>=MemoryMc^.LastMem);
  TMyView.Draw;
End;

Procedure TMemoryMcWindow.Close;
Begin MemoryMcWindow:=Nil; TWindow.Close; End;

Constructor TRegistersMcWindow.Init;
Begin
  Bounds.Assign(Bounds.A.X, Bounds.A.Y, Bounds.A.X+16, Bounds.A.Y+10 );
  TWindow.Init(Bounds,ATitle,ANumber);
  Bounds.Assign(1,1,Size.X-1,Size.Y-1);
  RegistersView:=New(PRegistersMcView,Init(Bounds));
  Insert(RegistersView);
End;

Procedure TRegistersMcWindow.Close;
Begin RegistersMcWindow:=Nil; TWindow.Close; End;

Constructor TRegistersMcView.Init;
Begin
  TView.Init(Bounds);
  Selected:=1;
  Options:=Options Or ofPreProcess;
  GrowMode:=gfGrowHiX Or gfGrowHiY;
End;

Procedure TRegistersMcView.Draw;
Var
  st    : String;
  Color : Array[0..16] Of Byte;
  br    : Byte;

  Function GetRegisters(Num:Byte):String;
  Var
    st   : String;
    Reg  : Word;
    Tp   : Byte;
  Begin
    If Num= 1 Then Reg:=Register.A;
    If Num= 2 Then Reg:=Register.B;
    If Num= 4 Then Reg:=Register.IX;
    If Num= 8 Then Reg:=Register.SP;
    If Num=16 Then Reg:=Register.IP;
    Tp:=Config.TypeViewSystem;
    If Num In [ 4, 8,16] Then Tp:=(Tp And $0F) Or $20
      Else Tp:=(Tp And $0F) Or $10;
    st:=TransleteString(Reg,Tp);
    While Length(St)<6 do st:=' '+st;
    GetRegisters:=st;
  End;

Begin
  InitBuffer;
  For br:=1 to 16 Do Color[br]:=1;
  Color[Selected]:=4;
  st:='A  : '+GetRegisters( 1); SetBufferStr(1,0,st,Color[ 1]);
  st:='B  : '+GetRegisters( 2); SetBufferStr(1,1,st,Color[ 2]);
  st:='IX : '+GetRegisters( 4); SetBufferStr(1,2,st,Color[ 4]);
  st:='SP : '+GetRegisters( 8); SetBufferStr(1,3,st,Color[ 8]);
  st:='IP : '+GetRegisters(16); SetBufferStr(1,4,st,Color[16]);
  st:='';         SetBufferStr(0,5,st,Color[15]);
  st:='N=0'; If Register.N Then st[3]:='1'; SetBufferStr(1,6,st,Color[ 5]);
  st:='Z=0'; If Register.Z Then st[3]:='1'; SetBufferStr(5,6,st,Color[ 6]);
  st:='V=0'; If Register.V Then st[3]:='1'; SetBufferStr(9,6,st,Color[ 7]);
  st:='C=0'; If Register.C Then st[3]:='1'; SetBufferStr(1,7,st,Color[ 9]);
  st:='I=0'; If Register.I Then st[3]:='1'; SetBufferStr(5,7,st,Color[10]);
  st:='H=0'; If Register.H Then st[3]:='1'; SetBufferStr(9,7,st,Color[11]);
  TMyView.Draw;
End;

Procedure TRegistersMcView.HandleEvent(Var Event: TEvent);
Const
  Prv : Array[1..16] Of Byte=(11, 1, 0, 2,16, 5, 6, 4, 7, 9,10, 0,0,0,0, 8);
  Nxt : Array[1..16] Of Byte=( 2, 4, 0, 8, 6, 7, 9,16,10,11, 1, 0,0,0,0, 5);
Var
  P : TPoint;
  R : TRect;
  EV: TEvent;

  Procedure ChangeRegisters;
  Var
    D    : PDialog;
    I    : PInputLine;
    R    : TRect;
    S,Rgs: String;
    W,Rg : Word;
    Code : Integer;
  Begin
    If Selected In [1,2,4,8,16] Then Begin
      If Selected= 1 Then Begin Rg:=Register.A;  RgS:='A  :'; End;
      If Selected= 2 Then Begin Rg:=Register.B;  RgS:='B  :'; End;
      If Selected= 4 Then Begin Rg:=Register.IX; RgS:='IX :'; End;
      If Selected=16 Then Begin Rg:=Register.IP; RgS:='IP :'; End;
      If Selected= 8 Then Begin Rg:=Register.SP; RgS:='SP :'; End;
      

      R.Assign( 0, 0,29, 7);
      D:=New(PDialog,Init(R,'Change Registers'));
      D^.Options:=D^.Options Or ofCentered;

      R.Assign( 4, 4,14, 6);
      D^.Insert(New(PButton,Init(R,'~O~k',cmOk,bfDefault)));

      R.Assign(15, 4,25, 6);
      D^.Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));
              {13    33}
      R.Assign(14, 2,21, 3);
      I:=New(PInputLine,Init(R,5));

      Str(Selected,S);
               {1    18}
      R.Assign( 7, 2,12, 3);
      D^.Insert(New(PLabel,Init(R,RgS,I)));

      D^.Insert(I);

      Str(Rg,S);
      I^.SetData(S);

      If Application^.ValidView(D) <> nil Then
      Begin
        If Desktop^.ExecView(D) <> cmCancel Then
        Begin
          I^.GetData(S);
          While (Pos(' ',S)<>0) And (S<>'') Do Delete(S,Pos(' ',S),1);
          Val(S,W,Code);
          If Selected= 1 Then Register.A :=W;
          If Selected= 2 Then Register.B :=W;
          If Selected= 4 Then Register.IX:=W;
          If Selected= 8 Then Register.SP:=W;
          If Selected=16 Then Register.IP:=W;
        End;
        Dispose(D,Done);
      End;
    End
    else
    Case Selected Of
      5: Register.N:=Not Register.N;
      6: Register.Z:=Not Register.Z;
      7: Register.V:=Not Register.V;
      9: Register.C:=Not Register.C;
     10: Register.I:=Not Register.I;
     11: Register.H:=Not Register.H;
    End;
    If MemoryMcWindow <> Nil Then MemoryMcWindow^.ReDraw;
    If RegistersMcWindow <> Nil Then RegistersMcWindow^.ReDraw;
    if StackWindow<>Nil Then StackWindow^.ReDRaw;
  End;

  Procedure GetCurrentSetings;
  Begin
    If ((Event.What=evMouseDown) And (Event.Buttons=1)) And (MouseInView(Event.Where)) Then
      Begin
        MakeLocal ( Event.Where, p );
        R.Assign (0,0,Size.X,1); If R.Contains(p) Then Selected:= 1;
        R.Assign (0,1,Size.X,2); If R.Contains(p) Then Selected:= 2;
        R.Assign (0,2,Size.X,3); If R.Contains(p) Then Selected:= 4;
        R.Assign (0,3,Size.X,4); If R.Contains(p) Then Selected:= 8;
        R.Assign (0,4,Size.X,5); If R.Contains(p) Then Selected:=16;
        R.Assign (1,6,4     ,7); If R.Contains(p) Then Selected:= 5;
        R.Assign (5,6,8     ,7); If R.Contains(p) Then Selected:= 6;
        R.Assign (9,6,12    ,7); If R.Contains(p) Then Selected:= 7;
        R.Assign (1,7,4     ,8); If R.Contains(p) Then Selected:= 9;
        R.Assign (5,7,8     ,8); If R.Contains(p) Then Selected:=10;
        R.Assign (9,7,12    ,8); If R.Contains(p) Then Selected:=11;
      End;
  End;

Begin
  TView.HandleEvent(Event);
  Case Event.What Of
    evKeyDown   : Case Event.KeyCode Of
                    kbUp,kbLeft    : Selected:=Prv[Selected];
                    kbDown,kbRight : Selected:=Nxt[Selected];
                    kbEnter        : ChangeRegisters;
                    else Exit;
                  End;
    evMouseDown : Begin
                    GetCurrentSetings;
                    If Event.Double Then ChangeRegisters;
                  End;
  End;
  Owner^.ReDraw;
End;

Constructor TCPUMcView.Init(Bounds:TRect;Start:Word);
Begin
  TView.Init(Bounds); 
  Options:=Options Or ofPreProcess;
  GrowMode:=gfGrowHiX Or gfGrowHiY;
  InitPos(Start);
End;

Procedure TCPUMcView.CheckTopLeft;
Var
  A,B  : Word;
  AllY : Word;
  CY   : Integer;

  Procedure GetCenterDown;
  Var Min, Max : Word;
  Begin
    Min:=(Size.Y div 2)-2; Max:=(Size.Y div 2)+2;
    While not ((CY>Min) And (CY<Max)) Do
      Begin
        MemoryMc^.Disassembling(TopLeftAddress,Line,NumByte);
        CY:=CY-1; TopLeftAddress:=TopLeftAddress+NumByte;
      End;
  End;

  Procedure GetCenterUp;
  Var
    Min, Max : Word;
    Stack    : array[1..25] Of Byte;
    Item, C  : Byte;
    B, D, Y  : Byte;
  Begin
    For C:=1 to SizeOf(Stack) Do Stack[C]:=0; Item:=0;
    Min:=(Size.Y div 2)-1; Max:=(Size.Y div 2)+1;
    A:=MemoryMc^.BeginMemPRG;
    While A<CurrentAddress Do
      Begin
        MemoryMc^.Disassembling(A,Line,NumByte);
        A:=A+NumByte;
        Move(Stack[2],Stack[1],SizeOf(Stack)-1);
        Stack[SizeOf(Stack)]:=NumByte; Inc(Item);
      End;
    y:=0; B:=0;
    While not ((Y>Min) And (Y<Max)) And (Item<>0) Do
      Begin
        D:=Stack[SizeOf(Stack)];
        For C:=SizeOf(Stack) Downto 2 Do Stack[C]:=Stack[C-1];
        Stack[1]:=0; Dec(Item); B:=B+D; inc(Y);
      End;
    TopLeftAddress:=A-B;
  End;

Begin
  A:=TopLeftAddress; AllY:=0; CY:=0;
  While AllY<=Size.Y Do
    Begin
      MemoryMc^.Disassembling(A,Line,NumByte);
      If A=CurrentAddress Then CY:=ALLY;
      A:=A+NumByte; inc(AllY);
    End;
  If CY = Size.Y Then GetCenterDown;
  If CY = 0      Then GetCenterUp;
End;

Procedure TCPUMcView.HandleEvent(Var Event: TEvent);

  Procedure IncLine;
  Begin
    MemoryMc^.Disassembling(CurrentAddress,Line,NumByte);
    CurrentAddress:=CurrentAddress+NumByte;
    CheckTopLeft; ClearEvent(Event); Owner^.ReDraw;
  End;

  Procedure DecLine;
  Var
    Add    : Word;
    OldAdd : Word;
  Begin
    Add:=MemoryMc^.BeginMemPRG; OldAdd:=Add;
    While Add<CurrentAddress Do
      Begin
        MemoryMc^.Disassembling(Add,Line,NumByte);
        OldAdd:=Add;
        Add:=ADD+NumByte;
      End;
    CurrentAddress:=OldAdd;
    CheckTopLeft;
    ClearEvent(Event);
    Owner^.ReDraw;
  End;

Begin
  Case Event.What Of
   evCommand : Case Event.Command Of
      cmStepCalcView,
      cmStepCalc,
      cmStepView : Begin
                     CurrentAddress:=MemoryMc^.DebugAddress;
                     CheckTopLeft;
                     VScroll^.Value:=TopLeftAddress;
                     case Event.Command of
                       cmStepCalcView, cmStepView : {if (State and sfActive)=0 then}
                         Owner^.ReDraw;
                     end;
                     If TimeWindow<>Nil Then
                       TimeWindow^.TimeView^.HandleEvent(Event);
                     Exit;
                   End;
    End;
  End;
  TView.HandleEvent(Event);
  Case Event.What Of
   evKeyDown : Case Event.KeyCode Of
                 kbDown : IncLine;
                 kbUp   : DecLine;
                 else Exit;
               End;
   evCommand : Case Event.Command Of
                 cmSetBreakPointer : Begin
                                       If BreakPointer.ValidPointer ( CurrentAddress )
                                         Then BreakPointer.FreePointer ( CurrentAddress )
                                           else BreakPointer.SetPointer ( CurrentAddress );
                                       ClearEvent(Event);
                                     End;
               End;
   evMessage : Begin
                 If Event.Command=cmDisError Then Dissasembling:=False;
                 ClearEvent(Event);
               End;
  End;
  VScroll^.Value:=TopLeftAddress;
End;

Procedure TCPUMcView.Draw;
Var
  Y       : Byte;
  Address : Word;
  Color   : Byte;
Begin
  InitBuffer;
  Y:=0;
  Address:=TopLeftAddress;
  Dissasembling:=True;
  Color:=GetColor(1);
  While (Y<Size.Y) And Dissasembling Do Begin
    MemoryMc^.Disassembling(Address,Line,NumByte);
    While Length(Line)<Size.X do Line:=Line+' ';
    Color:=1;
    If BreakPointer.ValidPointer(Address) Then Color:=3;
    If MemoryMc^.Debug Then
      Begin
        If Address=CurrentAddress Then Color:=2;
        If Address=MemoryMc^.DebugAddress Then Color:=4;
      End
      else
        If Address=CurrentAddress Then Color:=2;
    SetBufferStr(0,Y,Line,Color); inc(Y);
    Address:=Address+NumByte;
  End;
  ScreenViewAddress:=Register.IP-ScreenViewAddress;
  TMyView.Draw;
End;

Function TCPUMcView.GetPalette;
const
  P: string[Length(CCPUView)]=CCPUView;
Begin
  GetPalette:=@P;
End;

Procedure TCPUMcView.InitPos(Start:Word);
begin TopLeftAddress:=Start; CurrentAddress:=Start; MemoryMc^.Debug:=false; end;

Constructor TCPUMcWindow.Init(Var Bounds: TRect; ATitle: TTitleStr; ANumber: Integer;Start:Word);
Begin
  Bounds.B.X:=Bounds.B.X-21;
  TWindow.Init(Bounds,ATitle,ANumber );
  Bounds.Assign( 1, 1,Size.X-1,Size.Y-1);
  CPUView:=New(PCPUMcView,Init(Bounds,Start)); Insert(CPUView);
  CPUView^.VScroll:=StandardScrollBar(sbVertical+sbHandleKeyboard);
  MemoryMc^.CalcLastMemoryAddress;
  CPUView^.VScroll^.SetRange( 0,MemoryMc^.LastMem);
  CPUView^.VScroll^.SetStep( 0, 0);
End;


Procedure TCPUMcWindow.Close;
Begin
  CPUMcWindow:=Nil; TWindow.Close;
End;

Function TCPUMcWindow.GetPalette;
const
  P : array[wpBlueWindow..wpGrayWindow] Of string[Length(CBlueWindow)+Length(CCPUWindow)] =
    (CBlueWindow+CCPUWindow, CCyanWindow+CCPUWindow, CGrayWindow+CCPUWindow);
Begin
  GetPalette:=@P[Palette];
End;

Constructor TTimeWindow.Init;
Begin
  MinWinSize.X:=16; MinWinSize.Y:=4;
  Bounds.Assign(Bounds.B.X-18,Bounds.B.Y-12,Bounds.B.X-2,Bounds.B.Y-8);
  TWindow.Init(Bounds,ATitle,ANumber);
  Bounds.Assign(1,1,Size.X-1,Size.Y-1);
  TimeView:=New(PTimeView,Init(Bounds)); Insert(TimeView);
  TimeView^.AllTime:=0; TimeView^.Calc;
  GrowMode:=gfGrowHiX Or gfGrowHiY;
End;

Procedure TTimeWindow.Close;
Begin
  TimeWindow:=Nil; TWindow.Close;
End;

Procedure TTimeView.Clear;
Begin
  AllTime:=0; Time:=MemoryMc^.GetTime;
  Command_:=Command[MemoryMc^.Comm].Name;
  Owner^.ReDraw;
End;

Constructor TTimeView.Init(Bounds:TRect);
Begin TView.Init(Bounds); GrowMode:=gfGrowHiX Or gfGrowHiY; End;

Procedure TTimeView.Calc;
Begin
  AllTime:=AllTime+Time; Time:=MemoryMc^.GetTime;
  Command_:=Command[MemoryMc^.Comm].Name;
End;

Procedure TTimeView.HandleEvent(Var Event:TEvent);
Begin
  TView.HandleEvent(Event);
  Case Event.What Of
    evCommand: Case Event.Command Of
                 cmStepCalc     : Calc;
                 cmStepView     : Owner^.ReDraw;
                 cmStepCalcView : begin Calc; Owner^.ReDraw; end;
                 cmClearDebuger : Clear;
               End;
  End;
End;

Procedure TTimeView.Draw;
Var
  S,T : String;
Begin
  InitBuffer;
  S:=Command_; S:=' '+S;
  If Ord(S[0])<5 Then S:=S+' '; Str(Time:5,T);
  S:=S+' : '+T;            SetBufferStr( 0, 0, S, 1);
  Str(AllTime:5,S);
  S:=' Total: '+S;         SetBufferStr( 0, 1, S, 1);
  TMYView.Draw;
End;

Constructor TStackWindow.Init;
Begin
  Bounds.Assign(Bounds.B.X-18,Bounds.B.Y-7,Bounds.B.X-2,Bounds.B.Y);
  TWindow.Init(Bounds,ATitle,ANumber);
  Bounds.Assign(1,1,Size.X-1,Size.Y-1);
  StackView:=New(PStackView,Init(Bounds)); Insert(StackView);
End;

Procedure TStackWindow.Close;
Begin StackWindow:=Nil; TWindow.Close; End;

Constructor TStackView.Init(Bounds:TRect);
Begin TView.Init(Bounds);
  GrowMode:=gfGrowHiX Or gfGrowHiY;
  EventMASK := evCommand;
  Options:=Options or ofPostProcess or ofPreProcess;
End;

Procedure TStackView.Clear;
Begin Owner^.ReDraw; End;

Procedure TStackView.HandleEvent(Var Event:TEvent);
Begin
  TView.HandleEvent(Event);
  Case Event.What Of
    evCommand: Case Event.Command Of
                 cmStepView, cmStepCalcView,
                 cmStackDraw: Owner^.ReDraw;
               End;
  End;
End;

Procedure TStackView.Draw;
Var A,S : String;
    B   : Byte;

  Function SetSpace(S :String):String;
  begin
  While Length(S)<3 do
    S := ' '+S;
    SetSpace:=S;
  end;

Begin
  InitBuffer;
  MemoryMC^.GetByte ( Register.SP-2, b);
  A:=TransleteString(Register.SP-2, tt_HEX Or tt_Word );
  S:=TransleteString(b, Config.TypeViewSystem Or tt_Byte );
  S:=SetSpace(S); S:='  '+A+' : '+S; 
  SetBufferStr( 0, 0, S, 1);
  MemoryMC^.GetByte(Register.SP-1,b);
  A:=TransleteString(Register.SP-1, tt_HEX Or tt_Word );
  S:=TransleteString(b, Config.TypeViewSystem Or tt_Byte );
  S:=SetSpace(S); S:='  '+A+' : '+S;
  SetBufferStr( 0, 1, S, 1);
  MemoryMC^.GetByte(Register.SP,b );
  A:=TransleteString(Register.SP, tt_HEX Or tt_Word );
  S:=TransleteString(b,Config.TypeViewSystem Or tt_Byte );
  S:=SetSpace(S); S:=#16+' '+A+' : '+S+' '+#17;
  SetBufferStr( 0, 2, S, 1);
  MemoryMC^.GetByte(Register.SP+1,b);
  A:=TransleteString(Register.SP+1, tt_HEX Or tt_Word );
  S:=TransleteString(b, Config.TypeViewSystem Or tt_Byte );
  S:=SetSpace(S); S:='  '+A+' : '+S;
  SetBufferStr( 0, 3, S, 1);
  MemoryMC^.GetByte(Register.SP+2,b);
  A:=TransleteString(Register.SP+2, tt_HEX Or tt_Word );
  S:=TransleteString(b, Config.TypeViewSystem Or tt_Byte );
  S:=SetSpace(S); S:='  '+A+' : '+S;
  SetBufferStr( 0, 4, S, 1);
  TMYView.Draw;
End;

Begin
  MemoryMcWindow    := Nil;
  RegistersMcWindow := Nil;
  CPUMcWindow       := Nil;
  TimeWindow        := Nil;
  StackWindow       := Nil;
End.