Unit McUnit;

Interface

Uses Objects, McConst, App, Drivers, Crt;

Type
  PWord=^Word;

  PRegistersMc=^TRegistersMc;
  TRegistersMc=Record
    A,B               : Byte;
    IX,SP,IP          : Word;
    RetAddr           : Word;
    N,Z,V,C,I,H       : Boolean;
  End;

  PMcConfig=^TMcConfig;
  TMcConfig=Record
    TypeViewSystem: Byte;
    FileNameProgram,
    FileNameData: String;
  End;

  PBytesBlock=^TBytesBlock;
  TBytesBlock=Array[0..$3FF] of Byte;

  PBufferByte=^TBufferByte;
  TBufferByte=Object(TCollection)
    Bytes    : Word;
    NumBlock : Word;
    Constructor Init  (ABytes:Word);
    Procedure FreeItem(Item:Pointer); Virtual;
    Procedure SetByte (Address:Word; Data:Byte);
    Procedure GetByte (Address:Word; Var Data:Byte);
{    Procedure SetWord (Address:Word; Data:Word);
    Procedure GetWord (Address:Word; Var Data:Word);
}    Procedure ClearBuffer;
  End;

  PMemoryMc=^TMemoryMc;
  TMemoryMc=Object(TBufferByte)
    ChangeByte          : PBufferByte;
    OldRegisters        : TRegistersMc;
    LastMem,BeginMemPrg : Word;
    EndMemPrg,LongPrg   : Word;
    DebugAddress        : Word;
    Destination_Address : Word;
    AddressData         : Word;
    Comm                : Byte;
    Debug               : Boolean;
    FileAsm, FileData   : String;
    Constructor Init;
    Destructor Done; Virtual;
    Procedure CalcLastMemoryAddress;
    Procedure ReadFile(FileName: String; Address:Word);
    Procedure ReadData(FileName: String; Address:Word);
    Procedure ReadLx(FileName: String; Var Address:Word);
    Procedure ClearChangeByte;
    Procedure ClearDebuger;
    Procedure StartDebuger;
    Procedure SetChangeByte(Address:Word);
    Function  GetChangeByte(Address:Word): Boolean;
    Procedure SaveRegisters;
    Procedure UndoRegisters;
    Procedure GetCommand;

    Function  Dissas_Op(Address:Word; var NumByte:Byte):String;
    Procedure Disassembling(Address:Word; Var Line: String; Var NumBytes: Byte);

    Procedure Handle_Command;

    Procedure Step;
    Function  GetTime:Word;
    Function  CommandTime(AComm:Byte):Word;
  End;

  PBreakPointer = ^TBreakPointer;
  TBreakPointer = Object(TCollection)
    Constructor Init;
    procedure   FreeItem     (Item: Pointer); Virtual;
    Procedure   SetPointer   (Address: Word);
    Procedure   FreePointer  (Address: Word);
    Procedure   ClearAll;
    Function    ValidPointer (Address: Word): Boolean;
    Function    FindPointer  (Address: Word): Integer;
  End;

Var MemoryMc     : PMemoryMc;
    Config       : TMcConfig;
    Register     : TRegistersMc;
    BreakPointer : TBreakPointer;

Function  TransleteWord   (St: String): Word;
Function  TransleteString (Data: Word; Types: Byte): String;
Procedure DoneUnit;
Procedure InitUnit;

Implementation

Function TransleteWord;
Var Err   : Integer;
    Br,Ls : Byte;
    NewW  : Word;
Begin
  While (Pos(' ',St)<>0) and (St<>'') do Delete (St,Pos(' ',St),1);
  NewW:=0;
  case UpCase (st[Length(St)]) of
   '0'..'9' : Val(St,NewW,Err);
        'H' : Begin
                Dec(St[0]); Ls:=Length(St);
                For Br:=1 to Ls do
                  NewW:=NewW+(Pos(St[Ls-Br+1],Hex)-1)*($1 Shl (4*(br-1)));
              End;
        'O' : Begin
                Dec(St[0]); Ls:=Length(St);
                For Br:=1 to Ls Do
                  NewW:=NewW+(Pos(St[Ls-Br+1],Hex)-1)*($1 Shl (3*(Br-1)));
              End;
  End;
  TransleteWord:=NewW;
End;

Function  TransleteString(Data:Word; Types:Byte):String;
Var
  St : String;
Begin
  st:='';
  case (Types and tt_Mask_System) of
    tt_DEC : Begin
               If (Types And tt_Mask_Size)=$10 Then str(Data,st);
               If (Types And tt_Mask_Size)=$20 Then str(Data,st);
               If Data=0 Then St:='0';
             End;
    tt_HEX : Begin
               st:=HEX[(Data and $000F)+1];
               st:=HEX[((Data and $00F0) shr 4)+1]+st;
               if (Types And tt_Mask_Size)=$20 Then
                 Begin
                   st:=HEX[((Data and $0F00) shr  8)+1]+st;
                   st:=HEX[((Data and $F000) shr 12)+1]+st;
                 End;
             End;
    tt_OCT : Begin
               st:=OCT[ (Data and $00007)+1];
               st:=OCT[((Data and $00038) shr 3)+1]+st;
               if (Types and tt_Mask_Size)=$10 Then
                 st:=OCT[((Data and $000C0) shr 6)+1]+st
                 Else
                 Begin
                   st:=OCT[((Data and $01C0) shr  6)+1]+st;
                   st:=OCT[((Data and $0E00) shr  9)+1]+st;
                   st:=OCT[((Data and $7000) shr 12)+1]+st;
                   st:=OCT[((Data and $8000) shr 15)+1]+st;
                 End;
             End;
  End;
  TransleteString:=st;
End;

Constructor TBufferByte.Init;
Var
  Block  : PBytesBlock;
  br     : Word;
Begin
  TCollection.Init(ABytes div $400+1,1);
  Bytes:=ABytes;
  NumBlock:=Bytes div $400+1;
  for br:=0 to NumBlock do Begin New(Block); Insert(Block); End;
  ClearBuffer;
End;

Procedure TBufferByte.ClearBuffer;
Var
  Block : PBytesBlock;
  br    : Integer;
Begin
  for br:=0 to NumBlock do
    Begin Block:=At(br); FillChar(Block^,SizeOf(Block^),#00); End;
End;

Procedure TBufferByte.FreeItem(Item :Pointer);
Begin
  if Item <> Nil Then Dispose(PBytesBlock(Item));
End;

Procedure TBufferByte.SetByte(Address:Word; Data:Byte);
Var
  NBlock, NByte : Word;
  Block         : PBytesBlock;
Begin
  if Address<=Bytes Then
    Begin
      NBlock:=Address div $400; NByte:=Address Mod $400;
      Block:=At(NBlock); Block^[NByte]:=Data;
    End;
End;

Procedure TBufferByte.GetByte(Address:Word; Var Data:Byte);
Var
  NBlock, NByte : Word;
  Block         : PBytesBlock;
Begin
  if Address<=Bytes Then
    Begin
      NBlock:=Address div $400; NByte:=Address Mod $400;
      Block:=At(NBlock); Data:=Block^[NByte];
    End else Data:=0;
End;
{
Procedure TBufferByte.SetWord(Address:Word; Data:Word);
Var
  NBlock, NByte : Word;
  Block         : PBytesBlock;
Begin
  if Address <= Bytes Then
    Begin
      NBlock:=Address div $400; NByte:=Address Mod $400;
      if NByte<$3ff Then
        Begin
          Block:=At(NBlock);
          Block^[NByte+1]:=Data shr 8; Block^[NByte]:=Data and $FF;
        End;
    End
    Else
    Begin
      Block:=At(NBlock  ); Block^[NByte]:= Data and $FF;
      Block:=At(NBlock+1); Block^[0]    := Data shr 8;
    End;
End;

Procedure TBufferByte.GetWord(Address:Word; Var Data:Word);
Var
  NBlock, NByte : Word;
  Block         : PBytesBlock;
Begin
  if Address<Bytes Then
    Begin
      NBlock:=Address div $400; NByte:=Address Mod $400;
      if NByte<$3ff Then
        Begin
          Block:=At(NBlock);
          Data:=Block^[NByte+1]*$100+Block^[NByte];
    End
    Else
    Begin
      Block:=At(NBlock  ); Data:=Block^[NByte];
      Block:=At(NBlock+1); Data:=Data+Block^[0]*100;
    End;
  End else Data:=0;
End;
}
Constructor TBreakPointer.Init;
Begin
  TCollection.Init(100, 10);
End;

procedure TBreakPointer.FreeItem(Item:Pointer);
Begin
  if Item<>Nil Then Dispose(PWord(Item));
End;

Procedure TBreakPointer.SetPointer(Address:Word);
Var
  Ptr : PWord;
Begin
  if Not ValidPointer(Address) Then
    Begin New(Ptr); Ptr^:=Address; Insert(Ptr); End;
End;

Procedure TBreakPointer.FreePointer(Address: Word);
Var
  Index : Integer;
Begin
  index:=FindPointer(Address);
  if not (Index=-1) Then Free (At(Index));
End;

Function TBreakPointer.ValidPointer;
Begin
  if FindPointer(Address)=-1 Then ValidPointer:=False
    else ValidPointer:=True;
End;

Function TBreakPointer.FindPointer(Address:Word):Integer;
Var
  W : Integer;
Begin
  FindPointer:=-1;
  for W:=0 to Count-1 do if Address=PWord(At(W))^ Then FindPointer:=W;
End;

Procedure TBreakPointer.ClearAll;
Begin FreeAll; End;

Procedure DoneUnit;
Begin
  Dispose(MemoryMc,Done);
  BreakPointer.Done;
End;

Procedure InitUnit;
Begin
  MemoryMc:=New(PMemoryMc,Init);
  BreakPointer.Init;
  Config.FileNameProgram:='';
  Config.FileNameData:='';
  Config.TypeViewSystem:=tt_DEC;
  Register.A:=0;  Register.B:=0;
  Register.IX:=0; Register.SP:=0; Register.IP:=0;
  Register.N:=False; Register.Z:=True;  Register.I:=False;
  Register.V:=False; Register.C:=False; Register.H:=False;
End;


Constructor TMemoryMc.Init;
Begin
  TBufferByte.Init(LimitMemoryMc);
  ChangeByte:=New(PBufferByte,Init((LimitMemoryMc div 8)+1));
End;

Destructor TMemoryMc.Done;
Begin
  Dispose(ChangeByte,Done);
  TBufferByte.Done;
End;

Procedure TMemoryMc.CalcLastMemoryAddress;
Begin
  LastMem:=(Count*$400)-1;
End;

Procedure TMemoryMc.ReadFile(FileName:String; Address:Word);
Var
  F      : File;
  Block  : TBytesBlock;
  RBlock : Word;
  br     : Word;
Begin
  FileAsm:=FileName;
  BeginMemPrg:=Address;
  Assign(F,FileName); Reset(F,1);
  LongPrg:=0;
  While Not(EOF(F)) do
    Begin
      BlockRead(F,Block,SizeOf(Block),RBlock );
      LongPRG:=LongPRG+RBlock;
      for br:=0 to RBlock-1 do
        Begin SetByte(Address,Block[br]); Inc(Address); End;
    End;
  Close(F);
  EndMemPRG:=BeginMemPRG+LongPRG-1;
End;

Procedure TMemoryMc.ReadLx(FileName:String; Var Address:Word);
Var
  F                 : File of Char;
  Name              : String;
  Ch                : Char;
  N1,N2,N3          : Byte;
  Len,Bt,Sum        : Byte;
  FstAddr,LstAddr   : LongInt;
  Addr              : LongInt;
  I                 : Integer;

  Function GetB:Byte;
  Var
    N1,N2: Byte;
  Begin
    Read(F,Ch);
    If (Ch>='0') And (Ch<='9') Then N1:=Ord(Ch)-48
      Else If (Ch>='a') And (Ch<='z') Then N1:=Ord(Ch)-87
        Else If (Ch>='A') And (Ch<='Z') Then N1:=Ord(Ch)-55;
    Read(F,Ch);
    If (Ch>='0') And (Ch<='9') Then N2:=Ord(Ch)-48
      Else If (Ch>='a') And (Ch<='z') Then N2:=Ord(Ch)-87
        Else If (Ch>='A') And (Ch<='Z') Then N2:=Ord(Ch)-55;
    GetB:=N2+16*N1;
  End;

Begin
  FileAsm:=FileName; LstAddr:=0; Name:=FileName; BeginMemPrg:=Address;
  Assign (F,FileName); {$I-} Reset(F); {$I+}
  While Not Eof(F) Do
    Begin
      Ch:=' '; Sum:=0;
      While (Ch<>'S') And Not EOF(F) Do Read(F,Ch);
      Read(F,Ch);
      Case Ch Of
        '0' : Begin
                Len:=GetB; N1:=GetB; N2:=GetB; FstAddr:=N2+256*N1; Addr:=FstAddr;
                For I:=1 To (Len-3) Do
                Begin Bt:=GetB; SetByte(Addr,Bt); Inc(Addr); End;
                Sum:=GetB;
              End;
        '1' : Begin
                Len:=GetB; N1:=GetB; N2:=GetB; Addr:=N2+256*N1;
                For I:=1 To (Len-3) Do
                Begin Bt:=GetB; SetByte(Addr,Bt); Inc(Addr); End;
                Sum:=GetB;
              End;
        '2' : Begin
                Len:=GetB; N1:=GetB; N2:=GetB; N3:=GetB;
                Addr:=N3+256*N2+65536*N1;
                For I:=1 To (Len-4) Do
                Begin Bt:=GetB; SetByte(Addr,Bt); Inc(Addr); End;
                Sum:=GetB;
              End;
        '8' : Begin
                Len:=GetB; N1:=GetB; N2:=GetB; Addr:=N2+256*N1;
                For I:=1 To (Len-3) Do
                Begin Bt:=GetB; SetByte(Addr,Bt); Inc(Addr); End;
                Sum:=GetB;
              End;
        '9' : Begin
                Len:=GetB; N1:=GetB; N2:=GetB; N3:=GetB;
                Addr:=N3+256*N2+65536*N1;
                For I:=1 To (Len-4) Do
                Begin Bt:=GetB; SetByte(Addr,Bt); Inc(Addr); End;
                Sum:=GetB;
              End;
      End;
      If Addr<FstAddr Then FstAddr:=Addr;
      If Addr>LstAddr Then LstAddr:=Addr;
    End;
  Close(F);
  BeginMemPRG:=FstAddr; EndMemPRG:=LstAddr;
  LongPRG:=EndMemPRG-BeginMemPRG; Address:=BeginMemPRG;
End;


Procedure TMemoryMc.ReadData(FileName:String; Address:Word);
Var
  F      : File;
  Block  : TBytesBlock;
  RBlock : Word;
  br     : Word;
Begin
  FileData:=FileName; AddressData:=Address;
  Assign(F,FileName); Reset(F,1);
  While Not(EOF(F)) do
    Begin
      BlockRead(F,Block,SizeOf(Block),RBlock);
      LongPRG:=LongPRG+RBlock;
      for br:=0 to RBlock-1 do
        Begin SetByte(Address,Block[br]); Inc(Address); End;
    End;
  Close(F);
  ChangeByte^.ClearBuffer;
End;

Procedure TMemoryMc.SaveRegisters;
Begin
  OldRegisters:=Register;
End;

Procedure TMemoryMc.UndoRegisters;
Begin
  Register:=OldRegisters;
End;

Procedure TMemoryMc.ClearChangeByte;
Begin
  ChangeByte^.ClearBuffer;
End;

Procedure TMemoryMc.SetChangeByte(Address:Word);
Var
  Data : Byte;
  Flag : Byte;
Begin
  Flag:=1 shl (Address Mod 8); Address:=Address div 8;
  ChangeByte^.GetByte(Address,Data);
  Data:=Data or Flag;
  ChangeByte^.SetByte(Address,Data);
End;

Function  TMemoryMc.GetChangeByte(Address:Word):Boolean;
Var
  Data : Byte;
  Flag : Byte;
Begin
  Flag:=1 shl (Address Mod 8); Address:=Address div 8;
  ChangeByte^.GetByte(Address,Data);
  If (Data and Flag)=0 Then GetChangeByte:=False else GetChangeByte:=True;
End;

Procedure TMemoryMc.GetCommand;
Begin
  GetByte(Register.IP,Comm); Inc(Register.IP);
End;

Procedure TMemoryMc.Disassembling;
begin
  SaveRegisters; Register.IP:=Address; GetCommand;
  Line:=TransleteString(Address,tt_Word or Config.TypeViewSystem);
  While Length(Line)<6 do Line:='0'+Line;
  Line:=Line+'  '+TransleteString(Comm,tt_Byte or tt_Hex);       {???????????????}
  Line:=Line+Dissas_Op(Address+1,NumBytes);
  NumBytes:=NumBytes+1; UndoRegisters;
end;

Procedure TMemoryMc.Step;
Begin
  Handle_Command;
  DebugAddress:=Register.IP;
End;

Function TMemoryMc.Dissas_Op;
Var
  Offset_ : Byte;
  Add     : Word;
  br      : Byte;
  SOut,St : String;
  OpStr   : String;
  brReg   : Word;

  Function Dis_Mode(Var Op:String):String;
  Var
    B,Ml,Mh   : Byte;
    SOut,AdS  : String;
    W,RlAdd   : Word;
    Add       : Integer;
  Begin
    Case Command[Comm].T_Add of
      Imm: Begin
             If Command[Comm].N_Op=1 Then
               Begin
                 GetByte(BrReg,B); Inc(BrReg);
                 Op:=TransleteString(B,tt_Byte or tt_Hex)+'  ';
                 SOut:='#'+TransleteString(B,tt_Byte or Config.TypeViewSystem);
               End
               Else
               Begin
                 GetByte(BrReg,Mh); Inc(BrReg); GetByte(BrReg,Ml); Inc(BrReg);
                 W:=Ml+256*Mh; Op:=TransleteString(W,tt_Word or tt_Hex);
                 SOut:='#'+TransleteString(W,tt_Word or Config.TypeViewSystem);
               End;
           End;
      Dir: Begin
             GetByte(BrReg,B); Inc(BrReg);
             Op:=TransleteString(B,tt_Byte or tt_Hex)+'  ';
             SOut:=TransleteString(B,tt_Byte or Config.TypeViewSystem);
           End;
      Ind: Begin
             GetByte(BrReg,B); Inc(BrReg);
             Op:=TransleteString(B,tt_Byte or tt_Hex)+'  ';
             SOut:=TransleteString(B, tt_Byte or Config.TypeViewSystem)+',X';
           End;
      Ext: Begin
             GetByte(BrReg,Mh); Inc(BrReg); GetByte(BrReg,Ml); Inc(BrReg);
             W:=Ml+256*Mh; Op:=TransleteString(W,tt_Word or tt_Hex);
             SOut:=TransleteString(W, tt_Word or Config.TypeViewSystem);
           End;
      Imp: Begin SOut:='';  Op:='    '; End;
      Rel: Begin
             GetByte(BrReg,B); Inc(BrReg);
             Op:=TransleteString(B,tt_Byte or tt_Hex)+'  ';
             If (B And $80)>0 Then Add:=-((NOT B)+1) Else Add:=B;
             RlAdd:=Register.IP+Add+1; AdS:=TransleteString(RlAdd, tt_Word or Config.TypeViewSystem);
             SOut:=TransleteString(B, tt_Byte or Config.TypeViewSystem)+'    ---> '+AdS;
           End;
    End;
    Dis_Mode:=SOut;
  End;

Begin
  BrReg:=Address;
  SOut:=Command[Comm].Name+' ';
  If Command[Comm].N_Op=0 Then DissAs_Op:='        '+SOut
    Else Begin St:=Dis_Mode(OpStr); DissAs_Op:=OpStr+'    '+SOut+' '+St; End;
  NumByte:=BrReg-Address;
End;

Procedure TMemoryMc.Handle_Command;
Var
  Reg,Mode,Len,Rg,Md,Ml  : Byte;
  Int_Op,Dm,Dr,Aux,Mh    : Byte;
  Op                     : WORD;
  M,AuxW                 : Word;

  Function Get_Op(Mode:Code_Type; Len,Acc:Byte):Word;
  Var
    B     : Byte;
    W,Add : Word;
  Begin
    Case Mode Of
      Imm: Begin
             If (Acc=1) Or (Acc=2) Or (Acc=3) Then
               Begin GetByte(Register.IP,B); Inc(Register.IP); Get_Op:=B; End;
             If (Acc=4) Or (Acc=8) Or (Acc=12) Then
               Begin
                 GetByte(Register.IP,Mh); Inc(Register.IP);
                 GetByte(Register.IP,Ml); Inc(Register.IP);
                 Get_Op:=Ml+256*Mh;
               End;
           End;
      Dir: Begin
             GetByte(Register.IP,B); Inc(Register.IP); Add:=B;
             Register.RetAddr:=B;
             If (Acc=1) Or (Acc=2) Or (Acc=3) Then
               Begin GetByte(Add,B); Get_Op:=B; End;
             If (Acc=4) Or (Acc=8) Or (Acc=12) Then
               Begin
                 GetByte(Add,Mh); GetByte(Add+1,Ml);
                 Get_Op:=Ml+256*Mh;
               End;
           End;
      Ind: Begin
             GetByte(Register.IP,B); Inc(Register.IP); Add:=B;
             Register.RetAddr:=Register.IX+Add;
             If (Acc=1) Or (Acc=2) Or (Acc=3) Then
               Begin GetByte(Register.IX+Add,B); Get_Op:=B; End;
             If (Acc=4) Or (Acc=8) Or (Acc=12) Then
               Begin
                 GetByte(Register.IX+Add,Mh);
                 GetByte(Register.IX+Add+1,Ml);
                 Get_Op:=Ml+256*Mh;
               End;
           End;
      Ext: Begin
             GetByte(Register.IP,Mh); Inc(Register.IP);
             GetByte(Register.IP,Ml); Inc(Register.IP);
             Add:=Ml+256*Mh;
             Register.RetAddr:=Add;
             If (Acc=1) Or (Acc=2) Or (Acc=3) Or (Acc=0) Then
               Begin GetByte(Add,B); Get_Op:=B; End;
             If (Acc=4) Or (Acc=8) Or (Acc=12) Then
               Begin
                 GetByte(Add,Mh);
                 GetByte(Add+1,Ml);
                 Get_Op:=Ml+256*Mh;
               End;
           End;
      Rel: Begin
             GetByte(Register.IP,B); Inc(Register.IP);
             Get_Op:=B;
           End;
    End;
  End;

  Procedure Test_Res(Res:Word; FH,FI,FN,FZ,FV,FC:Char);
  Var
    BW,H,I  : Byte;
    N,Z,V,C : Byte;
  Begin
    If Res<256 Then BW:=1 Else BW:=0;    {BW=0 ==> Word;  BW=1 ==> Byte}
    ASM
          MOV  AL,$01
          MOV  H,AL
          MOV  N,AL
          MOV  Z,AL
          MOV  AX,Res
          MOV  BL,BW
          OR   BL,BL
          JZ   @0
          OR   AL,AL
          JMP  @1
      @0: OR   AX,AX
      @1: JS   @2
          MOV  N,$00
      @2: JZ   @3
          MOV  Z,$00
      @3: JO   @4
          MOV  V,$00
      @4: JC   @5
          MOV  C,$00
      @5: JA   @6
          MOV  H,$00
      @6:
    End;
    Case FH of
      'S': Register.N:=True;
      'R': Register.N:=False;
      '*': ;
      '|': If H=1 Then Register.N:=True Else Register.N:=False;
    End;
    Case FI of
      'S': Register.I:=True;
      'R': Register.I:=False;
      '*': ;
      '|': If I=1 Then Register.I:=True Else Register.I:=False;
    End;
    Case FN of
      'S': Register.N:=True;
      'R': Register.N:=False;
      '*': ;
      '|': If N=1 Then Register.N:=True Else Register.N:=False;
      '9','7': If (Res And $8000)<>0 Then Register.N:=True
             Else Register.N:=False;
    End;
    Case FZ of
      'S': Register.Z:=True;
      'R': Register.Z:=False;
      '*': ;
      '|': If Z=1 Then Register.Z:=True Else Register.Z:=False;
    End;
    Case FV of
      'S': Register.V:=True;
      'R': Register.V:=False;
      '*': ;
      '1': If Res=$80 Then Register.V:=True Else Register.V:=False;
      '4': If (Res+1)=$80 Then Register.V:=True Else Register.V:=False;
      '5': If (Res-1)=$7F Then Register.V:=True Else Register.V:=False;
      '6': IF (Register.C And (N=1)) Or (Register.C And (N=0)) Then
              Register.V:=False Else Register.V:=True;
      '8': ; {??????????????????????????????????????????????????????}
    End;
    Case FC of
      'S': Register.C:=True;
      'R': Register.C:=False;
      '*': ;
      '2': If Res=0 Then Register.C:=True Else Register.C:=False;
      '3': If ((Res And $F0) Shr 4)>9 Then Register.C:=True;
    End;
  End;

Begin
  GetCommand;
  If Command[Comm].N_Op=0 Then
    Begin
      Case Comm of
          $01 : ;                                                    { NOP  }
          $06 : Begin                                                { TAP  }
                  If (Register.A And $20)<>0 Then Register.H:=True
                    Else Register.H:=False;
                  If (Register.A And $10)<>0 Then Register.I:=True
                    Else Register.I:=False;
                  If (Register.A And $08)<>0 Then Register.N:=True
                    Else Register.N:=False;
                  If (Register.A And $04)<>0 Then Register.Z:=True
                    Else Register.Z:=False;
                  If (Register.A And $02)<>0 Then Register.V:=True
                    Else Register.V:=False;
                  If (Register.A And $01)<>0 Then Register.C:=True
                    Else Register.C:=False;
                End;
          $07 : Begin                                                { TPA  }
                  Ml:=$C0;
                  If Register.H Then Ml:=Ml OR $20;
                  If Register.I Then Ml:=Ml OR $10;
                  If Register.N Then Ml:=Ml OR $08;
                  If Register.Z Then Ml:=Ml OR $04;
                  If Register.V Then Ml:=Ml OR $02;
                  If Register.C Then Ml:=Ml OR $01;
                End;
          $08 : Begin                                                { INX  }
                  Inc(Register.IX);
                  If Register.IX=0 Then Register.Z:=True
                    Else Register.Z:=False;
                End;
          $09 : Begin                                                { DEX  }
                  Dec(Register.IX);
                  If Register.IX=0 Then Register.Z:=True
                    Else Register.Z:=False;
                End;
          $0A : Test_Res(0,'*','*','*','*','R','*');                 { CLV  }
          $0B : Test_Res(0,'*','*','*','*','S','*');                 { SEV  }
          $0C : Test_Res(0,'*','*','*','*','*','R');                 { CLC  }
          $0D : Test_Res(0,'*','*','*','*','*','S');                 { SEC  }
          $0E : Test_Res(0,'*','R','*','*','*','*');                 { CLI  }
          $0F : Test_Res(0,'*','S','*','*','*','*');                 { SEI  }
          $30 : Register.IX:=Register.SP+1;                          { TSX  }
          $31 : Inc(Register.SP);                                    { INS  }
          $34 : Dec(Register.SP);                                    { DES  }
          $35 : Register.SP:=Register.IX-1;                          { TXS  }
          $1B : ASM                                                  { ABA  }
                      MOV  AH,$01
                      MOV  Register.N,AH
                      MOV  Register.Z,AH
                      MOV  Register.V,AH
                      MOV  Register.C,AH
                      MOV  Register.H,AH
                      MOV  AL,Register.A
                      MOV  BL,Register.B
                      ADD  AL,BL
                      JS   @1
                      MOV  Register.N,$00
                  @1: JZ   @2
                      MOV  Register.Z,$00
                  @2: JO   @3
                      MOV  Register.V,$00
                  @3: JC   @4
                      MOV  Register.C,$00
                  @4: JA   @5
                      MOV  Register.H,$00
                  @5: MOV  Register.A,AL
                End;
          $36 : Begin                                                { PSHA }
                  SetChangeByte(Register.SP);
                  SetByte(Register.SP,Register.A);
                  Dec(Register.SP);
                End;
          $37 : Begin                                                { PSHB }
                  SetChangeByte(Register.SP);
                  SetByte(Register.SP,Register.B);
                  Dec(Register.SP);
                End;
          $32 : Begin                                                { PULA }
                  Inc(Register.SP);
                  GetByte(Register.SP,Register.A);
                End;
          $33 : Begin                                                { PULB }
                  Inc(Register.SP);
                  GetByte(Register.SP,Register.B);
                End;
          $39 : Begin                                                { RTS  }
                  Inc(Register.SP); GetByte(Register.SP,Mh);
                  Inc(Register.SP); GetByte(Register.SP,Ml);
                  Register.IP:=Ml+256*Mh;
                End;
          $3B : Begin                                                { RTI  }
                  { ????????????????????????????????????????????? }
                End;
          $3F : ;                                                    { SWI  }
          $4F : Begin                                                { CLRA }
                  Register.A:=0;
                  Test_Res(0,'*','*','R','S','R','R');
                End;
          $5F : Begin                                                { CLRB }
                  Register.B:=0;
                  Test_Res(0,'*','*','R','S','R','R');
                End;
          $11 : ASM                                                  { CBA  }
                      MOV  AH,$01
                      MOV  Register.N,AH
                      MOV  Register.Z,AH
                      MOV  Register.V,AH
                      MOV  Register.C,AH
                      MOV  AL,Register.A
                      MOV  BL,Register.B
                      SUB  AL,BL
                      JS   @1
                      MOV  Register.N,$00
                  @1: JZ   @2
                      MOV  Register.Z,$00
                  @2: JO   @3
                      MOV  Register.V,$00
                  @3: JC   @4
                      MOV  Register.C,$00
                  @4:
                End;
          $43 : Begin
                  Register.A:=Not Register.A;
                  Test_Res(Register.A,'*','*','|','|','R','S');
                End;
          $53 : Begin
                  Register.B:=Not Register.B;
                  Test_Res(Register.B,'*','*','|','|','R','S');
                End;
          $40 : Begin
                  Register.A:=-Register.A;
                  Test_Res(Register.A,'*','*','|','|','1','2');
                End;
          $50 : Begin
                  Register.B:=-Register.B;
                  Test_Res(Register.B,'*','*','|','|','1','2');
                End;
          $4A : Begin                                                { DECA }
                  Dec(Register.A);
                  Test_Res(Register.A,'*','*','|','|','4','*');
                End;
          $5A : Begin                                                { DECB }
                  Dec(Register.B);
                  Test_Res(Register.B,'*','*','|','|','4','*');
                End;
          $4C : Begin                                                { INCA }
                  Inc(Register.A);
                  Test_Res(Register.A,'*','*','|','|','5','*');
                End;
          $5C : Begin                                                { INCB }
                  Inc(Register.B);
                  Test_Res(Register.B,'*','*','|','|','5','*');
                End;
          $10 : ASM                                                  { SBA  }
                      MOV  AH,$01
                      MOV  Register.N,AH
                      MOV  Register.Z,AH
                      MOV  Register.V,AH
                      MOV  Register.C,AH
                      MOV  AL,Register.A
                      MOV  BL,Register.B
                      SUB  AL,BL
                      JS   @1
                      MOV  Register.N,$00
                  @1: JZ   @2
                      MOV  Register.Z,$00
                  @2: JO   @3
                      MOV  Register.V,$00
                  @3: JC   @4
                      MOV  Register.C,$00
                  @4:
                End;
          $49 : Begin                                                { ROLA }
                  ASM
                        MOV  CL,Register.C
                        MOV  Register.C,$01
                        OR   CL,CL
                        JZ   @0
                        STC
                    @0: MOV  AL,Register.A
                        RCL  AL,$01
                        JC   @1
                        MOV  Register.C,$00
                    @1: MOV  Register.A,AL
                  End;
                  Test_Res(Register.A,'*','*','|','|','6','*');
                End;
          $59 : Begin                                                { ROLB }
                  ASM
                        MOV  CL,Register.C
                        MOV  Register.C,$01
                        OR   CL,CL
                        JZ   @0
                        STC
                    @0: MOV  AL,Register.B
                        RCL  AL,$01
                        JC   @1
                        MOV  Register.C,$00
                    @1: MOV  Register.B,AL
                  End;
                  Test_Res(Register.B,'*','*','|','|','6','*');
                End;
          $46 : Begin                                                { RORA }
                  ASM
                        MOV  CL,Register.C
                        MOV  Register.C,$01
                        OR   CL,CL
                        JZ   @0
                        STC
                    @0: MOV  AL,Register.A
                        RCR  AL,$01
                        JC   @1
                        MOV  Register.C,$00
                    @1: MOV  Register.A,AL
                  End;
                  Test_Res(Register.A,'*','*','|','|','6','*');
                End;
          $56 : Begin                                                { RORB }
                  ASM
                        MOV  CL,Register.C
                        MOV  Register.C,$01
                        OR   CL,CL
                        JZ   @0
                        STC
                    @0: MOV  AL,Register.B
                        RCR  AL,$01
                        JC   @1
                        MOV  Register.C,$00
                    @1: MOV  Register.B,AL
                  End;
                  Test_Res(Register.B,'*','*','|','|','6','*');
                End;
          $48 : Begin                                                { ASLA }
                  ASM
                        MOV  CL,Register.C
                        MOV  Register.C,$01
                        OR   CL,CL
                        JZ   @0
                        STC
                    @0: MOV  AL,Register.A
                        SAL  AL,$01
                        JC   @1
                        MOV  Register.C,$00
                    @1: MOV  Register.A,AL
                  End;
                  Test_Res(Register.A,'*','*','|','|','6','*');
                End;
          $58 : Begin                                                { ASLB }
                  ASM
                        MOV  CL,Register.C
                        MOV  Register.C,$01
                        OR   CL,CL
                        JZ   @0
                        STC
                    @0: MOV  AL,Register.B
                        SAL  AL,$01
                        JC   @1
                        MOV  Register.C,$00
                    @1: MOV  Register.B,AL
                  End;
                  Test_Res(Register.B,'*','*','|','|','6','*');
                End;
          $47 : Begin                                                { ASRA }
                  ASM
                        MOV  CL,Register.C
                        MOV  Register.C,$01
                        OR   CL,CL
                        JZ   @0
                        STC
                    @0: MOV  AL,Register.A
                        SAR  AL,$01
                        JC   @1
                        MOV  Register.C,$00
                    @1: MOV  Register.A,AL
                  End;
                  Test_Res(Register.A,'*','*','|','|','6','*');
                End;
          $57 : Begin                                                { ASRB }
                  ASM
                        MOV  CL,Register.C
                        MOV  Register.C,$01
                        OR   CL,CL
                        JZ   @0
                        STC
                    @0: MOV  AL,Register.B
                        SAR  AL,$01
                        JC   @1
                        MOV  Register.C,$00
                    @1: MOV  Register.B,AL
                  End;
                  Test_Res(Register.B,'*','*','|','|','6','*');
                End;
          $44 : Begin                                                { LSRA }
                  ASM
                        MOV  CL,Register.C
                        MOV  Register.C,$01
                        OR   CL,CL
                        JZ   @0
                        STC
                    @0: MOV  AL,Register.A
                        SHR  AL,$01
                        JC   @1
                        MOV  Register.C,$00
                    @1: MOV  Register.A,AL
                  End;
                  Test_Res(Register.A,'*','*','|','|','6','*');
                End;
          $54 : Begin                                                { LSRB }
                  ASM
                        MOV  CL,Register.C
                        MOV  Register.C,$01
                        OR   CL,CL
                        JZ   @0
                        STC
                    @0: MOV  AL,Register.B
                        SHR  AL,$01
                        JC   @1
                        MOV  Register.C,$00
                    @1: MOV  Register.B,AL
                  End;
                  Test_Res(Register.B,'*','*','|','|','6','*');
                End;
          $16 : Begin                                                { TAB  }
                  Register.B:=Register.A;
                  Test_Res(Register.B,'*','*','|','|','R','*');
                End;
          $17 : Begin                                                { TBA  }
                  Register.A:=Register.B;
                  Test_Res(Register.A,'*','*','|','|','R','*');
                End;
          $4D : Test_Res(Register.A,'*','*','|','|','R','R');        { TSTA }
          $5D : Test_Res(Register.B,'*','*','|','|','R','R');        { TSTB }

      End;
    End
    Else
    Begin
      Op:=Get_Op(Command[Comm].T_Add,Command[Comm].N_Op,Command[Comm].Acc);
      If Command[Comm].T_Add=Rel Then
        If (Op And $8080)>0 Then Op:=Op-256;
      Case Comm of
        $20 :   Register.IP:=Register.IP+Op;                         { BRA  }
        $22 :   If Not (Register.C Or Register.Z) Then               { BHI  }
                  Register.IP:=Register.IP+Op;
        $23 :   If (Register.C Or Register.Z) Then                   { BLS  }
                  Register.IP:=Register.IP+Op;
        $24 :   If Not Register.C Then Register.IP:=Register.IP+Op;  { BCC  }
        $25 :   If Register.C Then Register.IP:=Register.IP+Op;      { BCS  }
        $26 :   If Not Register.Z Then Register.IP:=Register.IP+Op;  { BNE  }
        $27 :   If Register.Z Then Register.IP:=Register.IP+Op;      { BEQ  }
        $28 :   If Not Register.V Then Register.IP:=Register.IP+Op;  { BVC  }
        $29 :   If Register.V Then Register.IP:=Register.IP+Op;      { BVS  }
        $2A :   If Not Register.N Then Register.IP:=Register.IP+Op;  { BPL  }
        $2B :   If Register.N Then Register.IP:=Register.IP+Op;      { BMI  }
        $2C :   If Not (Register.N XOR Register.V) Then              { BGQ  }
                  Register.IP:=Register.IP+Op;
        $2D :   If (Register.N XOR Register.V) Then                  { BLT  }
                  Register.IP:=Register.IP+Op;
        $2E :   If Not ((Register.N Xor Register.V) And Register.Z)  { BGT  }
                  Then Register.IP:=Register.IP+Op;
        $2F :   If (Register.N Xor Register.V) Or Register.Z Then    { BLE  }
                  Register.IP:=Register.IP+Op;
        $8D :   Begin                                                { BSR  }
                  SetChangeByte(Register.SP);
                  SetChangeByte(Register.SP-1);
                  SetByte(Register.SP,Register.IP And $00FF);
                  Dec(Register.SP);
                  SetByte(Register.SP,(Register.IP And $FF00) Shr 8);
                  Dec(Register.SP); Register.IP:=Register.IP+Op;
                End;
        $6E,$7E : Register.IP:=Op;                                   { JMP  }
        $AD,$BD :   Begin                                            { JSR  }
                      SetChangeByte(Register.SP);
                      SetChangeByte(Register.SP-1);
                      SetByte(Register.SP,Register.IP And $00FF);
                      Dec(Register.SP);
                      SetByte(Register.SP,(Register.IP And $FF00) Shr 8);
                      Dec(Register.SP); Register.IP:=Op;
                    End;
        $8B,$9B,$AB,$BB: ASM                                         { ADDA }
                               MOV  AH,$01
                               MOV  Register.N,AH
                               MOV  Register.Z,AH
                               MOV  Register.V,AH
                               MOV  Register.C,AH
                               MOV  Register.H,AH
                               MOV  AL,Register.A
                               MOV  BX,Op
                               ADD  AL,BL
                               JS   @1
                           @1: MOV  Register.N,$00
                               JZ   @2
                               MOV  Register.Z,$00
                           @2: JO   @3
                               MOV  Register.V,$00
                           @3: JC   @4
                               MOV  Register.C,$00
                           @4: JA   @5
                               MOV  Register.H,$00
                           @5: MOV  Register.A,AL
                         End;
        $8C,$9C,$AC,$BC: Begin                                       { CPX  }
                           AuxW:=Register.IX-Abs(Op);
                           Test_Res(AuxW,'*','*','7','|','8','*');
                         End;
        $CE,$DE,$EE,$FE: Begin                                       { LDX  }
                           Register.IX:=Op;
                           Test_Res(Op,'*','*','9','|','R','*');
                         End;
        $8E,$9E,$AE,$BE: Begin                                       { LDS  }
                           Register.SP:=Op;
                           Test_Res(Op,'*','*','9','|','R','*');
                         End;
        $DF,$EF,$FF    : Begin                                       { STX  }
                           SetChangeByte(Register.RetAddr);
                           SetChangeByte(Register.RetAddr+1);

                           SetByte(Register.RetAddr,(Register.IX And $FF00) Shr 8);
                           SetByte(Register.RetAddr+1,Register.IX And $00FF);

                           Test_Res(Register.IX,'*','*','9','|','R','*');
                         End;
        $9F,$AF,$BF    : Begin                                       { STS  }
                           SetChangeByte(Register.RetAddr);
                           SetChangeByte(Register.RetAddr+1);

                           SetByte(Register.RetAddr,(Register.SP And $FF00) Shr 8);
                           SetByte(Register.RetAddr+1,Register.SP And $00FF);

                           Test_Res(Register.SP,'*','*','9','|','R','*');
                         End;
        $CB,$DB,$EB,$FB: ASM                                         { ADDB }
                               MOV  AH,$01
                               MOV  Register.N,AH
                               MOV  Register.Z,AH
                               MOV  Register.V,AH
                               MOV  Register.C,AH
                               MOV  Register.H,AH
                               MOV  AL,Register.B
                               MOV  BX,Op
                               ADD  AL,BL
                               JS   @1
                               MOV  Register.N,$00
                           @1: JZ   @2
                               MOV  Register.Z,$00
                           @2: JO   @3
                               MOV  Register.V,$00
                           @3: JC   @4
                               MOV  Register.C,$00
                           @4: JA   @5
                               MOV  Register.H,$00
                           @5: MOV  Register.B,AL
                         End;
        $81,$91,$A1,$B1: ASM                                        { CMPA }
                               MOV  AH,$01
                               MOV  Register.N,AH
                               MOV  Register.Z,AH
                               MOV  Register.V,AH
                               MOV  Register.C,AH
                               MOV  AL,Register.A
                               MOV  BX,Op
                               CMP  AL,BL
                               JS   @1
                               MOV  Register.N,$00
                           @1: JZ   @2
                               MOV  Register.Z,$00
                           @2: JO   @3
                               MOV  Register.V,$00
                           @3: JC   @4
                               MOV  Register.C,$00
                           @4:
                         End;
        $C1,$D1,$E1,$F1: ASM                                         { CMPB }
                               MOV  AH,$01
                               MOV  Register.N,AH
                               MOV  Register.Z,AH
                               MOV  Register.V,AH
                               MOV  Register.C,AH
                               MOV  AL,Register.B
                               MOV  BX,Op
                               CMP  AL,BL
                               JS   @1
                               MOV  Register.N,$00
                           @1: JZ   @2
                               MOV  Register.Z,$00
                           @2: JO   @3
                               MOV  Register.V,$00
                           @3: JC   @4
                               MOV  Register.C,$00
                           @4:
                         End;
        $89,$99,$A9,$B9: ASM                                         { ADCA }
                               MOV  AH,$01
                               MOV  Register.N,AH
                               MOV  Register.Z,AH
                               MOV  Register.V,AH
                               MOV  Register.H,AH
                               MOV  CL,Register.C
                               OR   CL,CL
                               JZ   @0
                               STC
                           @0: MOV  AL,Register.A
                               MOV  BX,Op
                               ADC  AL,BL
                               JS   @1
                               MOV  Register.N,$00
                           @1: JZ   @2
                               MOV  Register.Z,$00
                           @2: JO   @3
                               MOV  Register.V,$00
                           @3: MOV  Register.C,$01
                               JC   @4
                               MOV  Register.C,$00
                           @4: JA   @5
                               MOV  Register.H,$00
                           @5: MOV  Register.A,AL
                         End;
        $C9,$D9,$E9,$F9: ASM                                         { ADCB }
                               MOV  AH,$01
                               MOV  Register.N,AH
                               MOV  Register.Z,AH
                               MOV  Register.V,AH
                               MOV  Register.H,AH
                               MOV  CL,Register.C
                               OR   CL,CL
                               JZ   @0
                               STC
                           @0: MOV  AL,Register.B
                               MOV  BX,Op
                               ADC  AL,BL
                               JS   @1
                               MOV  Register.N,$00
                           @1: JZ   @2
                               MOV  Register.Z,$00
                           @2: JO   @3
                               MOV  Register.V,$00
                           @3: MOV  Register.C,$01
                               JC   @4
                               MOV  Register.C,$00
                           @4: JA   @5
                               MOV  Register.H,$00
                           @5: MOV  Register.B,AL
                         End;
        $84,$94,$A4,$B4: Begin                                       { ANDA }
                           Register.A:=Register.A And Op;
                           Test_Res(Register.A,'*','*','|','|','R','*');
                         End;
        $C4,$D4,$E4,$F4: Begin                                       { ANDB }
                           Register.B:=Register.B And Op;
                           Test_Res(Register.B,'*','*','|','|','R','*');
                         End;
        $85,$95,$A5,$B5: Begin                                       { BITA }
                           Aux:=Register.A And Op;
                           Test_Res(Aux,'*','*','|','|','R','*');
                         End;
        $C5,$D5,$E5,$F5: Begin                                       { BITB }
                           Aux:=Register.B And Op;
                           Test_Res(Aux,'*','*','|','|','R','*');
                         End;
        $6D,$7D        : Begin                                       { TST  }
                           Test_Res(Op,'*','*','|','|','R','R');
                         End;
        $6F,$7F        : Begin                                       { CLR  }
                           SetChangeByte(Register.RetAddr);
                           SetByte(Register.RetAddr,$00);
                           Test_Res(0,'*','*','R','S','R','R');
                         End;
        $63,$73        : Begin                                       { COM  }
                           Aux:=Not Op; SetChangeByte(Register.RetAddr); 
                           SetByte(Register.RetAddr,Aux);
                           Test_Res(Aux,'*','*','|','|','R','S');
                         End;
        $60,$70        : Begin                                       { NEG  }
                           Aux:=-Op; SetChangeByte(Register.RetAddr);
                           SetByte(Register.RetAddr,Aux);
                           Test_Res(Aux,'*','*','|','|','1','2');
                         End;
        $6A,$7A        : Begin                                       { DEC  }
                           Op:=Op And $FF;
                           Dec(Op); SetChangeByte(Register.RetAddr);
                           SetByte(Register.RetAddr,Op);
                           Test_Res(Op,'*','*','|','|','4','*');
                         End;
        $6C,$7C        : Begin                                       { INC  }
                           Inc(Op); SetChangeByte(Register.RetAddr);
                           SetByte(Register.RetAddr,Op);
                           Test_Res(Op,'*','*','|','|','5','*');
                         End;
        $69,$79        : Begin                                       { ROL  }
                           Aux:=Op;
                           ASM
                                 MOV  CL,Register.C
                                 MOV  Register.C,$01
                                 OR   CL,CL
                                 JZ   @0
                                 STC
                             @0: MOV  AL,Aux
                                 RCL  AL,$01
                                 JC   @1
                                 MOV  Register.C,$00
                             @1: MOV  Aux,AL
                           End;
                           SetChangeByte(Register.RetAddr);
                           SetByte(Register.RetAddr,Aux);
                           Test_Res(Aux,'*','*','|','|','6','*');
                         End;
        $66,$76        : Begin                                       { ROR  }
                           Aux:=Op;
                           ASM
                                 MOV  CL,Register.C
                                 MOV  Register.C,$01
                                 OR   CL,CL
                                 JZ   @0
                                 STC
                             @0: MOV  AL,Aux
                                 RCR  AL,$01
                                 JC   @1
                                 MOV  Register.C,$00
                             @1: MOV  Aux,AL
                           End;
                           SetChangeByte(Register.RetAddr);
                           SetByte(Register.RetAddr,Aux);
                           Test_Res(Aux,'*','*','|','|','6','*');
                         End;
        $67,$77        : Begin                                       { ASR  }
                           Aux:=Op;
                           ASM
                                 MOV  CL,Register.C
                                 MOV  Register.C,$01
                                 OR   CL,CL
                                 JZ   @0
                                 STC
                             @0: MOV  AL,Aux
                                 SAR  AL,$01
                                 JC   @1
                                 MOV  Register.C,$00
                             @1: MOV  Aux,AL
                           End;
                           SetChangeByte(Register.RetAddr);
                           SetByte(Register.RetAddr,Aux);
                           Test_Res(Aux,'*','*','|','|','6','*');
                         End;
        $68,$78        : Begin                                       { ASL  }
                           Aux:=Op;
                           ASM
                                 MOV  CL,Register.C
                                 MOV  Register.C,$01
                                 OR   CL,CL
                                 JZ   @0
                                 STC
                             @0: MOV  AL,Aux
                                 SAL  AL,$01
                                 JC   @1
                                 MOV  Register.C,$00
                             @1: MOV  Aux,AL
                           End;
                           SetChangeByte(Register.RetAddr);
                           SetByte(Register.RetAddr,Aux);
                           Test_Res(Aux,'*','*','|','|','6','*');
                         End;
        $64,$74        : Begin                                       { LSR  }
                           Aux:=Op;
                           ASM
                                 MOV  CL,Register.C
                                 MOV  Register.C,$01
                                 OR   CL,CL
                                 JZ   @0
                                 STC
                             @0: MOV  AL,Aux
                                 SHR  AL,$01
                                 JC   @1
                                 MOV  Register.C,$00
                             @1: MOV  Aux,AL
                           End;
                           SetChangeByte(Register.RetAddr);
                           SetByte(Register.RetAddr,Aux);
                           Test_Res(Aux,'*','*','R','|','6','*');
                         End;
        $97,$A7,$B7    : Begin                                       { STAA }
                           SetChangeByte(Register.RetAddr);
                           SetByte(Register.RetAddr,Register.A);
                           Test_Res(Register.A,'*','*','|','|','R','*');
                         End;
        $D7,$E7,$F7    : Begin                                       { STAB }
                           SetChangeByte(Register.RetAddr);
                           SetByte(Register.RetAddr,Register.B);
                           Test_Res(Register.B,'*','*','|','|','R','*');
                         End;
        $8A,$9A,$AA,$BA: Begin                                       { ORAA }
                           Register.A:=Register.A Or Op;
                           Test_Res(Register.A,'*','*','|','|','R','*');
                         End;
        $CA,$DA,$EA,$FA: Begin                                       { ORAB }
                           Register.B:=Register.B Or Op;
                           Test_Res(Register.B,'*','*','|','|','R','*');
                         End;
        $86,$96,$A6,$B6: Begin                                       { LDAA }
                           Register.A:=Op;
                           Test_Res(Op,'*','*','|','|','R','*');
                         End;
        $C6,$D6,$E6,$F6: Begin                                       { LDAB }
                           Register.B:=Op;
                           Test_Res(Op,'*','*','|','|','R','*');
                         End;
        $88,$98,$A8,$B8: Begin                                       { EORA }
                           Register.A:=Register.A Xor Op;
                           Test_Res(Op,'*','*','|','|','R','*');
                         End;
        $C8,$D8,$E8,$F8: Begin                                       { EORB }
                           Register.B:=Register.B Xor Op;
                           Test_Res(Op,'*','*','|','|','R','*');
                         End;
        $80,$90,$A0,$B0: ASM                                         { SUBA }
                               MOV  AH,$01
                               MOV  Register.N,AH
                               MOV  Register.Z,AH
                               MOV  Register.V,AH
                               MOV  Register.C,AH
                               MOV  AL,Register.A
                               MOV  BX,Op
                               SUB  AL,BL
                               JS   @1
                               MOV  Register.N,$00
                           @1: JZ   @2
                               MOV  Register.Z,$00
                           @2: JO   @3
                               MOV  Register.V,$00
                           @3: JC   @4
                               MOV  Register.C,$00
                           @4: MOV  Register.A,AL
                         End;
        $C0,$D0,$E0,$F0: ASM                                         { SUBB }
                               MOV  AH,$01
                               MOV  Register.N,AH
                               MOV  Register.Z,AH
                               MOV  Register.V,AH
                               MOV  Register.C,AH
                               MOV  AL,Register.B
                               MOV  BX,Op
                               SUB  AL,BL
                               JS   @1
                               MOV  Register.N,$00
                           @1: JZ   @2
                               MOV  Register.Z,$00
                           @2: JO   @3
                               MOV  Register.V,$00
                           @3: JC   @4
                               MOV  Register.C,$00
                           @4: MOV  Register.B,AL
                         End;
        $82,$92,$A2,$B2: ASM                                         { SBCA }
                               MOV  AH,$01
                               MOV  Register.N,AH
                               MOV  Register.Z,AH
                               MOV  Register.V,AH
                               MOV  CL,Register.C
                               OR   CL,CL
                               JZ   @0
                               STC
                           @0: MOV  AL,Register.A
                               MOV  BX,Op
                               SBB  AL,BL
                               JS   @1
                               MOV  Register.N,$00
                           @1: JZ   @2
                               MOV  Register.Z,$00
                           @2: JO   @3
                               MOV  Register.V,$00
                           @3: MOV  Register.C,$01
                               JC   @4
                               MOV  Register.C,$00
                           @4: MOV  Register.A,AL
                         End;
        $C2,$D2,$E2,$F2: ASM                                         { SBCB }
                               MOV  AH,$01
                               MOV  Register.N,AH
                               MOV  Register.Z,AH
                               MOV  Register.V,AH
                               MOV  CL,Register.C
                               OR   CL,CL
                               JZ   @0
                               STC
                           @0: MOV  AL,Register.B
                               MOV  BX,Op
                               SBB  AL,BL
                               JS   @1
                               MOV  Register.N,$00
                           @1: JZ   @2
                               MOV  Register.Z,$00
                           @2: JO   @3
                               MOV  Register.V,$00
                           @3: MOV  Register.C,$01
                               JC   @4
                               MOV  Register.C,$00
                           @4: MOV  Register.B,AL
                         End;
      End;
    End;
END;

Procedure TMemoryMc.ClearDebuger;
Begin Debug:=False; End;

Procedure TMemoryMc.StartDebuger;
Begin
  Debug:=True;
  Register.IP:=BeginMemPrg;
  DebugAddress:=Register.IP;
End;

Function TMemoryMc.GetTime;
Begin
  SaveRegisters; GetCommand;
  GetTime:=CommandTime(Comm);
  UndoRegisters;
End;

Function TMemoryMc.CommandTime;
Begin
  CommandTime:=Command[Acomm].Time;
End;

Begin
  MemoryMc := Nil;
End.
