Program Mc;

{$M 32764, 0, 655350 }

Uses
  McUnit, McVis, App, Objects, Menus, Drivers, StdDlg, DOS, Views,
  Dialogs, Memory, McConst, Puzzle, Crt;

Const
  CNewColor = #$4F#$3;

Type
  PAppMc=^TAppMc;
  TAppMc=Object(TApplication)
    Command,LastComm    : Byte;
    RunF,Runb           : Boolean;
    TimeAnimate,OldTime : LongInt;
    BreakRun,brAddress  : Word;
    ReadAddress         : Word;
    Constructor Init;
    Procedure InitMenuBar; Virtual;
    Procedure InitStatusLine; Virtual;
    Procedure SetValueReadAddress;
    Procedure GetReadAddress;
    Procedure HAndleEvent(Var Event:TEvent); Virtual;
    Procedure Idle; Virtual;
    Function  GetPalette: PPalette; Virtual;
    Function  GetMyTime : Longint;
  End;

Constructor TAppMc.Init;
Begin
  TApplication.Init;
  ReadAddress:=0; TimeAnimate:=0;
  BreakRun:=Br_BreakPointer;
  MemoryMc^.ClearDebuger;
  RunF:=False; RunB:=False;
End;

Procedure TAppMc.SetValueReadAddress;
Var
  Ptr : PMenuItem;
Begin
  Ptr:=MenuBar^.HotKey(kbAltF);
  If Ptr^.Param<>Nil Then
    Begin
      Str(ReadAddress:5,Ptr^.Param^);
      While Pos(' ',Ptr^.Param^)<>0 Do Ptr^.Param^[Pos(' ',Ptr^.Param^)]:='0';
    End;
End;

Procedure TAppMc.InitMenuBar;
Var
  R : TRect;
  S : String;
Begin
  GetExtent(R);
  R.B.Y:=R.A.Y+1;
  MenuBar:=New(PMenuBar,Init(R,NewMenu(
    NewSubMenu('~~',0,NewMenu(
      NewItem('A~b~out','Alt-B',kbAltB,cmAbout,0,
      NewItem('~P~uzzle','Alt-G',kbAltG,cmPuzzle,0,Nil))),
    NewSubMenu('~F~iles',0,NewMenu(
      NewItem('~P~rograms','F3',kbF3,cmRead,0,
      NewLine(
      NewItem('~P~rint','Alt-P',kbAltP,cmPrint,0,
      NewLine(
      NewItem('~C~hange dir...', '', kbNoKey, cmChangeDir, hcNoContext,
      NewItem('~D~OS shell', '', kbNoKey, cmDosShell,0,
      NewItem('E~x~it','Alt-X',kbAltX,cmQuit,0,Nil)))))))),
    NewSubMenu('~V~iew',0,NewMenu(
      NewItem('~M~emory','Alt-M',kbAltM,cmMemoryMc,0,
      NewItem('~R~egisters','Alt-R',kbAltR,cmRegistersMc,0,
      NewItem('~C~PU','F9',kbF9,cmCPUMc,0,
      NewItem('~T~ime','Alt-T',kbAltT,cmTime,0,
      NewItem('Stac~k~','Alt-K',kbAltK,cmStack,0,Nil)))))),
    NewSubMenu('~D~ebug',0,NewMenu(
      NewItem('~B~reak Point','Ctrl-F8',kbCtrlF8,cmSetBreakPointer,0,
      NewItem('~S~tep','F8',kbF8,cmStep,0,
      NewItem('~R~un','Ctrl-F9',kbCtrlF9,cmRun,0,
      NewItem('~G~o to cursor','F4',kbF4,cmGotoAddress,0,
      NewItem('~P~rogram reset','Ctrl-F2',kbCtrlF2,cmClearDebuger,0,Nil)))))),
    NewSubMenu('~W~indow',0,NewMenu(
      NewItem('~C~lose Window','Alt-F3',kbAltF3,cmClose,0,
      NewItem('~R~esize','Ctrl-F5',kbCTRLF5,cmReSize,0,
      NewItem('~Z~oom','F5',kbF5,cmZoom,0,
      NewItem('~N~ext','F6',kbF6,cmNExt,0,
      NewItem('~P~revious','ShIft-F6',kbShIftF6,cmPrev,0,Nil)))))),
    NewSubMenu('~O~ptions',0,NewMenu(
      NewItem('~S~ystem counting','Alt-S',kbAltS,cmViewStAndart,0,
      NewItem('~A~nimate','Alt-A',kbAltA,cmAnimate,0,Nil))),
    Nil)))))))));
  SetValueReadAddress;
End;

Procedure TAppMc.InitStatusLine;
Var
  R : TRect;
Begin
  GetExtent(R);
  R.A.Y:=R.B.Y-1;
  StatusLine:=New(PStatusLine,Init(R,
    NewStatusDef(0,$FFFF,
      NewStatusKey('~Alt-X~ Exit',kbAltX,cmQuit,
      NewStatusKey('~F10~ Menu',kbF10,cmMenu,
      NewStatusKey('~F8~ Step',kbF8,cmStep,
      NewStatusKey('~Ctrl-F9~ Run',kbCtrlF9,cmRun,
      NewStatusKey('~Alt-R~ Regs',kbAltR,cmRegistersMc,
      NewStatusKey('~F2~ Stop' ,kbF2,cmInterupt,
      NewStatusKey('~Ctrl-F2~ Reset' ,kbCtrlF2,cmClearDebuger,
      nil))))))),
    nil)));
End;

Procedure TAppMc.GetReadAddress;
Var
  D    : PDialog;
  R    : TRect;
  I    : PInputLine;
  S    : String;
  Code : Integer;
Begin
  R.Assign( 0, 0,30, 7);
  D:=New(PDialog,Init(R,'Loading Address'));
  D^.Options:=D^.Options Or OfCentered;
  R.Assign( 1, 4,11, 6);
  D^.Insert(New(PButton,Init( R,'~O~k',cmOk,BfDefault)));
  R.Assign(18, 4,28, 6);
  D^.Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));
  R.Assign(18, 2,28, 3);
  I:=New(PInputLine,Init(R,5));
  D^.Insert(I);
  R.Assign( 1, 2,16, 3);
  D^.Insert(New(PLabel,Init(R,'Read Address :',I)));
  Str(ReadAddress,S); I^.SetData(S);
  If ValidView(D)<>Nil Then
  Begin
    If Desktop^.ExecView(D)<>cmCancel Then
      Begin I^.GetData (S); Val(S,ReadAddress,Code); End;
    Dispose(D,Done);
  End;
  SetValueReadAddress; MemoryMc^.ClearDebuger; ReDraw;
End;

Procedure TAppMc.HandleEvent(Var Event: TEvent);
Var
  R   : TRect;

  Procedure Read;
  Var
    D        : PFileDialog;
    FileName : PathStr;
    Dir      : DirStr;
    Name     : NameStr;
    Ext      : ExtStr;
  Begin
    D:=New(PFileDialog,Init('*.*','Open a File','~N~ame',fDopenButton+fdHelpButton,100));
    If ValidView(D)<>nil Then
    Begin
      If Desktop^.ExecView(D)<>cmCancel Then
      Begin
        D^.GetFileName(FileName); FSplit(FileName,Dir,Name,Ext); Ext:=Copy(Ext,2,4);
        Ext[1]:=UpCase(Ext[1]); Ext[2]:=UpCase(Ext[2]); Ext[3]:=UpCase(Ext[3]);
        If Ext='ASM' Then MemoryMc^.ReadFile(FileName,ReadAddress)
          Else If Ext='LX' Then MemoryMc^.ReadLx(FileName, ReadAddress)
                 Else MemoryMc^.ReadData(FileName,ReadAddress);
      End;
      Dispose(D,Done);
    End;
    If CPUMcWindow<>Nil Then CPUMcWindow^.ReDraw;
    If MemoryMcWinDow<>Nil Then MemoryMcWinDow^.ReDraw;
    ClearEvent(Event);
  End;

  Procedure ViewStandart;
  Var
    D   : PDialog;
    R   : TRect;
    B   : PRadioButtons;
    Buf : Word;
  Begin
    R.Assign( 0, 0,30, 7); D:=New(PDialog,Init(R,'Counting system'));
    D^.Options:=D^.Options Or ofCentered;
    D^.SetState(sfCursorVis,False);
    R.Assign( 2, 2,14, 5); B:=New(PRadioButtons,Init(R,NewSItem('Oct',NewSItem('Dec',NewSItem('Hex',Nil)))));
    R.Assign(15, 2,25, 4); D^.Insert(New(PButton,Init(R,'~O~k',cmOk,bfDefault)));
    R.Assign(15, 4,25, 6); D^.Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));
    R.Assign( 1, 1,12, 2); D^.Insert(New(PLabel,Init(R,'Systems',B)));
    D^.Insert(B);
    Case Config.TypeViewSystem of
      tt_OCT: Buf:=0;
      tt_DEC: Buf:=1;
      tt_HEX: Buf:=2;
    End;
    B^.SetData(Buf);
    If ValidView(D)<>Nil Then
    Begin
      If Desktop^.ExecView(D)<>cmCancel Then
      Begin
        B^.GetData(Buf);
        Case Buf of
          0 : Config.TypeViewSystem:=tt_OCT;
          1 : Config.TypeViewSystem:=tt_DEC;
          2 : Config.TypeViewSystem:=tt_HEX;
        End;
      End;
      Dispose(D,Done);
    End;
    If MemoryMcWindow<>Nil Then MemoryMcWindow^.ReDraw;
    If RegistersMcWindow<>Nil Then RegistersMcWindow^.ReDraw;
    If StackWindow<>Nil Then StackWindow^.ReDraw;
    If CPUMcWindow<>Nil Then CPUMcWindow^.ReDraw;
    ClearEvent(Event);
  End;

  Procedure Animate;
  Var
    D   : PDialog;
    R   : TRect;
    I   : PInputLine;
    Buf : String;
    Err : Integer;
  Begin
    R.Assign( 0, 0,30, 7); D:=New(PDialog,Init(R,'Animate'));
    D^.Options:=D^.Options or ofCentered; D^.SetState(sfCursorVis,False);
    R.Assign(20, 2,26, 3); I:=New(PInputLine,Init(R,3));
    R.Assign( 2, 4,12, 6); D^.Insert(New(PButton,Init(R,'~O~k',cmOk,bfDefault)));
    R.Assign(17, 4,27, 6); D^.Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));
    R.Assign( 1, 2,20, 3); D^.Insert(New(PLabel,Init(R,'~A~nimation delay : ',I)));
    D^.Insert(I); Str(TimeAnimate,Buf); I^.SetData(Buf);
    If ValidView(D)<>nil Then
      Begin
        If Desktop^.ExecView(D)<>cmCancel Then Begin I^.GetData(Buf); Val(Buf,TimeAnimate,Err); End;
        Dispose(D,Done);
      End;
    If MemoryMcWinDow<>Nil Then MemoryMcWinDow^.ReDraw;
    If RegistersMcWinDow<>Nil Then RegistersMcWinDow^.ReDraw;
    If TimeWindow<>Nil Then TimeWindow^.ReDraw;
    if TimeAnimate=0 then BreakRun := BreakRun and not (br_View)
      else BreakRun := BreakRun or br_View;
    ClearEvent(Event);
  End;

  Procedure PrintProgram;
  Var
    Line    : String;
    NumByte : Byte;
    A       : Word;
    Pr      : Text;
    PrErr   : Boolean;
    Procedure PrintLn(S: String);
    Begin
      {$I-} WriteLn(Pr,S); {$I+}
      If IOResult<>0 Then PrErr:=True;
    End;
  Begin
    Assign(Pr,'PRN'); Rewrite(Pr); PrErr:=False;
    A:= MemoryMc^.BeginMEMPRG; PrErr:=False;
    While (A<MemoryMc^.EndMEMPRG) And Not PrErr Do Begin
      MemoryMc^.Disassembling (A,Line,NumByte);
      PrintLn(Line); A:=A+NumByte;
    End;
    Close(Pr);
  End;

  Procedure About;
  Var
    D       : PDialog;
    Control : PView;
    R       : TRect;
  Begin
    R.Assign( 0, 0,40,12); D:=New(PDialog,Init(R,'About'));
    with D^ Do
    Begin
      Options:=Options or ofCentered; R.Grow(-1,-1); Dec(R.B.Y, 3);
      Insert(New(PStaticTExt,Init(R,#13+
        ^C' Mc 6800 Simulator'#13+
        ^C'Copyright (c) 1994'#13+
        ^C'     Ver  2.0     '#13+#13+
        ^C'   George Kukis   '#13+
        ^C'  Dinko  Mironov  ')));
      R.Assign(13, 9,27,11); Insert(New(PButton, Init(R,'O~K',cmOk,bfDefault)));
    End;
    If ValidView(D)<>Nil Then
      Begin If Desktop^.ExecView(D)=0 Then Begin End; Dispose(D,Done); End;
  End;

  procedure ChangeDir;
  var
    D: PChDirDialog;
  begin
    D:=New(PChDirDialog, Init(cdNormal, 0));
    if ValidView(D)<>nil then
      Begin If Desktop^.ExecView(D)=0 Then Begin End; Dispose(D,Done); End;
  end;

  Procedure DosShell;
  Begin
    DoneSysError; DoneEvents; DoneVideo; DoneMemory;
    SetMemTop(HeapPtr);
    PrintStr('Type EXIT to return...');
    SwapVectors;
    Exec(GetEnv('COMSPEC'), '');
    SwapVectors;
    SetMemTop(HeapEnd);
    InitMemory; InitVideo; InitEvents; InitSysError;
    Redraw;
  End;

  Procedure Puzzle;
  Var
    P: PPuzzleWinDow;
  Begin
    P:=New(PPuzzleWinDow,Init); P^.HelpCtx:=0;
    Desktop^.Insert(ValidView(P));
  End;

Begin
  Case Event.What of
    evCommand : Case Event.Command of
      cmRun          : Begin
                         RunF:=True;
                         If TimeAnimate=0
                           Then BreakRun:=Br_Command or Br_BreakPointer
                           Else BreakRun:=Br_Command or Br_BreakPointer or Br_View or br_Time;
                         Command:=$3F; OldTime:=GetMyTime;
                  {       EXIT;  ?????????? 2 ??????????????? }
                       End;
      cmStep         : If CPUMcWindow<>Nil Then
                        Begin
                          RunF:=True;
                          BreakRun:=Br_Command or Br_BreakPointer or br_NextAddress or Br_View;
                          Command:=$3F; OldTime:=GetMyTime;
                        End;
      cmGotoAddress  : If CPUMcWindow<>Nil Then
                       Begin
                         RunF:=True;
                         BreakRun:=Br_Command or br_Address or Br_BreakPointer;
                         brAddress:=CPUMcWindow^.CPUView^.CurrentAddress;
                         Command:=$3F; OldTime:=GetMyTime;
                       End;
      cmClearDebuger : Begin
                         Register.IP:=MemoryMC^.BeginMemPRG;
                         RunF:=False; MemoryMc^.ClearDebuger;
                         if CPUMCWindow<>Nil then CPUMCWindow^.CPUView^.InitPos(MemoryMC^.BeginMemPRG);
                         If RegistersMcWindow<>Nil Then RegistersMcWindow^.ReDraw;
                         If MemoryMcWindow<>Nil Then MemoryMcWindow^.ReDraw;
                         If CPUMcWindow<>Nil Then CPUMcWindow^.ReDraw;
                         If TimeWindow<>Nil Then TimeWindow^.TimeView^.HAndleEvent(Event);
                       End;
      cmInterupt     : Begin
                         RunF:=False; Event.What:=evCommand; Event.Command:=cmStepView;
                         If CPUMcWindow<>Nil Then CPUMcWindow^.CPUView^.HAndleEvent(Event);
                       End;
      cmStepCalc, cmStepCalcView :
                       Begin
                         MemoryMc^.Step; LastComm:=MemoryMc^.Comm;
                         if not (Event.Command=cmStepCalc) then
                           begin
                             If RegistersMcWindow<>Nil Then RegistersMcWindow^.ReDraw;
                             If MemoryMcWindow<>Nil Then MemoryMcWindow^.ReDraw;
                           end;
                         If CPUMcWindow<>Nil Then CPUMcWindow^.CPUView^.HandleEvent(Event);
                         If TimeWinDow<>Nil Then TimeWinDow^.TimeView^.HandleEvent(Event);
                         If StackWinDow<>Nil Then StackWinDow^.StackView^.HandleEvent(Event);
                     {    EXIT;  ????????? 1 ????????? }
                       End;
      cmRedrawMemory : If MemoryMcWinDow<>Nil Then MemoryMcWinDow^.ReDraw;
    End;
    evKeyDown : case Event.KeyCode of
      kbUp,kbDown : If RunF then Event.KeyCode:=0;
    end;
  End;
  TApplication.HAndleEvent(Event);
  Case Event.What of
    evCommand:
      Begin
        Case Event.Command of
           cmMemoryMc   : If MemoryMcWinDow=Nil Then
                             Begin
                               DeskTop^.GetExtent(R); R.B.X:=58;
                               MemoryMcWinDow:=New(PMemoryMcWinDow,Init(R,'Memory',0));
                               DeskTop^.Insert(MemoryMcWinDow);
                             End;
          cmRegistersMc : If RegistersMcWinDow=Nil Then
                             Begin
                               DeskTop^.GetExtent(R); R.A.X:=61;
                               RegistersMcWinDow:=New(PRegistersMcWinDow,Init(R,'Reg',0));
                               DeskTop^.Insert(RegistersMcWinDow);
                             End;
          cmCPUMc       : If CPUMcWindow=Nil Then
                             Begin
                               DeskTop^.GetExtent(R); Dec(R.B.X);
                               CPUMcWindow:=New(PCPUMcWindow,Init(R,'CPU Mc6800',0,MemoryMC^.BeginMemPRG));
                               DeskTop^.Insert(CPUMcWindow);
                             End;
          cmTime         : If TimeWindow=Nil Then
                             Begin
                               DeskTop^.GetExtent(R); Dec(R.B.X);
                               TimeWinDow:=New(PTimeWinDow,Init( R,' Time ',0));
                               DeskTop^.Insert(TimeWinDow);
                             End;
          cmStack        : If StackWindow=Nil Then
                             Begin
                               DeskTop^.GetExtent(R); Dec(R.B.X);
                               StackWinDow:=New(PStackWinDow,Init( R,' Stack ',0));
                               DeskTop^.Insert(StackWinDow);
                             End;
          cmRead         : Begin GetReadAddress; Read; End;
          cmViewStAndart : ViewStAndart;
          cmAnimate      : Animate;
          cmPrint        : PrintProgram;
          cmAbout        : About;
          cmPuzzle       : Puzzle;
          cmChangeDir    : ChangeDir;
          cmDosShell     : DosShell;
        End;
      End;
  End;
  ClearEvent(Event);  { ??????????? 3 ????????????? }
End;

Procedure TAppMc.Idle;
Var
  Event : TEvent;
  Comm  : Word;

  Procedure UpDate;
  Begin
    Event.What:=evCommand; Event.Command:=cmStepView;
    If CPUMcWindow<>Nil Then CPUMcWindow^.CPUView^.HandleEvent(Event);
    Event.What:=evCommand; Event.Command:=cmStepView;
    If RegistersMcWindow<>Nil Then RegistersMcWindow^.RegistersView^.HandleEvent(Event);
    Event.What:=evCommand; Event.Command:=cmStepView;
    If TimeWindow<>Nil Then TimeWindow^.TimeView^.HandleEvent(Event);
    Event.What:=evCommand; Event.Command:=cmStepView;
    If StackWindow<>Nil Then StackWindow^.StackView^.HandleEvent(Event);
  End;

Begin
  TApplication.Idle;
  If ((GetMyTime-OldTime>TimeAnimate) And ((BreakRun And br_Time)<>0)) or
      (TimeAnimate=0) or ((BreakRun And br_Time)=0) Then
    Begin
      If (BreakRun And Br_View)<>0 Then Comm:=cmStepCalcView Else Comm:=cmStepCalc;
      If RunF Then
        Begin
          If (BreakRun And Br_Command)<>0 Then
            If (LastComm=Command) And (MemoryMc^.Debug) Then
              Begin RunF:=False; UpDate; End;;
          If Not MemoryMc^.Debug Then
            Begin
              MemoryMc^.ReadData(MemoryMc^.FileData,MemoryMc^.AddressData);
              MemoryMc^.StartDebuger; LastComm:=01;
            End;
          If (Not RunB) And (LastComm=$3F) Then
            Begin
              MemoryMc^.ReadData(MemoryMc^.FileData,MemoryMc^.AddressData);
              MemoryMc^.StartDebuger; LastComm:=01;
              If TimeWinDow<>Nil Then TimeWinDow^.TimeView^.Clear;
            End;
          If RunB Then
            Begin
              If (BreakRun And br_Address)<>0 Then
                If MemoryMc^.DebugAddress=brAddress Then
                  Begin RunF:=False; UpDate; End;;
              If (BreakRun And Br_BreakPointer)<>0 Then
                If BreakPointer.ValidPointer(MemoryMc^.DebugAddress) Then
                  Begin RunF:=False; UpDate; End;;
              If (BreakRun And br_NextAddress)<>0 Then
                Begin RunF:=False; UpDate; End;;
            End;
          If RunF Then
            Begin
              Event.What:=evCommand; Event.Command:=Comm;
              Application^.PutEvent(Event); OldTime:=GetMyTime;
            End;
          If RunF And (Not RunB) And (LastComm=$3F) Then
            Begin
              RunF:=False; UpDate;
              MemoryMc^.ReadData(MemoryMc^.FileData,MemoryMc^.AddressData);
              MemoryMc^.StartDebuger; LastComm:=01;
            End;
        End;
      RunB:=RunF; MemoryMc^.DebugAddress:=Register.IP;
    End;
End;

Function  TAppMc.GetPalette: PPalette;
Const
  P:Array[apColor..apMonochrome] of string[Length(CColor)+Length(CNewColor)] =
    (CColor+CNewColor,CBlackWhite+CNewColor,CMonochrome+CNewColor);
Begin GetPalette:=@P[AppPalette]; End;

Function TAppMc.GetMyTime:Longint;
Var
  h, m, s, st : Word;
Begin
  GetTime(h,m,s,st);
  GetMyTime:={h*360000+}m*6000+s*100+st;
End;

Var
  McApp : TAppMc;
  m     : Longint;

Begin
  InitUnit;
  McApp.Init;
  McApp.Run;
  McApp.Done;
  DoneUnit;
End.