NAME    XTKB
;       [ - condensed  Toshiba P351
        TITLE   XTTX version 1.3
COMMENT 
PAGE  59,132



                                                                      
                              XTKB.Com                                
                                                                      
       Written by Dave Nanian                                         
       Commented by Roedy Green                                       
                                                                      
       Allows new 101-style keyboard to work with old XT BIOS         
       Fixes many but not all problems.                               
                                                                      


Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.1 1993 June 12
        - embed new address and phone number.
;

; M A C R O S

CR      MACRO   ; Carriage return line feed
        DB 0dh,0ah
        ENDM

;======

EOS     MACRO   ; marks end of display string
        DB 0dh,0ah,'$'
        ENDM

;======

Stack           Segment Stack
Stack           Ends

Code            segment
                assume  cs:Code, ds:Code


                org     100h

XTKB            proc    far

start:
                jmp     short Init

OldVec          dd      00000h                  ; will be filled in with
                                                ; old int 9 vector seg:off


;
;
;                       External Entry Point for INT 09
;
;

int_09h_entry   proc    far
                push    ax
                pushf                           ; Push ax & flags
                                                ; we disturb no other regs

                in      al,60h                  ; port 60h, keybd scan
                cmp     al,0E0h
                jne     UseOldInt9              ; Jump if not equal

                                                ; throw away any 0Es
                in      al,61h                  ; port 61h, 8255 port B, read
                mov     ah,al
                or      al,80h
                jmp     short Wait_1            ; Waste a little time
Wait_1:                                         ; to give port time to recover
                out     61h,al                  ; port 61h, 8255 B
                                                ; ack receipt of kbd char
                                                ; by setting high bit
                mov     al,ah
                jmp     short Wait_2            ; Waste a little time
Wait_2:
                out     61h,al                  ; port 61h, 8255 B
                                                ; put kbd port back way it was
                mov     al,20h
                out     20h,al                  ; port 20h, 8259-1 int command
                                                ;  al = 20h, end of interrupt

                                                ; return without
                                                ; executing old
                                                ; int 09 vector
                popf
                pop     ax
                iret                            ; Interrupt return

UseOldInt9:
                popf
                pop     ax
                jmp     cs:OldVec               ; carry on with
                                                ; original int 9
                                                ; code
int_09h_entry   endp

;
;
;                    I N I T I A L I Z A T I O N
;
;


Init:
                cli                             ; Disable interrupts
                                                ; Just in case someone
                                                ; moves INT 9.
                mov     al,9                    ; save old INT 9 vector
                mov     ah,35h                  ;
                int     21h                     ; DOS Services  ah=function 35h
                                                ;  get intrpt vector al in es:bx
                mov     word ptr cs:OldVec+2,es
                mov     word ptr cs:OldVec,bx
                mov     ax,cs
                mov     ds,ax
                mov     dx,offset int_09h_entry
                mov     al,9
                mov     ah,25h                  ; point INT 9 to us.
                int     21h                     ; DOS Services  ah=function 25h
                                                ;  set intrpt vector al to ds:dx
                sti                             ; Enable interrupts
                mov     dx,((init-code)+15d)/16d
                                                ; memory in paragraphs to keep
                                                ; Offsets don't do arithmetic
                xor     al,al
                mov     ah,31h
                int     21h                     ; DOS Services  ah=function 31h
                                                ;  terminate & stay resident

XTKB            endp


CopyrightMsg    label byte      ; does not display
        CR
        DB      ' XTKB 1.3 ۲'
        CR
        DB      'Freeware to tame the XT keyboard.'
        CR
        DB      'usage:  XTKB'
        CR
        DB      'Copyright (c) 1990-1999 Roedy Green Canadian Mind Products'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.'
        EOS


Code            ends

                end     start
